<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_PICKS_VS;
    $block_classes = [$block_name];
    $block_picks_vs = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $picks = get_field('picks');
    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (!empty($picks) && count($picks) > 0): ?>
                <div class="picks">
                    <?php foreach($picks as $pick):?>
                        <div class="pick">
                            <div class="pick-header">
                                <div class="content">
                                    <div class="sport"><span><?php echo $pick['category']; ?></span></div>
                                    <div class="date-time"><span><?php echo $pick['time']; ?></span></div>
                                    <div class="status"><span><?php echo $pick['status']; ?></span></div>
                                </div>
                            </div>
                            <div class="pick-body">
                                <?php if (isset($pick['teams']) && count($pick['teams']) > 0 && count($pick['teams']) == 2): ?>
                                    <div class="teams">
                                        <?php $teams = 0; ?>
                                        <?php foreach($pick['teams'] as $team): ?>
                                            <?php $class_team = ($teams == 0) ? 'team-a' : 'team-b'; ?>

                                            <div class="team <?php echo $class_team; ?>">
                                                <div class="team-logo">
                                                    <?php if (isset($team['logo']['url']) && $team['logo']['url'] != ''): ?>
                                                        <img src="<?php echo $team['logo']['url']; ?>" alt="">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="team-name"><span><?php echo $team['name']; ?></span></div>
                                            </div>

                                            <?php if ($teams == 0): ?>
                                                <div class="team team-vs">
                                                    <div class="vs-logo"><span>vs</span></div>
                                                    <div class="vs-name"><span><?php echo $pick['vs']; ?></span></div>
                                                </div>
                                            <?php endif;?>

                                            <?php $teams++; ?>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
