<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_SPORTS_PICKS_VS;
    $block_classes = [$block_name];
    $block_sports_picks_vs = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $picks = get_field('picks');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (!empty($picks)): ?>
                <div class="picks">
                    <?php foreach($picks as $pick):?>
                        <div class="pick">
                            <div class="pick-header">
                                <div class="title">
                                    <span class="header-title"><?php echo $pick['title']; ?></span>
                                </div>
                            </div>
                            <div class="pick-body">
                                <?php if (isset($pick['teams']) && $pick['teams'] != false && count($pick['teams']) > 0 && count($pick['teams']) == 2): ?>
                                    <div class="teams">
                                        <?php $teams = 0; ?>
                                        <?php foreach($pick['teams'] as $team): ?>
                                            <?php $class_team = ($teams == 0) ? 'team-a' : 'team-b'; ?>

                                            <div class="team <?php echo $class_team; ?>">
                                                <div class="team-logo">
                                                    <?php if (isset($team['logo']['url']) && $team['logo']['url'] != ''): ?>
                                                        <img src="<?php echo $team['logo']['url']; ?>" alt="">
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <?php if ($teams == 0): ?>
                                                <div class="team team-vs">
                                                    <div class="vs-logo"><span>vs</span></div>
                                                </div>
                                            <?php endif;?>

                                            <?php $teams++; ?>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>

                                <div class="fields">
                                    <div class="field separator">
                                        <div class="team-home"><?php echo $pick['teams'][0]['odds']; ?></div>
                                        <div class="leyend"><?php echo _('ODDS'); ?></div>
                                        <div class="team-visitor"><?php echo $pick['teams'][1]['odds']; ?></div>
                                    </div>

                                    <div class="field separator">
                                        <div class="team-home"><?php echo $pick['teams'][0]['opener']; ?></div>
                                        <div class="leyend"><?php echo _('OPENER'); ?></div>
                                        <div class="team-visitor"><?php echo $pick['teams'][1]['opener']; ?></div>
                                    </div>

                                    <div class="field separator">
                                        <div class="team-home"><?php echo $pick['teams'][0]['current']; ?></div>
                                        <div class="leyend"><?php echo _('CURRENT'); ?></div>
                                        <div class="team-visitor"><?php echo $pick['teams'][1]['current']; ?></div>
                                    </div>
                                
                                    <div class="field separator">
                                        <div class="team-home"><?php echo $pick['teams'][0]['money_line']; ?></div>
                                        <div class="leyend"><?php echo _('MONEYLINE'); ?></div>
                                        <div class="team-visitor"><?php echo $pick['teams'][1]['money_line']; ?></div>
                                    </div>
                                </div>

                                <?php if (!empty($pick['picks'])): ?>
                                    <div class="picks-available">
                                        <span><?php echo $pick['picks']; ?></span>
                                    </div>
                                <?php endif ?>
                            </div>

                            <?php if (!empty($pick['link'])): ?>
                                <div class="pick-footer">
                                    <a href="<?php echo $pick['link']['url']; ?>" target="<?php echo (empty($pick['link']['target'])) ? '_self' : $pick['link']['target']; ?>"><?php echo $pick['link']['title']; ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
