<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_SINGLE_PICK;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $logo = get_field('logo');
    $title = get_field('title');
    $score = get_field('score');
    $pick_available = get_field('pick_available');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <div class="pick">
            <div class="content">
                <div class="center-header">
                    <div class="pick-header">
                        <div class="header-avatar">
                            <img src="<?php echo $logo['url']; ?>" alt="">
                        </div>
                        <div class="header-content">
                            <span class="title"><?php echo $title; ?></span>
                            <span class="score"><?php echo $score; ?></span>
                        </div>
                    </div>
                </div>
                <div class="pick-available">
                    <span><?php echo $pick_available; ?></span>
                </div>
            </div>
        </div>
    </div>
</div>
