(function($) {
    let rdgPostsAjax = $(".rdg-posts-ajax");

    rdgPostsAjax.on('change','#rdg-posts-ajax-category',function(e) {
        e.preventDefault();
        $(".rdg-blocks .rdg-posts-ajax .posts .message").hide();
        
        let ajax_url = rdg_posts_ajax_var.ajaxurl;
        let items = $(e.target).attr('data-items');
        let block_id = $(e.target).attr('data-block-id');
        let cat_seleted = $('#'+block_id+' #rdg-posts-ajax-category option:selected').val();

        $.ajax({
            url : ajax_url,
            type: 'post',
            data: {
                action : 'load_posts_ajax',
                items: items,
                category: cat_seleted,
                block_id: block_id,
            },
            beforeSend: function() {
                $('#wait').show();
            },
            success: function(resultado) {
                $('.rdg-blocks #'+block_id).find('.posts').html(resultado);
                $('#wait').hide();
                setTimeout(function() {
                    $(".rdg-blocks #"+block_id+" .posts .message").fadeOut(1500);
                }, 4000);
            }
        });
    });

    rdgPostsAjax.on("click", ".posts-ajax-pagination a", function(e) {
        e.preventDefault();
        
        let ajax_url = rdg_posts_ajax_var.ajaxurl;
        let page = $(e.target).attr('data-page');
        let items = $('#rdg-posts-ajax-category').attr('data-items');
        let block_id = $('#rdg-posts-ajax-category').attr('data-block-id');
        let category = $('#'+block_id+' #rdg-posts-ajax-category option:selected').val();

        $.ajax({
            url: ajax_url,
            type: 'post',
            data: {
                action: 'load_ajax_paginator',
                items: items,
                category: category,
                page: page,
                block_id: block_id,
            },
            success: function( result ) {
                $('.rdg-blocks').find('.posts').html(result);
            }
        });
    });
}) (jQuery);
