<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Posts_Ajax extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_POSTS_AJAX;
    private $block_folder_name = 'rdg-posts-ajax';
    private $block_title = 'RDG Posts Ajax';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'post', 'ajax'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = true;
    protected $config_page_title = 'RDG Posts Ajax';
    protected $config_menu_title = 'Posts Ajax';
    protected $config_menu_order = 4;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_config_menu'], 20);
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_posts_ajax.css'),
                'enqueue_assets' => function(){
                    wp_register_script('rdg_posts_ajax_script', RDGBLOCKS_PLUGIN_URL.'blocks/rdg-posts-ajax/assets/js/rdg-posts-ajax.js', array('jquery'), '1', true);
                    wp_enqueue_script('rdg_posts_ajax_script');
                    wp_localize_script('rdg_posts_ajax_script','rdg_posts_ajax_var',['ajaxurl' => admin_url('admin-ajax.php')]);
                },
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_posts_ajax_block_sdf4334r',
                'title' => 'Block_rdg_posts_ajax',
                'fields' => array(
                    array(
                        'key' => 'field_63c9cwef33e3',
                        'label' => 'Category',
                        'name' => 'category',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'category',
                        'add_term' => 1,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_63c9ce4ec2643',
                        'label' => 'Quantity',
                        'name' => 'quantity',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => 1,
                        'max' => 12,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-posts-ajax',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function register_config_menu() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'api_configuration_posts_ajax_block_asdasdadad',
                'title' => 'Filter configuration',
                'fields' => array(
                    array(
                        'key' => 'posts_ajax_field_63d9b987cbb5b',
                        'label' => 'Categories',
                        'name' => 'posts_ajax_titles',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'posts_ajax_field_63d9b987daa29',
                                'label' => 'Title Slug',
                                'name' => 'posts_ajax_title_slug',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d9b987cbb5b',
                            ),
                            array(
                                'key' => 'posts_ajax_field_63d9b987de617',
                                'label' => 'Title Value',
                                'name' => 'posts_ajax_title_value',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d9b987cbb5b',
                            ),
                            array(
                                'key' => 'posts_ajax_field_63e6fae32fedc',
                                'label' => 'Sub Titles',
                                'name' => 'sub_titles',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'posts_ajax_field_63e6fb2e2fedd',
                                        'label' => 'Sub Title Slug',
                                        'name' => 'sub_title_slug',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63e6fae32fedc',
                                    ),
                                    array(
                                        'key' => 'posts_ajax_field_63e6fb3d2fede',
                                        'label' => 'Sub Title Value',
                                        'name' => 'sub_title_value',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63e6fae32fedc',
                                    ),
                                ),
                                'parent_repeater' => 'field_63d9b987cbb5b',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-posts-ajax',
                        ),
                    ),
                    array(
                        array(
                            'param' => 'user_role',
                            'operator' => '==',
                            'value' => 'administrator',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_posts_ajax_titles($is_sub_title = false) {
        $sport_titles = [];
        $titles = get_field('posts_ajax_titles', 'option');

        if (is_array($titles) && count($titles) > 0) {
            foreach ($titles as $title) {
                if (is_array($title['sub_titles']) && count($title['sub_titles']) > 0 && $is_sub_title) {
                    $sub_titles = [];
                    foreach ($title['sub_titles'] as $sub_title) {
                        $sub_titles[$sub_title['sub_title_slug']] = $sub_title['sub_title_value'];
                    }
                } else {
                    $sub_titles = $title['posts_ajax_title_value'];
                }

                $sport_titles[$title['posts_ajax_title_slug']] = $sub_titles;
            }
        }

        return $sport_titles;
    }
}

add_action('wp_ajax_nopriv_load_posts_ajax','get_posts_ajax_data');
add_action('wp_ajax_load_posts_ajax','get_posts_ajax_data');

function get_posts_ajax_data() {
    $items = $_POST['items'];
    $category = $_POST['category'];
    $block_id = $_POST['block_id'];

    $data = posts_ajax_get_elements([
        'quantity' => $items,
        'category' => $category,
    ], 1);

    $paged = 1;
    $num_pages = intval($data->found_posts / $items);
    $posts = $data->posts;

    if (($data->found_posts % $items) != 0) {
        $num_pages++;
    }
    
    require 'partials/posts.php';

    echo '<div class="posts-ajax-pagination" data-block_id="'.$block_id.'">';
    posts_ajax_pagination($paged, $num_pages);
    echo '</div>';

    wp_die();
}

add_action('wp_ajax_nopriv_load_ajax_paginator','posts_ajax_get_paginator');
add_action('wp_ajax_load_ajax_paginator','posts_ajax_get_paginator');

function posts_ajax_get_paginator() {
    $items = $_POST['items'];
    $category = $_POST['category'];
    $page = (int) $_POST['page'];
    $block_id = $_POST['block_id'];

    $data = posts_ajax_get_elements([
        'quantity' => $items,
        'category' => $category,
    ], $page);

    $num_pages = intval($data->found_posts / $items);
    $posts = $data->posts;

    if (($data->found_posts % $items) != 0) {
        $num_pages++;
    }
    
    require 'partials/posts.php';

    echo '<div class="posts-ajax-pagination" data-block_id="'.$block_id.'">';
    posts_ajax_pagination($page, $num_pages);
    echo '</div>';

    wp_die();
}

function posts_ajax_get_elements($fields, $paged) {
    $get_quantity = $fields['quantity'];
    $quantity = $get_quantity ? $get_quantity : 1;

    $args = [
        'post_type' => 'post',
        'post_status' => 'publish',
        'posts_per_page' => $quantity,
        'paged' => $paged
    ];

    if (!empty($fields['category'])) {
        $args['category__in'] = $fields['category'];
    }

    $elements = (new WP_Query($args));
    wp_reset_postdata();

    return $elements;
}

function posts_ajax_get_image($image_id) {
    $post_thumbnail_id = get_post_thumbnail_id($image_id);

    if (empty($post_thumbnail_id)) {
        return '';
    }

    $attachment = wp_get_attachment_image_src($post_thumbnail_id, 'posts-list');

    return $attachment[0];
}

function posts_ajax_pagination($current, $total)
{
    $big = 999999999; // need an unlikely integer

    $pagination =  paginate_links([
        'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
        'format' => '/page/%#%',
        'current' => (int) $current,
        'total' =>  (int) $total,
        'type' => 'array' 
    ]);

    echo '<nav><ul class="pagination">';

    foreach ($pagination ?? array() as $element) {
        $dom = new DomDocument();
        $dom->loadHTML($element);
        $page = '';

        foreach($dom->getElementsByTagName('a') as $a) {
            $parts = array_filter(explode('/', $a->getAttribute('href')), 'strlen');
            $page = $parts[count($parts)];
        }

        if (strpos($page, '=')) {
            $page = explode('=', $page)[1];
        }

        echo '<li class="page-item ">' . str_replace('class="', 'data-page="'.$page.'" class="page-link ', $element) . '</li>';
    }

    echo '</ul></nav>';
}

$rdg_posts_ajax_class = new Rdg_Blocks_Posts_Ajax();
$rdg_posts_ajax_class->init();

return $rdg_posts_ajax_class;
