<?php foreach($posts as $post):?>
    <div class="post">
        <div class="post-header">
            <div class="content">
                <div class="sport"><span><?php echo $post['category']; ?></span></div>
                <div class="date-time"><span><?php echo $post['time']; ?></span></div>
                <div class="status"><span><?php echo $post['status']; ?></span></div>
            </div>
        </div>
        <div class="post-body">
            <?php if (isset($post['teams']) && count($post['teams']) > 0 && count($post['teams']) == 2): ?>
                <div class="teams">
                    <?php $teams = 0; ?>
                    <?php foreach($post['teams'] as $team): ?>
                        <?php $class_team = ($teams == 0) ? 'team-a' : 'team-b'; ?>

                        <div class="team <?php echo $class_team; ?>">
                            <div class="team-logo">
                                <?php if (isset($team['logo']['url']) && $team['logo']['url'] != ''): ?>
                                    <img src="<?php echo $team['logo']['url']; ?>" alt="">
                                <?php endif; ?>
                            </div>
                            <div class="team-name"><span><?php echo $team['name']; ?></span></div>
                        </div>

                        <?php if ($teams == 0): ?>
                            <div class="team team-vs">
                                <div class="vs-logo"><span>vs</span></div>
                                <div class="vs-name"><span><?php echo $post['vs']; ?></span></div>
                            </div>
                        <?php endif;?>

                        <?php $teams++; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; ?>