<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_POSTS_AJAX;
    $block_classes = [$block_name];
    $block_posts_ajax = $rdgb->settings->get_block($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? 
        $block['data']['custom_id'] : $block['id'];

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $category = get_field('category');
    
    $items = (!empty(get_field('quantity'))) ? intval(get_field('quantity')) : 9;
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $posts = posts_ajax_get_elements(get_fields(), $paged);
    $num_pages = intval($posts->found_posts / $items);

    if (($posts->found_posts % $items) != 0) {
        $num_pages++;
    }

    $posts = $posts->posts;
    $titles = get_field('titles');

    $posts_titles = $block_posts_ajax->get_posts_ajax_titles(true);
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div <?php echo (!empty($block_id)) ? 'id="'.$block_id.'"' : ''; ?> class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <div id="wait"></div>
            <div class="filter">
                <div class="categories">
                    <div class="select">
                        <select id="rdg-posts-ajax-category" data-items="<?php echo $items; ?>" data-block-id="<?php echo $block_id; ?>">
                            <?php foreach ($posts_titles as $post_key => $post_title): ?>
                                <?php if (is_array($post_title)): ?>
                                    <optgroup label="<?php echo $post_key; ?>">
                                <?php endif; ?>

                                <?php if (is_array($post_title)): ?>
                                    <?php foreach ($post_title as $key => $sub_titles ): ?>
                                        <?php $select = ''; ?>
                                        <?php if ($key == $category): ?>
                                            <?php $select = 'selected'; ?>
                                        <?php endif; ?>
                                        
                                        <option value="<?php echo $key; ?>" <?php echo $select; ?>><?php echo $sub_titles; ?></option>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <?php $select = ''; ?>
                                    <?php if ($post_key == $category): ?>
                                        <?php $select = 'selected'; ?>
                                    <?php endif; ?>
                                    <option value="<?php echo $select; ?>" <?php echo $select; ?>><?php echo $post_title; ?></option>
                                <?php endif; ?>

                                <?php if (is_array($post_title)): ?>
                                    </optgroup>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>

            <div class="posts">
                <?php if (is_array($posts) && count($posts) > 0): ?>
                    <?php require 'partials/posts.php'; ?>
                <?php endif; ?>
                <div class="posts-ajax-pagination" <?php echo (!empty($block_id)) ? 'data-block_id="'.$block_id.'"' : ''; ?>>
                    <?php echo posts_ajax_pagination($paged, $num_pages); ?>
                </div>
            </div>
        </div>
    </div>
</div>
