(function($) {
    $(document).on('change','#rdg-picks-vs-category',function(e) {
        e.preventDefault();
        $(".rdg-blocks .rdg-picks-vs .picks .message").hide();
        
        let ajax_url = rdg_picks_vs_var.ajaxurl;
        let items = $(e.target).attr('data-items');
        let block_id = $(e.target).attr('data-block-id');
        let cat_seleted = $('#'+block_id+' #rdg-picks-vs-category option:selected').val();
        let buttons = $('.buttons .link-info, .buttons .link-default');

        let data = {'data_date_type':'', 'data_since_date':'', 'data_to_date':''};
        let data_date_type = $(this).attr('data-date-type');
        let data_since_date = $(this).attr('data-since-date');
        let data_to_date = $(this).attr('data-to-date');

        $.each(buttons, function(key, val) {
            if ($(val).hasClass('link-info')) {
                data.data_date_type = $(val).attr('data-date-type');
                data.data_since_date = $(val).attr('data-since-date');
                data.data_to_date = $(val).attr('data-to-date');
            }
        }, data);

        $.ajax({
            url : ajax_url,
            type: 'post',
            data: {
                action : 'load_picks_vs',
                items: items,
                id_sub_category: cat_seleted,
                data_date_type: data.data_date_type,
                data_since_date: data.data_since_date,
                data_to_date: data.data_to_date,
            },
            beforeSend: function() {
                $('#wait').show();
            },
            success: function(resultado) {
                $('.rdg-blocks #'+block_id).find('.picks').html(resultado);
                $('#wait').hide();
                setTimeout(function() {
                    $(".rdg-blocks #"+block_id+" .picks .message").fadeOut(1500);
                }, 4000);
            }
        });
    });

    $(document).on('click','.rdg-picks-vs .buttons a',function(e) {
        e.preventDefault();

        if ($(e.target).hasClass('link-info')) {
            return;
        }

        let block_id = $(e.target).attr('data-block-id');
        $(".rdg-blocks #"+block_id+" .rdg-picks-vs .picks .message").hide();

        let ajax_url = rdg_picks_vs_var.ajaxurl;
        let buttons = $('#'+block_id+' .buttons .link-info, #'+block_id+' .buttons .link-default');

        let button_id = $(this).attr('id');
        let items = $(this).attr('data-items');
        let data_date_type = $(this).attr('data-date-type');
        let data_since_date = $(this).attr('data-since-date');
        let data_to_date = $(this).attr('data-to-date');
        let cat_seleted = $('#'+block_id+' #rdg-picks-vs-category option:selected').val();

        $.each(buttons, function(key, val) {      
            if (button_id == $(val).attr("id")) {
                $(val).removeClass('link-default');
                $(val).addClass('link-info');
            } else {
                $(val).removeClass('link-info');
                $(val).addClass('link-default');
            }
        }, button_id); 

        $.ajax({
            url : ajax_url,
            type: 'post',
            data: {
                action : 'load_picks_vs',
                items: items,
                id_sub_category: cat_seleted,
                data_date_type: data_date_type,
                data_since_date: data_since_date,
                data_to_date: data_to_date,
            },
            beforeSend: function() {
                $('#wait').show();
            },
            success: function(resultado) {
                $('.rdg-blocks #'+block_id).find('.picks').html(resultado);
                $('#wait').hide();
                setTimeout(function() {
                    $(".rdg-blocks #"+block_id+" .picks .message").fadeOut(1500);
                }, 4000);
            }
        });
    });
}) (jQuery);
