<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Bookie_Summary extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_BOOKIE_SUMMARY;
    private $block_folder_name = 'rdg-bookie-summary';
    private $block_title = 'RDG Bookie Summary';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'bookie', 'summary'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_bookie_summary.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_stars(float $stars) {
        $fills = intval($stars);
        $half = ($stars - $fills == 0) ? 0 : 1;
        $emptys = 5 - $fills - $half;

        for ($i = 0; $i < $fills; $i++) {
            echo '<span class="star star-fill"></span>';
        }

        if ($half > 0) {
            echo '<span class="star star-half"></span>';
        }

        for ($i = 0; $i < $emptys; $i++) {
            echo '<span class="star star-empty"></span>';
        }
    }

    public function get_style($fields, $type) {
        $style = [];

        if ($type == 'separator') {
            $style[] = (is_array($fields['separator']) && !empty($fields['separator']['border'])) 
                ? '--separator-border:'.intval($fields['separator']['border']).'px' 
                : '--separator-border:1px';
            $style[] = (is_array($fields['separator']) && !empty($fields['separator']['margin'])) 
                ? '--separator-margin:'.intval($fields['separator']['margin']).'rem' 
                : '--separator-margin:1rem';
            $style[] = (is_array($fields['separator']) && !empty($fields['separator']['color'])) 
                ? '--separator-color:'.$fields['separator']['color'] 
                : '--separator-color:#CCC';

            return implode('; ',$style).';';
        }
    }
}

$rdg_bookie_sumary_class = new Rdg_Blocks_Bookie_Summary();
$rdg_bookie_sumary_class->init();

return $rdg_bookie_sumary_class;
