<?php 
    global $rdgb;
    $block_styles = [];
    //$block_classes = [BLOCK_RDG_BOOKIE_SUMMARY];
    $block_bookie_summary = $rdgb->settings->get_block(BLOCK_RDG_BOOKIE_SUMMARY);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    $separator = (!empty(get_field('separator'))) ? get_field('separator') : null;
    $separator_style = $block_bookie_summary->get_style(get_fields(), 'separator');

    $logo_show = (!empty(get_field('logo_show'))) ? get_field('logo_show') : 'hide';
    $bookie_logo = (!empty(get_field('bookie_logo'))) ? get_field('bookie_logo') : null;
    
    $review_show = (!empty(get_field('review_show'))) ? get_field('review_show') : 'hide';
    $review_ranking = (!empty(get_field('ranking'))) ? get_field('ranking') : 0;
    $review_site = (!empty(get_field('site'))) ? get_field('site') : null;
    $review_since = (!empty(get_field('since'))) ? get_field('since') : null;
    $review_description = (!empty(get_field('description'))) ? get_field('description') : null;
    $offers = (!empty(get_field('offers'))) ? get_field('offers') : null;
    
    $payment_show = (!empty(get_field('payment_methods'))) ? get_field('payment_methods') : 'hide';
    $payment_methods = (!empty(get_field('methods'))) ? get_field('methods') : null;
    
    $buttons = (!empty(get_field('buttons'))) ? get_field('buttons') : null;
    //dump($buttons);

    
?>

<div class="rdg-blocks">
    <div class="<?php echo BLOCK_RDG_BOOKIE_SUMMARY; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content <?php echo esc_attr(join(' ', $block_classes)); ?>">
            <?php if ($logo_show == 'show' && !empty($bookie_logo)): ?>
                <div class="header">
                    <div class="logo">
                        <img src="<?php echo $bookie_logo['url']; ?>" alt="Image">
                    </div>
                    <hr style="<?php echo $separator_style; ?>">
                </div>
            <?php endif; ?>

            <?php if ($review_show == 'show'): ?>
                <div class="bookie">
                    <?php if (!empty($review_ranking)): ?>
                        <div class="stars <?php echo (empty($sub_title)) ? 'ml-0' : ''; ?>">
                            <?php $block_bookie_summary->get_stars($review_ranking); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($review_site) || !empty($review_since) || !empty($review_description)): ?>
                        <div class="site">
                            <?php if (!empty($review_site)): ?>
                                <span class="url"><?php echo $review_site; ?></span>
                            <?php endif; ?>

                            <?php if (!empty($review_since)): ?>
                                <span class="since"><?php echo $review_since; ?></span>
                            <?php endif; ?>

                            <?php if (!empty($review_description)): ?>
                                <span class="description"><?php echo $review_description; ?></span>
                            <?php endif; ?>

                            <?php if (is_array($offers) && count($offers) > 0): ?>
                                <div class="offers">
                                    <?php foreach($offers as $offer): ?>
                                        <?php if (is_array($offer['link']) && $offer['link']['url'] != ''): ?>
                                            <a href="<?php echo $offer['link']['url']; ?>" target="<?php echo (!empty($offer['link']['target'])) ? $offer['link']['target'] : '_self'; ?>">
                                        <?php endif; ?>

                                        <?php if ($offer['type'] == 'image'): ?>
                                            <div class="item-button image-type">
                                                <?php
                                                    $offer_bg = (!empty($offer['background_color'])) ? $offer['background_color'] : 'none';
                                                    $offer_padding = (!empty($offer['padding_button'])) ? $offer['padding_button'].'rem' : '0';
                                                ?>
                                                <div class="body <?php echo (!is_array($offer['texts']) || count($offer['texts']) == 0) ? 'center' : ''; ?>" style="--body-bg: <?php echo $offer_bg; ?>; --body-padding: <?php echo $offer_padding; ?>;">
                                                    <?php if (!empty($offer['image']['url'])): ?>
                                                        <div class="image">
                                                            <img src="<?php echo $offer['image']['url']; ?>" alt="Image">
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if (is_array($offer['texts']) && count($offer['texts']) > 0): ?>
                                                        <div class="texts" style="<?php echo (!empty($offer['image']['url'])) ? '--texts-with: calc(100% - 4rem);' : '--texts-with: calc(100%);'; ?>">
                                                            <?php foreach($offer['texts'] as $text): ?>
                                                                <?php if (!empty($text['text'])): ?>
                                                                    <?php
                                                                        $title = $text['text'];
                                                                        $size = (!empty($text['size'])) ? $text['size'].'rem;' : '2rem;';
                                                                        $weight = (!empty($text['weight'])) ? $text['weight'].';' : '500;';
                                                                        $color = (!empty($text['color'])) ? $text['color'].';' : '#FFFFFF;';
                                                                        $text_padding = (!empty($text['text_padding'])) ? $text['text_padding'].'rem;' : '0;';
                                                                    ?>
                                                                    <span style="--text-size:<?php echo $size; ?> --text-padding:<?php echo $text_padding; ?> --text-weight:<?php echo $weight; ?> --text-color:<?php echo $color; ?>"><?php echo $title; ?></span>
                                                                <?php endif; ?>
                                                            <?php endforeach; ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <?php if (!empty($offer['text_basic'])): ?>
                                                <?php
                                                    $padding = (!empty($offer['padding'])) ? $offer['padding'].'rem;' : '.5rem;';
                                                    $title = (!empty($offer['text_basic'])) ? $offer['text_basic'] : 'Link To';
                                                    $size = (!empty($offer['size_basic'])) ? $offer['size_basic'].'rem;' : '2rem;';
                                                    $weight = (!empty($offer['weight_basic'])) ? $offer['weight_basic'].';' : '500;';
                                                    $color = (!empty($offer['color_basic'])) ? $offer['color_basic'].';' : '#FFFFFF;';

                                                    $style = '';
                                                    if ($offer['style'] == 'custom') {
                                                        $border_color = (!empty($offer['border_color'])) ? $offer['border_color'].';' : '#3a96e0;';
                                                        $background_color = (!empty($offer['background_color_button'])) ? $offer['background_color_button'].';' : '#0160ac;';
                                                        $hover_color = (!empty($offer['hover_color'])) ? $offer['hover_color'].';' : '#03467d;';
                                                    } else {
                                                        $style = $offer['style'];
                                                        $border_color = '';
                                                        $background_color = '';
                                                        $hover_color = '';
                                                    }

                                                ?>

                                                <?php if ($offer['style'] == 'custom'): ?>
                                                    <div class="item-button basic-type <?php echo $style; ?>" style="--button-padding:<?php echo $padding; ?> --button-size:<?php echo $size; ?> --button-weight:<?php echo $weight; ?> --button-color:<?php echo $color; ?> --button-bg:<?php echo $background_color; ?> --button-hover:<?php echo $hover_color; ?>  --button-border:<?php echo $border_color; ?>">
                                                        <span><?php echo $title; ?></span>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="item-button basic-type <?php echo $style; ?>" style="--button-padding:<?php echo $padding; ?> --button-size:<?php echo $size; ?> --button-weight:<?php echo $weight; ?> --button-color:<?php echo $color; ?>">
                                                        <span><?php echo $title; ?></span>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <?php if (is_array($offer['link']) && $offer['link']['url'] != ''): ?>
                                            </a>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>


                </div>
            <?php endif; ?>

            <?php if ($payment_show == 'show' && is_array($payment_methods) && count($payment_methods) > 0): ?>
                <div class="methods">
                    <hr style="<?php echo $separator_style; ?>">
                    <?php if (!empty($payment_methods['title'])): ?>
                        <span class="title"><?php echo $payment_methods['title']; ?></span>
                    <?php endif; ?>
                    <div class="logos">
                        <?php foreach ($payment_methods['images'] as $method): ?>
                            <?php if (!empty($method['method']['url'])): ?>
                                <img src="<?php echo $method['method']['url']; ?>" alt="Image">
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (is_array($buttons) && count($buttons) > 0): ?>
                <div class="buttons">
                    <hr style="<?php echo $separator_style; ?>">
                    <?php foreach($buttons as $button): ?>
                        <?php if (is_array($button['link']) && $button['link']['url'] != ''): ?>
                            <a href="<?php echo $button['link']['url']; ?>" target="<?php echo (!empty($button['link']['target'])) ? $button['link']['target'] : '_self'; ?>">
                        <?php endif; ?>

                        <?php if ($button['type'] == 'image'): ?>
                            <div class="item-button image-type">
                                <?php
                                    $button_bg = (!empty($button['background_color'])) ? $button['background_color'] : 'none';
                                    $button_padding = (!empty($button['padding_button'])) ? $button['padding_button'].'rem' : '0';
                                ?>
                                <div class="body <?php echo (!is_array($button['texts']) || count($button['texts']) == 0) ? 'center' : ''; ?>" style="--body-bg: <?php echo $button_bg; ?>; --body-padding: <?php echo $button_padding; ?>;">
                                    <?php if (!empty($button['image']['url'])): ?>
                                        <div class="image">
                                            <img src="<?php echo $button['image']['url']; ?>" alt="Image">
                                        </div>
                                    <?php endif; ?>
                                    <?php if (is_array($button['texts']) && count($button['texts']) > 0): ?>
                                        <div class="texts" style="<?php echo (!empty($button['image']['url'])) ? '--texts-with: calc(100% - 4rem);' : '--texts-with: calc(100%);'; ?>">
                                            <?php foreach($button['texts'] as $text): ?>
                                                <?php if (!empty($text['text'])): ?>
                                                    <?php
                                                        $title = $text['text'];
                                                        $size = (!empty($text['size'])) ? $text['size'].'rem;' : '2rem;';
                                                        $weight = (!empty($text['weight'])) ? $text['weight'].';' : '500;';
                                                        $color = (!empty($text['color'])) ? $text['color'].';' : '#FFFFFF;';
                                                        $text_padding = (!empty($text['text_padding'])) ? $text['text_padding'].'rem;' : '0;';
                                                    ?>
                                                    <span style="--text-size:<?php echo $size; ?> --text-padding:<?php echo $text_padding; ?> --text-weight:<?php echo $weight; ?> --text-color:<?php echo $color; ?>"><?php echo $title; ?></span>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php else: ?>
                            <?php if (!empty($button['text_basic'])): ?>
                                <?php
                                    $padding = (!empty($button['padding'])) ? $button['padding'].'rem;' : '.5rem;';
                                    $title = (!empty($button['text_basic'])) ? $button['text_basic'] : 'Link To';
                                    $size = (!empty($button['size_basic'])) ? $button['size_basic'].'rem;' : '2rem;';
                                    $weight = (!empty($button['weight_basic'])) ? $button['weight_basic'].';' : '500;';
                                    $color = (!empty($button['color_basic'])) ? $button['color_basic'].';' : '#FFFFFF;';

                                    $style = '';
                                    if ($button['style'] == 'custom') {
                                        $border_color = (!empty($button['border_color'])) ? $button['border_color'].';' : '#3a96e0;';
                                        $background_color = (!empty($button['background_color_button'])) ? $button['background_color_button'].';' : '#0160ac;';
                                        $hover_color = (!empty($button['hover_color'])) ? $button['hover_color'].';' : '#03467d;';
                                    } else {
                                        $style = $button['style'];
                                        $border_color = '';
                                        $background_color = '';
                                        $hover_color = '';
                                    }

                                ?>

                                <?php if ($button['style'] == 'custom'): ?>
                                    <div class="item-button basic-type <?php echo $style; ?>" style="--button-padding:<?php echo $padding; ?> --button-size:<?php echo $size; ?> --button-weight:<?php echo $weight; ?> --button-color:<?php echo $color; ?> --button-bg:<?php echo $background_color; ?> --button-hover:<?php echo $hover_color; ?>  --button-border:<?php echo $border_color; ?>">
                                        <span><?php echo $title; ?></span>
                                    </div>
                                <?php else: ?>
                                    <div class="item-button basic-type <?php echo $style; ?>" style="--button-padding:<?php echo $padding; ?> --button-size:<?php echo $size; ?> --button-weight:<?php echo $weight; ?> --button-color:<?php echo $color; ?>">
                                        <span><?php echo $title; ?></span>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php if (is_array($button['link']) && $button['link']['url'] != ''): ?>
                            </a>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
