<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Experts_Banner extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_EXPERTS_BANNER;
    private $block_folder_name = 'rdg-experts-banner';
    private $block_title = 'RDG Experts Banner';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'experts banner', 'experts', 'banner'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_experts_banner.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):

            acf_add_local_field_group(array(
                'key' => 'group_642ca4a99681b',
                'title' => 'Expert Banner',
                'fields' => array(
                    array(
                        'key' => 'field_642ca4b7e2825',
                        'label' => 'Expert Name',
                        'name' => 'expert_name',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca4efe2826',
                        'label' => 'Expert Category',
                        'name' => 'expert_category',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca503e2827',
                        'label' => 'Expert Img',
                        'name' => 'expert_img',
                        'aria-label' => '',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                        'preview_size' => 'medium',
                    ),
                    array(
                        'key' => 'field_642ca51be2828',
                        'label' => 'Win',
                        'name' => 'win',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca7e8e2829',
                        'label' => 'Lose',
                        'name' => 'lose',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca7f0e282a',
                        'label' => 'Push',
                        'name' => 'push',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca7fbe282b',
                        'label' => 'Gain',
                        'name' => 'gain',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca857e282c',
                        'label' => 'Ad',
                        'name' => 'ad',
                        'aria-label' => '',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                        'delay' => 0,
                    ),
                    array(
                        'key' => 'field_642ca865e282d',
                        'label' => 'Button Text',
                        'name' => 'button',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_642ca86de282e',
                        'label' => 'Button Link',
                        'name' => 'button_link',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-experts-banner',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
            
            endif;		
    }

    // public function get_style($type, $fields) {
    //     $style = [];
    
    //     if ('block' == $type) {
    //         $color = (!empty($fields['color'])) ? $fields['color'] : '#172d54';
    //         $style[] = 'background-color: '.$color;
    
    //         if (!empty($fields['image']['url'])) {
    //             $style[] = 'background-image: url('.$fields['image']['url'].')';
    //         }
    
    //         return implode('; ', $style);
    //     }
    
    //     if ('position' == $type) {
    //         if (!empty($fields['padding_top'])) {
    //             $style[] = 'padding-top: '.$fields['padding_top'].'rem';
    //         }
    
    //         if (!empty($fields['padding_left'])) {
    //             $style[] = 'padding-left: '.$fields['padding_left'].'rem';
    //         }
    
    //         if (!empty($fields['padding_right'])) {
    //             $style[] = 'padding-right: '.$fields['padding_right'].'rem';
    //         }
    
    //         return implode('; ', $style);
    //     }
    // }

    // public function get_texts($spaces, $titles, $member) {
    //     $texts = [];
    //     $min_size = (100 - $spaces['width']) / 2;
    //     $align = $spaces['position'];
    
    //     if (empty($titles)) {
    //         return;
    //     }

    //     $rdg_helpers = new Rdg_Blocks_Helpers();
        
    //     foreach($titles['texts'] as $title) {
    //         $style = $rdg_helpers->get_title_sizes($title);
    //         $style[] = (!empty($title['color'])) ? 'color: '.$title['color'] : 'color: #ffffff';
    //         $style[] = (!empty($title['weight'])) ? 'font-weight: '.$title['weight'] : 'font-weight: 400';
    //         $style[] = (!empty($title['padding'])) ? 'padding-bottom: '.$title['padding'].'rem' : 'padding-bottom: 0rem';
    
    //         if (!empty($title['shadow_color'])) {
    //             $style[] = 'text-shadow: 0px 1px 1px '.$title['shadow_color'];
    //         }
    
    //         $texts[] = '<'.$title['heading'].' style="'.implode('; ', $style).'">'.$title['title'].'</'.$title['heading'].'>';
    //         $style = [];
    //     }
        
    //     $button = $this->get_link($member);
        
    //     if ('left' == $align) {
    //         echo '<div class="position size-left" style="width: '.$spaces['width'].'%;"><div class="texts"><div class="content">'.implode('', $texts).'</div></div><div class="button">'.$button.'</div></div>';
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    
    //         return;
    //     }
    
    //     if ('center' == $align) {
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    //         echo '<div class="position size-center" style="width: '.$spaces['width'].'%;"><div class="texts"><div class="content">'.implode('', $texts).'</div></div><div class="button">'.$button.'</div></div>';
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    
    //         return;
    //     }
    
    //     if ('right' == $align) {
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    //         echo '<div class="position size-right" style="width: '.$spaces['width'].'%;"><div class="texts"><div class="content">'.implode('', $texts).'</div></div><div class="button">'.$button.'</div></div>';
    
    //         return;
    //     }
    // }

    // private function get_link($member) {
    //     if (is_array($member['link'])) {
    //         if (!empty($member['background_color'])) {
    //             $styles[] = 'background-color: '.$member['background_color'].';';
    //         } else {
    //             $styles[] = 'background-color: #459519;';
    //         }
    
    //         if (!empty($member['title_color'])) {
    //             $styles[] = 'color: '.$member['title_color'].';';
    //         } else {
    //             $styles[] = 'color: #ffffff;';
    //         }
    
    //         if (!empty($member['shadow_color'])) {
    //             $styles[] = '--btn-box-shadow: '.$member['shadow_color'].';';
    //         } else {
    //             $styles[] = '--btn-box-shadow: #68f96e;';
    //         }
    
    //         $target = (!empty($member['link']['title'])) ? $member['link']['target'] : '_self';
    //         return '<a class="link-member" href="'.$member['link']['url'].'" target="'.$target.'" style="'.implode(' ', $styles).'">'.$member['link']['title'].'</a>';
    //     }
    
    //     return '';
    // }
}

$rdg_experts_banner_class = new Rdg_Blocks_Experts_Banner();
$rdg_experts_banner_class->init();

return $rdg_experts_banner_class;
