<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_MEMBERSHIPS;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    // Variables
    $title= get_field('title');

    $firstPack = get_field('first_pack');
    $secondPack = get_field('second_pack');
    $thirdPack = get_field('third_pack');
    $fourthPack = get_field('fourth_pack');

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <div class="title">
                <p><?php echo $title; ?></p>
            </div>
            <div class="column">
                <div class="first_membership">
              <?php  if( $firstPack): 
                    
                    $title = $firstPack['title'];
                    $description = $firstPack['description'];
                    $price = $firstPack['price'];;
                    $linkURL = $firstPack['link']['url'];
                    $linkTitle= $firstPack['link']['title'];

                    ?>
                        <div class="header">
                            <p><?php echo  $title;?></p>
                        </div>
                        <div class="body">
                            <div class="description">
                                <?php echo $description; ?>
                            </div>
                            <div class="footer">
                                <div class="price">
                                    <p>$<?php echo $price; ?></p>
                                </div>
                                <div class="btn">
                                    <a href="<?php echo $linkURL; ?>"><?php echo $linkTitle; ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="second_membership">
                <?php  if( have_rows('second_pack') ): while ( have_rows('second_pack') ) : the_row(); 
                    
                    $title = $secondPack['title'];
                    $description = $secondPack['description'];
                    $price = $secondPack['price'];
                    $linkURL = $secondPack['link']['url'];
                    $linkTitle= $secondPack['link']['title'];
                    $list= $secondPack['list'];

                    ?>
                        <div class="header">
                            <p><?php echo $title;?></p>
                        </div>
                        <div class="body">
                            <div class="deal">
                                <div class="price">
                                <p>$<?php echo $price; ?></p>
                                </div>
                                <div class="list">
                                    <ul>
                                        <?php
                                        // Check rows exists.
                                        if( have_rows('list') ): while ( have_rows('list') ) : the_row();       ?>

                                        <li><?php echo get_sub_field('list_info') ?></li>
                                
                                   <?php endwhile; endif; ?>
                                    
                                    </ul>
                                </div>
                            </div>
                            <div class="description">
                                <?php echo $description; ?>
                            </div>
                            <div class="btn">
                                <a href="<?php echo $linkURL; ?>"><?php echo $linkTitle; ?></a>
                            </div>
                        </div>
                        <?php endwhile; endif; ?>
                </div>
                <div class="third_membership">
                <?php  if( $thirdPack ): 
                    
                    $title = $thirdPack ['title'];
                    $description = $thirdPack['description'];
                    $price = $thirdPack ['price'];
                    $linkURL = $thirdPack ['link']['url'];
                    $linkTitle= $thirdPack ['link']['title'];
                    $great_value= $thirdPack ['great_value'];

                    ?>
                        <div class="header">
                            <p><?php echo  $title; ?></p>
                        </div>
                        <div class="body">
                            <div class="left">
                                <div class="description">
                                <p><?php echo  $description;?></p> 
                                </div>
                                <div class="great_value">
                                    <?php if ($great_value === true) {?>
                                        <img src="https://main-bvxea6i-rdjrocko7mvzg.us-2.platformsh.site/app/uploads/2023/04/icon-completo-1.png" alt="Verified Great Value">
                                  <?php  } ?>
                                </div>
                            </div>
                            <div class="right">
                                <div class="price">
                                    <div class="dollar">$</div>
                                    <div class="amount"><?php echo  $price;?></div>
                                </div>
                                <div class="btn">
                                <a href="<?php echo $linkURL; ?>"><?php echo $linkTitle; ?></a>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                </div>
                <div class="fourth_membership">
                <?php  if( have_rows('fourth_pack') ): while ( have_rows('fourth_pack') ) : the_row(); 
                    
                    $title = $fourthPack['title'];
                    $discount = $fourthPack['discount'];
                    $best_deal = $fourthPack['best_deal'];
                    $list= $fourthPack['list'];
                    $linkURL = $fourthPack['link']['url'];
                    $linkTitle= $fourthPack['link']['title'];
                
                    ?>
                        <div class="header">
                            <p><?php echo $title;?></p>
                        </div>
                        <div class="body">
                            <div class="deal">
                                <span class="off"><?php echo $discount;?></span> <span class="dot">•</span> <span class="best_deal"><?php echo $best_deal;?></span>
                            </div>
                            <div class="list">
                                <ul>
                                <?php
                                        // Check rows exists.
                                        if( have_rows('list') ): while ( have_rows('list') ) : the_row();       ?>

                                        <li><?php echo get_sub_field('list_info') ?></li>
                                
                                   <?php endwhile; endif; ?>
                                </ul>
                            </div>
                            <div class="btn">
                                <a href="<?php echo $linkURL; ?>"><?php echo $linkTitle; ?></a>
                            </div>
                        </div>
                    <?php endwhile; endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
