(function($) {
    let rdgPostsAjax = $(".rdg-posts-ajax");

    rdgPostsAjax.on("click", ".posts-ajax-pagination a", function(e) {
        e.preventDefault();
        
        let ajax_url = rdg_posts_ajax_var.ajaxurl;
        let page = $(e.target).attr('data-page');
        let items = $('#rdg-posts-ajax-sports').attr('data-items');
        let block_id = $('#rdg-posts-ajax-sports').attr('data-block-id');
        let category_sport = $('#'+block_id+' #rdg-posts-ajax-sports option:selected').val();
        let category_league = $('#'+block_id+' #rdg-posts-ajax-leagues option:selected').val();

        $.ajax({
            url: ajax_url,
            type: 'post',
            data: {
                action: 'load_ajax_paginator',
                items: items,
                category_sport: category_sport,
                category_league: category_league,
                page: page,
                block_id: block_id,
            },
            success: function( result ) {
                $('.rdg-blocks').find('.posts').html(result);
            }
        });
    });

    rdgPostsAjax.on('change','#rdg-posts-ajax-sports',function(e) {
        e.preventDefault();
        $(".rdg-blocks .rdg-posts-ajax .posts .message").hide();
        
        let ajax_url = rdg_posts_ajax_var.ajaxurl;
        let items = $(e.target).attr('data-items');
        let block_id = $(e.target).attr('data-block-id');
        let cat_seleted = $('#'+block_id+' #rdg-posts-ajax-sports option:selected').val();

        $.ajax({
            url : ajax_url,
            type: 'post',
            data: {
                action : 'load_posts_ajax',
                items: items,
                category: cat_seleted,
                block_id: block_id,
            },
            beforeSend: function() {
                $('#wait').show();
            },
            success: function(resultado1) {
                $.ajax({
                    url : ajax_url,
                    type: 'post',
                    data: {
                        action : 'load_options_league',
                        category: cat_seleted,
                    },
                    beforeSend: function() {
                        $('#wait').show();
                    },
                    success: function(resultado2) {
                        $('.rdg-blocks #'+block_id).find('.posts').html(resultado1);
                        $('.rdg-blocks #'+block_id).find('#rdg-posts-ajax-leagues').html(resultado2);

                        
                        $('#wait').hide();
                        setTimeout(function() {
                            $(".rdg-blocks #"+block_id+" .posts .message").fadeOut(1500);
                        }, 4000);
                    }
                });
                setTimeout(function() {
                    $(".rdg-blocks #"+block_id+" .posts .message").fadeOut(1500);
                }, 4000);
            }
        });
    });

    rdgPostsAjax.on('change','#rdg-posts-ajax-leagues',function(e) {
        e.preventDefault();
        $(".rdg-blocks .rdg-posts-ajax .posts .message").hide();
        
        let ajax_url = rdg_posts_ajax_var.ajaxurl;
        let items = $(e.target).attr('data-items');
        let block_id = $(e.target).attr('data-block-id');
        let cat_seleted_sport = $('#'+block_id+' #rdg-posts-ajax-sports option:selected').val();
        let cat_seleted_league = $('#'+block_id+' #rdg-posts-ajax-leagues option:selected').val();

        $.ajax({
            url : ajax_url,
            type: 'post',
            data: {
                action : 'load_posts_filters',
                items: items,
                category_sport: cat_seleted_sport,
                category_league: cat_seleted_league,
                block_id: block_id,
            },
            beforeSend: function() {
                $('#wait').show();
            },
            success: function(resultado) {
                $('.rdg-blocks #'+block_id).find('.posts').html(resultado);
                $('#wait').hide();
                setTimeout(function() {
                    $(".rdg-blocks #"+block_id+" .posts .message").fadeOut(1500);
                }, 4000);
            }
        });
    });
}) (jQuery);
