<?php

function create_post_type_review()
{
    $supports = array(
        'title', // post title
        'editor', // post content
        'author', // post author
        'thumbnail', // featured images
        'excerpt', // post excerpt
        'custom-fields', // custom fields
        'comments', // post comments
    );

    $labels = array(
        'name' => _x('Reviews', 'plural'),
        'singular_name' => _x('Review', 'singular'),
        'menu_name' => _x('Reviews', 'admin menu'),
        'name_admin_bar' => _x('Reviews', 'admin bar'),
        'add_new' => _x('Add New', 'add new'),
        'add_new_item' => __('Add New Review'),
        'new_item' => __('New Review'),
        'edit_item' => __('Edit Review'),
        'view_item' => __('View Reviews'),
        'all_items' => __('All Reviews'),
        'search_items' => __('Search Reviews'),
        'not_found' => __('No Review found.'),
    );

    $args = array(
        'supports' => $supports,
        'labels' => $labels,
        'query_var' => true,
        'rewrite' => array('slug' => 'reviews'),
        'hierarchical' => false,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_nav_menus' => true,
        'show_in_admin_bar' => true,
        'menu_position' => 20,
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'publicly_queryable' => true,
        'capability_type' => 'page',
        'show_in_rest' => true,
    );

    register_post_type('reviews', $args);
}

add_action('init', 'create_post_type_review');

function post_type_review_bookie_sumary_register_fields() {
    if( function_exists('acf_add_local_field_group') ):
        acf_add_local_field_group(array(
            'key' => 'group_bookie_summary_custom_post_type_we7iyh3e2sq76u53256gu3se2',
            'title' => 'Bookie Summary',
            'fields' => array(
                array(
                    'key' => 'field_6446a448c5995',
                    'label' => 'Separator',
                    'name' => 'separator_group',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6446a697afe36',
                            'label' => 'Border',
                            'name' => 'border',
                            'aria-label' => '',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '33',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 1,
                            'min' => 1,
                            'max' => 10,
                            'placeholder' => '',
                            'step' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6446a6baafe37',
                            'label' => 'Margin',
                            'name' => 'margin',
                            'aria-label' => '',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '33',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 1,
                            'min' => 1,
                            'max' => 10,
                            'placeholder' => '',
                            'step' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6446a6d5afe38',
                            'label' => 'Color',
                            'name' => 'color',
                            'aria-label' => '',
                            'type' => 'color_picker',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '34',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '#CCC',
                            'enable_opacity' => 0,
                            'return_format' => 'string',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6446aa349bb4a',
                    'label' => 'Logo',
                    'name' => 'logo',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6446aa349bb4b',
                            'label' => 'Display Logo',
                            'name' => 'logo_show',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'show' => 'Show',
                                'hide' => 'Hide',
                            ),
                            'default_value' => 'show',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6446aa6f34698',
                            'label' => 'Bookie Logo',
                            'name' => 'bookie_logo',
                            'aria-label' => '',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446aa349bb4b',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                            'preview_size' => 'medium',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6446a8d3d2760',
                    'label' => 'Review',
                    'name' => 'review_group',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6446a8e9d2761',
                            'label' => 'Display Review',
                            'name' => 'review_show',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'show' => 'Show',
                                'hide' => 'Hide',
                            ),
                            'default_value' => 'show',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6446aaea3be0e',
                            'label' => 'Ranking',
                            'name' => 'ranking',
                            'aria-label' => '',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446a8e9d2761',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '33',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => 1,
                            'min' => '',
                            'max' => '',
                            'placeholder' => '',
                            'step' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6446ab003be0f',
                            'label' => 'Site',
                            'name' => 'site',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446a8e9d2761',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '33',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6446ab123be10',
                            'label' => 'Since',
                            'name' => 'since',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446a8e9d2761',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '34',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6446ab1d3be11',
                            'label' => 'Description',
                            'name' => 'description',
                            'aria-label' => '',
                            'type' => 'textarea',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446a8e9d2761',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'rows' => 4,
                            'placeholder' => '',
                            'new_lines' => '',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6446ce50b89ca',
                    'label' => 'Offers',
                    'name' => 'offers_group',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6446cefcfec85',
                            'label' => 'Display Offers',
                            'name' => 'offers_show',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'show' => 'Show',
                                'hide' => 'Hide',
                            ),
                            'default_value' => 'show',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6446be3250171',
                            'label' => 'Offer',
                            'name' => 'offer',
                            'aria-label' => '',
                            'type' => 'repeater',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6446cefcfec85',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'layout' => 'block',
                            'pagination' => 0,
                            'min' => 0,
                            'max' => 0,
                            'collapsed' => '',
                            'button_label' => 'Add Row',
                            'rows_per_page' => 20,
                            'sub_fields' => array(
                                array(
                                    'key' => 'field_6446be3b50172',
                                    'label' => 'Type',
                                    'name' => 'type',
                                    'aria-label' => '',
                                    'type' => 'radio',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'choices' => array(
                                        'image' => 'Image',
                                        'basic' => 'Basic',
                                    ),
                                    'default_value' => 'image',
                                    'return_format' => 'value',
                                    'allow_null' => 0,
                                    'other_choice' => 0,
                                    'layout' => 'horizontal',
                                    'save_other_choice' => 0,
                                    'parent_repeater' => 'field_6446be3250171',
                                ),
                                array(
                                    'key' => 'field_6446ca683c969',
                                    'label' => 'Image Button',
                                    'name' => 'image_button',
                                    'aria-label' => '',
                                    'type' => 'group',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => array(
                                        array(
                                            array(
                                                'field' => 'field_6446be3b50172',
                                                'operator' => '==',
                                                'value' => 'image',
                                            ),
                                        ),
                                    ),
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'layout' => 'block',
                                    'sub_fields' => array(
                                        array(
                                            'key' => 'field_6446be7450173',
                                            'label' => 'Image',
                                            'name' => 'image',
                                            'aria-label' => '',
                                            'type' => 'image',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                            'library' => 'all',
                                            'min_width' => '',
                                            'min_height' => '',
                                            'min_size' => '',
                                            'max_width' => '',
                                            'max_height' => '',
                                            'max_size' => '',
                                            'mime_types' => '',
                                            'preview_size' => 'medium',
                                        ),
                                        array(
                                            'key' => 'field_6446be8f50174',
                                            'label' => 'Background Color',
                                            'name' => 'background_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#0160ac',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6446bee750176',
                                            'label' => 'Texts',
                                            'name' => 'texts',
                                            'aria-label' => '',
                                            'type' => 'repeater',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'layout' => 'block',
                                            'pagination' => 0,
                                            'min' => 0,
                                            'max' => 0,
                                            'collapsed' => '',
                                            'button_label' => 'Add Row',
                                            'rows_per_page' => 20,
                                            'sub_fields' => array(
                                                array(
                                                    'key' => 'field_6446bef150177',
                                                    'label' => 'Text',
                                                    'name' => 'text',
                                                    'aria-label' => '',
                                                    'type' => 'text',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '40',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => '',
                                                    'maxlength' => '',
                                                    'placeholder' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6446bee750176',
                                                ),
                                                array(
                                                    'key' => 'field_6446bf1a50178',
                                                    'label' => 'Padding',
                                                    'name' => 'text_padding',
                                                    'aria-label' => '',
                                                    'type' => 'number',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => 0,
                                                    'min' => 0,
                                                    'max' => 10,
                                                    'placeholder' => '',
                                                    'step' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6446bee750176',
                                                ),
                                                array(
                                                    'key' => 'field_6446bf3a50179',
                                                    'label' => 'Size',
                                                    'name' => 'size',
                                                    'aria-label' => '',
                                                    'type' => 'number',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => 1,
                                                    'min' => 1,
                                                    'max' => 10,
                                                    'placeholder' => '',
                                                    'step' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6446bee750176',
                                                ),
                                                array(
                                                    'key' => 'field_6446bf4f5017a',
                                                    'label' => 'Weight',
                                                    'name' => 'weight',
                                                    'aria-label' => '',
                                                    'type' => 'select',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'choices' => array(
                                                        100 => '100',
                                                        200 => '200',
                                                        300 => '300',
                                                        400 => '400',
                                                        500 => '500',
                                                        600 => '600',
                                                        700 => '700',
                                                        800 => '800',
                                                        900 => '900',
                                                    ),
                                                    'default_value' => 400,
                                                    'return_format' => 'value',
                                                    'multiple' => 0,
                                                    'allow_null' => 0,
                                                    'ui' => 0,
                                                    'ajax' => 0,
                                                    'placeholder' => '',
                                                    'parent_repeater' => 'field_6446bee750176',
                                                ),
                                                array(
                                                    'key' => 'field_6446bf645017b',
                                                    'label' => 'Color',
                                                    'name' => 'color',
                                                    'aria-label' => '',
                                                    'type' => 'color_picker',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => '#FFFFFF',
                                                    'enable_opacity' => 0,
                                                    'return_format' => 'string',
                                                    'parent_repeater' => 'field_6446bee750176',
                                                ),
                                            ),
                                        ),
                                        array(
                                            'key' => 'field_6446bea550175',
                                            'label' => 'Padding Button',
                                            'name' => 'padding_button',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 0,
                                            'min' => 0,
                                            'max' => 10,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446c37f0d228',
                                            'label' => 'Link',
                                            'name' => 'link',
                                            'aria-label' => '',
                                            'type' => 'link',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '60',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                        ),
                                        array(
                                            'key' => 'field_644ac1a9f7bda',
                                            'label' => 'Link Rel Option',
                                            'name' => 'link_rel_option',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'none' => 'None',
                                                'no_follow' => 'No Follow',
                                            ),
                                            'default_value' => 'none',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                    ),
                                    'parent_repeater' => 'field_6446be3250171',
                                ),
                                array(
                                    'key' => 'field_6446cb81e150e',
                                    'label' => 'Basic Button',
                                    'name' => 'basic_button',
                                    'aria-label' => '',
                                    'type' => 'group',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => array(
                                        array(
                                            array(
                                                'field' => 'field_6446be3b50172',
                                                'operator' => '==',
                                                'value' => 'basic',
                                            ),
                                        ),
                                    ),
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'layout' => 'block',
                                    'sub_fields' => array(
                                        array(
                                            'key' => 'field_6446cd1271d51',
                                            'label' => 'Padding Button',
                                            'name' => 'padding_button',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 0,
                                            'min' => 0,
                                            'max' => 10,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446c2820d221',
                                            'label' => 'Text Size',
                                            'name' => 'text_size',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 1,
                                            'min' => 1,
                                            'max' => 20,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446c2b00d222',
                                            'label' => 'Text Weight',
                                            'name' => 'text_weight',
                                            'aria-label' => '',
                                            'type' => 'select',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                100 => '100',
                                                200 => '200',
                                                300 => '300',
                                                400 => '400',
                                                500 => '500',
                                                600 => '600',
                                                700 => '700',
                                                800 => '800',
                                                900 => '900',
                                            ),
                                            'default_value' => 400,
                                            'return_format' => 'value',
                                            'multiple' => 0,
                                            'allow_null' => 0,
                                            'ui' => 0,
                                            'ajax' => 0,
                                            'placeholder' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446c2dc0d223',
                                            'label' => 'Text Color',
                                            'name' => 'color_basic',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#FFFFFF',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6446c2fc0d224',
                                            'label' => 'Style',
                                            'name' => 'style',
                                            'aria-label' => '',
                                            'type' => 'select',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'info' => 'Info',
                                                'success' => 'Success',
                                                'warning' => 'Warning',
                                                'danger' => 'Danger',
                                                'custom' => 'Custom',
                                            ),
                                            'default_value' => 'info',
                                            'return_format' => 'value',
                                            'multiple' => 0,
                                            'allow_null' => 0,
                                            'ui' => 0,
                                            'ajax' => 0,
                                            'placeholder' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446c32e0d225',
                                            'label' => 'Border Color',
                                            'name' => 'border_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6446c2fc0d224',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '33',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#3a96e0',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6446c3500d226',
                                            'label' => 'Background Color',
                                            'name' => 'background_color_button',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6446c2fc0d224',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '33',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#0160ac',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6446c36c0d227',
                                            'label' => 'Hover Color',
                                            'name' => 'hover_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6446c2fc0d224',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '34',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#03467d',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_644a68f85bc68',
                                            'label' => 'Display Text',
                                            'name' => 'display_text',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '30',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'show' => 'Show',
                                                'hide' => 'Hide',
                                            ),
                                            'default_value' => 'show',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                        array(
                                            'key' => 'field_6446c2630d220',
                                            'label' => 'Text',
                                            'name' => 'text_basic',
                                            'aria-label' => '',
                                            'type' => 'text',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a68f85bc68',
                                                        'operator' => '==',
                                                        'value' => 'show',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '70',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '',
                                            'maxlength' => '',
                                            'placeholder' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6446cd3171d52',
                                            'label' => 'Link',
                                            'name' => 'link',
                                            'aria-label' => '',
                                            'type' => 'link',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a68f85bc68',
                                                        'operator' => '==',
                                                        'value' => 'hide',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                        ),
                                        array(
                                            'key' => 'field_644ab5ec08e5f',
                                            'label' => 'Link Rel Option',
                                            'name' => 'link_rel_option',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a68f85bc68',
                                                        'operator' => '==',
                                                        'value' => 'hide',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'none' => 'None',
                                                'no_follow' => 'No Follow',
                                            ),
                                            'default_value' => 'none',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                    ),
                                    'parent_repeater' => 'field_6446be3250171',
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6447e4df700ab',
                    'label' => 'Payment Methods',
                    'name' => 'payment_methods_group',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6447e537700ac',
                            'label' => 'Display Payment Methods',
                            'name' => 'payment_methods_show',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'show' => 'Show',
                                'hide' => 'Hide',
                            ),
                            'default_value' => 'show',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6447e5c7700ad',
                            'label' => 'Title',
                            'name' => 'title',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6447e537700ac',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                        ),
                        array(
                            'key' => 'field_6447e5da700ae',
                            'label' => 'Images',
                            'name' => 'images',
                            'aria-label' => '',
                            'type' => 'repeater',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6447e537700ac',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'layout' => 'block',
                            'pagination' => 0,
                            'min' => 0,
                            'max' => 0,
                            'collapsed' => '',
                            'button_label' => 'Add Row',
                            'rows_per_page' => 20,
                            'sub_fields' => array(
                                array(
                                    'key' => 'field_6447e5e4700af',
                                    'label' => '',
                                    'name' => 'image',
                                    'aria-label' => '',
                                    'type' => 'image',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'return_format' => 'array',
                                    'library' => 'all',
                                    'min_width' => '',
                                    'min_height' => '',
                                    'min_size' => '',
                                    'max_width' => '',
                                    'max_height' => '',
                                    'max_size' => '',
                                    'mime_types' => '',
                                    'preview_size' => 'medium',
                                    'parent_repeater' => 'field_6447e5da700ae',
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'key' => 'field_6447e90bac7d8',
                    'label' => 'Buttons',
                    'name' => 'buttons_group',
                    'aria-label' => '',
                    'type' => 'group',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_6447e90bac7d9',
                            'label' => 'Display Buttons',
                            'name' => 'buttons_show',
                            'aria-label' => '',
                            'type' => 'radio',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'choices' => array(
                                'show' => 'Show',
                                'hide' => 'Hide',
                            ),
                            'default_value' => 'show',
                            'return_format' => 'value',
                            'allow_null' => 0,
                            'other_choice' => 0,
                            'layout' => 'horizontal',
                            'save_other_choice' => 0,
                        ),
                        array(
                            'key' => 'field_6447e90bac7da',
                            'label' => 'Buttons',
                            'name' => 'buttons',
                            'aria-label' => '',
                            'type' => 'repeater',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_6447e90bac7d9',
                                        'operator' => '==',
                                        'value' => 'show',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'layout' => 'block',
                            'pagination' => 0,
                            'min' => 0,
                            'max' => 0,
                            'collapsed' => '',
                            'button_label' => 'Add Row',
                            'rows_per_page' => 20,
                            'sub_fields' => array(
                                array(
                                    'key' => 'field_6447e90bac7db',
                                    'label' => 'Type',
                                    'name' => 'type',
                                    'aria-label' => '',
                                    'type' => 'radio',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => 0,
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'choices' => array(
                                        'image' => 'Image',
                                        'basic' => 'Basic',
                                    ),
                                    'default_value' => 'image',
                                    'return_format' => 'value',
                                    'allow_null' => 0,
                                    'other_choice' => 0,
                                    'save_other_choice' => 0,
                                    'layout' => 'horizontal',
                                    'parent_repeater' => 'field_6447e90bac7da',
                                ),
                                array(
                                    'key' => 'field_6447e90bac7dc',
                                    'label' => 'Image Button',
                                    'name' => 'image_button',
                                    'aria-label' => '',
                                    'type' => 'group',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => array(
                                        array(
                                            array(
                                                'field' => 'field_6447e90bac7db',
                                                'operator' => '==',
                                                'value' => 'image',
                                            ),
                                        ),
                                    ),
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'layout' => 'block',
                                    'sub_fields' => array(
                                        array(
                                            'key' => 'field_6447e90bac7dd',
                                            'label' => 'Image',
                                            'name' => 'image',
                                            'aria-label' => '',
                                            'type' => 'image',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                            'library' => 'all',
                                            'min_width' => '',
                                            'min_height' => '',
                                            'min_size' => '',
                                            'max_width' => '',
                                            'max_height' => '',
                                            'max_size' => '',
                                            'mime_types' => '',
                                            'preview_size' => 'medium',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7de',
                                            'label' => 'Background Color',
                                            'name' => 'background_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#0160ac',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7df',
                                            'label' => 'Texts',
                                            'name' => 'texts',
                                            'aria-label' => '',
                                            'type' => 'repeater',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'layout' => 'block',
                                            'pagination' => 0,
                                            'rows_per_page' => 20,
                                            'min' => 0,
                                            'max' => 0,
                                            'collapsed' => '',
                                            'button_label' => 'Add Row',
                                            'sub_fields' => array(
                                                array(
                                                    'key' => 'field_6447e90bac7e0',
                                                    'label' => 'Text',
                                                    'name' => 'text',
                                                    'aria-label' => '',
                                                    'type' => 'text',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '40',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => '',
                                                    'maxlength' => '',
                                                    'placeholder' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6447e90bac7df',
                                                ),
                                                array(
                                                    'key' => 'field_6447e90bac7e1',
                                                    'label' => 'Padding',
                                                    'name' => 'text_padding',
                                                    'aria-label' => '',
                                                    'type' => 'number',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => 0,
                                                    'min' => 0,
                                                    'max' => 10,
                                                    'placeholder' => '',
                                                    'step' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6447e90bac7df',
                                                ),
                                                array(
                                                    'key' => 'field_6447e90bac7e2',
                                                    'label' => 'Size',
                                                    'name' => 'size',
                                                    'aria-label' => '',
                                                    'type' => 'number',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => 1,
                                                    'min' => 1,
                                                    'max' => 10,
                                                    'placeholder' => '',
                                                    'step' => '',
                                                    'prepend' => '',
                                                    'append' => '',
                                                    'parent_repeater' => 'field_6447e90bac7df',
                                                ),
                                                array(
                                                    'key' => 'field_6447e90bac7e3',
                                                    'label' => 'Weight',
                                                    'name' => 'weight',
                                                    'aria-label' => '',
                                                    'type' => 'select',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'choices' => array(
                                                        100 => '100',
                                                        200 => '200',
                                                        300 => '300',
                                                        400 => '400',
                                                        500 => '500',
                                                        600 => '600',
                                                        700 => '700',
                                                        800 => '800',
                                                        900 => '900',
                                                    ),
                                                    'default_value' => 400,
                                                    'return_format' => 'value',
                                                    'multiple' => 0,
                                                    'allow_null' => 0,
                                                    'ui' => 0,
                                                    'ajax' => 0,
                                                    'placeholder' => '',
                                                    'parent_repeater' => 'field_6447e90bac7df',
                                                ),
                                                array(
                                                    'key' => 'field_6447e90bac7e4',
                                                    'label' => 'Color',
                                                    'name' => 'color',
                                                    'aria-label' => '',
                                                    'type' => 'color_picker',
                                                    'instructions' => '',
                                                    'required' => 0,
                                                    'conditional_logic' => 0,
                                                    'wrapper' => array(
                                                        'width' => '15',
                                                        'class' => '',
                                                        'id' => '',
                                                    ),
                                                    'default_value' => '#FFFFFF',
                                                    'enable_opacity' => 0,
                                                    'return_format' => 'string',
                                                    'parent_repeater' => 'field_6447e90bac7df',
                                                ),
                                            ),
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7e5',
                                            'label' => 'Padding Button',
                                            'name' => 'padding_button',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 0,
                                            'min' => 0,
                                            'max' => 10,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7e6',
                                            'label' => 'Link',
                                            'name' => 'link',
                                            'aria-label' => '',
                                            'type' => 'link',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '60',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                        ),
                                        array(
                                            'key' => 'field_644abf0d20b40',
                                            'label' => 'Link Rel Option',
                                            'name' => 'link_rel_option',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'none' => 'None',
                                                'no_follow' => 'No Follow',
                                            ),
                                            'default_value' => 'none',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                    ),
                                    'parent_repeater' => 'field_6447e90bac7da',
                                ),
                                array(
                                    'key' => 'field_6447e90bac7e7',
                                    'label' => 'Basic Button',
                                    'name' => 'basic_button',
                                    'aria-label' => '',
                                    'type' => 'group',
                                    'instructions' => '',
                                    'required' => 0,
                                    'conditional_logic' => array(
                                        array(
                                            array(
                                                'field' => 'field_6447e90bac7db',
                                                'operator' => '==',
                                                'value' => 'basic',
                                            ),
                                        ),
                                    ),
                                    'wrapper' => array(
                                        'width' => '',
                                        'class' => '',
                                        'id' => '',
                                    ),
                                    'layout' => 'block',
                                    'sub_fields' => array(
                                        array(
                                            'key' => 'field_6447e90bac7f0',
                                            'label' => 'Padding Button',
                                            'name' => 'padding_button',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 0,
                                            'min' => 0,
                                            'max' => 10,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7e9',
                                            'label' => 'Text Size',
                                            'name' => 'text_size',
                                            'aria-label' => '',
                                            'type' => 'number',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => 1,
                                            'min' => 1,
                                            'max' => 20,
                                            'placeholder' => '',
                                            'step' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7ea',
                                            'label' => 'Text Weight',
                                            'name' => 'text_weight',
                                            'aria-label' => '',
                                            'type' => 'select',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                100 => '100',
                                                200 => '200',
                                                300 => '300',
                                                400 => '400',
                                                500 => '500',
                                                600 => '600',
                                                700 => '700',
                                                800 => '800',
                                                900 => '900',
                                            ),
                                            'default_value' => 400,
                                            'return_format' => 'value',
                                            'multiple' => 0,
                                            'allow_null' => 0,
                                            'ui' => 0,
                                            'ajax' => 0,
                                            'placeholder' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7eb',
                                            'label' => 'Text Color',
                                            'name' => 'color_basic',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#FFFFFF',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7ec',
                                            'label' => 'Style',
                                            'name' => 'style',
                                            'aria-label' => '',
                                            'type' => 'select',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'info' => 'Info',
                                                'success' => 'Success',
                                                'warning' => 'Warning',
                                                'danger' => 'Danger',
                                                'custom' => 'Custom',
                                            ),
                                            'default_value' => 'info',
                                            'return_format' => 'value',
                                            'multiple' => 0,
                                            'allow_null' => 0,
                                            'ui' => 0,
                                            'ajax' => 0,
                                            'placeholder' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7ed',
                                            'label' => 'Border Color',
                                            'name' => 'border_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6447e90bac7ec',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '33',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#3a96e0',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7ee',
                                            'label' => 'Background Color',
                                            'name' => 'background_color_button',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6447e90bac7ec',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '33',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#0160ac',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7ef',
                                            'label' => 'Hover Color',
                                            'name' => 'hover_color',
                                            'aria-label' => '',
                                            'type' => 'color_picker',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_6447e90bac7ec',
                                                        'operator' => '==',
                                                        'value' => 'custom',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '34',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '#03467d',
                                            'enable_opacity' => 0,
                                            'return_format' => 'string',
                                        ),
                                        array(
                                            'key' => 'field_644a6528d6405',
                                            'label' => 'Display Text',
                                            'name' => 'display_text',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => 0,
                                            'wrapper' => array(
                                                'width' => '30',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'show' => 'Show',
                                                'hide' => 'Hide',
                                            ),
                                            'default_value' => 'show',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7e8',
                                            'label' => 'Text',
                                            'name' => 'text_basic',
                                            'aria-label' => '',
                                            'type' => 'text',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a6528d6405',
                                                        'operator' => '==',
                                                        'value' => 'show',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '70',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'default_value' => '',
                                            'maxlength' => '',
                                            'placeholder' => '',
                                            'prepend' => '',
                                            'append' => '',
                                        ),
                                        array(
                                            'key' => 'field_6447e90bac7f1',
                                            'label' => 'Link',
                                            'name' => 'link',
                                            'aria-label' => '',
                                            'type' => 'link',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a6528d6405',
                                                        'operator' => '==',
                                                        'value' => 'hide',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '50',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'return_format' => 'array',
                                        ),
                                        array(
                                            'key' => 'field_644abda0d2c13',
                                            'label' => 'Link Rel Option',
                                            'name' => 'link_rel_option',
                                            'aria-label' => '',
                                            'type' => 'radio',
                                            'instructions' => '',
                                            'required' => 0,
                                            'conditional_logic' => array(
                                                array(
                                                    array(
                                                        'field' => 'field_644a6528d6405',
                                                        'operator' => '==',
                                                        'value' => 'hide',
                                                    ),
                                                ),
                                            ),
                                            'wrapper' => array(
                                                'width' => '20',
                                                'class' => '',
                                                'id' => '',
                                            ),
                                            'choices' => array(
                                                'none' => 'None',
                                                'no_follow' => 'No Follow',
                                            ),
                                            'default_value' => 'none',
                                            'return_format' => 'value',
                                            'allow_null' => 0,
                                            'other_choice' => 0,
                                            'layout' => 'horizontal',
                                            'save_other_choice' => 0,
                                        ),
                                    ),
                                    'parent_repeater' => 'field_6447e90bac7da',
                                ),
                            ),
                        ),
                    ),
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'reviews',
                    ),
                ),
            ),
            'menu_order' => 1,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
        ));

    endif;
}

add_action('acf/init', 'post_type_review_bookie_sumary_register_fields');

function post_type_review_quick_links_register_fields() {
    if( function_exists('acf_add_local_field_group') ):
        acf_add_local_field_group(array(
            'key' => 'group_quick_link_custom_post_type_we24d24432s4',
            'title' => 'Quick Links',
            'fields' => array(
                array(
                    'key' => 'field_64482404d9261',
                    'label' => 'Title',
                    'name' => 'quick_links_title',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_64482404dce0b',
                    'label' => 'Items',
                    'name' => 'quick_links_items',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'pagination' => 0,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Row',
                    'rows_per_page' => 20,
                    'sub_fields' => array(
                        array(
                            'key' => 'field_64482404e491a',
                            'label' => 'Text',
                            'name' => 'text',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_64482404dce0b',
                        ),
                        array(
                            'key' => 'field_64482404e84bc',
                            'label' => 'Link',
                            'name' => 'link',
                            'aria-label' => '',
                            'type' => 'link',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                            'parent_repeater' => 'field_64482404dce0b',
                        ),
                    ),
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'reviews',
                    ),
                ),
            ),
            'menu_order' => 2,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
        ));

    endif;
}

add_action('acf/init', 'post_type_review_quick_links_register_fields');