<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_FAQ;
    $block_classes = [$block_name];
    $block_faq = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $faqs = get_field('faqs');
    $links = get_field('links');
    list($heading, $title, $styles) = $block_faq->get_title(get_fields());

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $style_header = $block_faq->get_style('header', get_field('backgound_color_header'));
    $style_content = $block_faq->get_style('content', get_field('backgound_color_content'));


?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container">
            <div class="content">
                <?php if (!empty($title)): ?>
                    <div class="wpcr-title" style="<?php echo $styles; ?>">
                        <<?php echo $heading; ?>><?php echo $title; ?></<?php echo $heading; ?>>
                    </div>
                <?php endif; ?>

                <div id="items">
                    <?php if (is_array($faqs)): ?>
                    <?php if (count($faqs) > 0): ?>
                        <?php
                            $i = 1;
                            $max = count($faqs);
                            $ID = (!empty(get_field('faq_page_id'))) ? get_field('faq_page_id') : rand(1, 999999);
                        ?>
                        <?php foreach($faqs as $faq): ?>
                            <div class="item">
                                <div class="faq-header header" ref="<?php echo $ID;?>" data="<?php echo $max;?>" id="heading<?php echo $ID.$i;?>" data-toggle="collapse" data-target="#collapse<?php echo $ID.$i;?>" aria-expanded="false" aria-controls="collapse<?php echo $ID.$i;?>" style="<?php echo $style_header; ?>">
                                    <li><?php echo $faq['title']; ?></li>
                                    <div class="icon">
                                        <i class="fal fa-chevron-down" id="heading<?php echo $ID.$i;?>-down"></i>
                                        <i class="fal fa-chevron-up hide" id="heading<?php echo $ID.$i;?>-up"></i>
                                    </div>
                                </div>
                                <div id="collapse<?php echo $ID.$i;?>" class="collapse" aria-labelledby="heading<?php echo $ID.$i;?>" data-parent="#items">
                                    <div class="body" style="<?php echo $style_content; ?>">
                                        <?php echo $faq['content']; ?>
                                    </div>
                                </div>
                            </div>
                            <?php $i++; ?>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php if (is_array($links) && count($links) > 0): ?>
            <div class="buttons">
                <?php foreach($links as $link): ?>
                    <?php
                        $link_class = '';
                        $link_style = '';
                        if ($link['default_styles'] != 'custom') {
                            $link_class = 'class="'.$link['default_styles'].'"';
                        } else {
                            $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.$block_faq->get_style('buttons', $link).'"';
                        }
                    ?>
                    <?php if (!empty($link['link']['url']) && $link['link']['title']): ?>
                        <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; ?></a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
