<?php
    $api_all_links = (!empty(get_field('sports_picks_link', 'option'))) ? get_field('sports_picks_link', 'option') : null;
?>

<?php foreach($picks as $pick):?>
    <div class="pick">
        <div class="pick-header">
            <div class="title">
                <span class="header-title">
                    <?php echo (isset($titles[$pick->id_sport])) ? $titles[$pick->id_sport] : ''; ?>
                </span>
            </div>
            <div class="content">
                <div class="sport"><span><?php echo $pick->id_sport; ?></span></div>
                <div class="date-time"><span><?php echo $pick->game_date; ?></span></div>
                <div class="status"><span><?php echo $pick->game_stat; ?></span></div>
            </div>
        </div>
        <div class="pick-body">
            <div class="teams">
                <div class="team team-a">
                    <div class="team-logo">
                        <img src="<?php echo $pick->home_image; ?>" alt="">
                    </div>
                    <div class="team-name"><span><?php echo $pick->home_name; ?></span></div>
                </div>
                <div class="team team-vs">
                    <div class="vs-logo"><span>vs</span></div>
                    <div class="vs-name"><span><?php echo $pick->numPicks; ?> PICKS</span></div>
                </div>
                <div class="team team-b">
                    <div class="team-logo">
                        <img src="<?php echo $pick->visitor_image; ?>" alt="">
                    </div>
                    <div class="team-name"><span><?php echo $pick->visitor_name; ?></span></div>
                </div>
            </div>
        </div>

        <?php if (!empty($api_all_links)): ?>
            <div class="pick-footer">
                <a href="<?php echo $api_all_links['url']; ?>" target="<?php echo (empty($api_all_links['target'])) ? '_self' : $api_all_links['target']; ?>"><?php echo $api_all_links['title']; ?></a>
            </div>
        <?php endif; ?>
    </div>
<?php endforeach; ?>
