<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Admin_Cappers extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_ADMIN_CAPPERS;
    private $block_folder_name = 'rdg-admin-cappers';
    protected $block_title = 'RDG Admin Cappers';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'admin', 'capper'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_admin_cappers.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_admin_cappers_block_sdfwddd',
                'title' => 'Block_rdg_admin_cappers',
                'fields' => array(
                    array(
                        'key' => 'field_63a25288175503we3',
                        'label' => 'Cappers',
                        'name' => 'cappers',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63a252886c78d',
                                'label' => 'Logo',
                                'name' => 'logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_63a25288175503we3',
                            ),
                            array(
                                'key' => 'field_63a252883c5a7',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63a25288175503we3',
                            ),
                            array(
                                'key' => 'field_63a3409d3f73e',
                                'label' => 'Sub Title',
                                'name' => 'sub_title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63a25288175503we3',
                            ),
                            array(
                                'key' => 'field_63a340bc3f73f',
                                'label' => 'Total',
                                'name' => 'total',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63a25288175503we3',
                            ),
                            array(
                                'key' => 'field_63a340d23f740',
                                'label' => 'Picks',
                                'name' => 'picks',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63a25288175503we3',
                            ),
                            array(
                                'key' => 'field_63a341813f741',
                                'label' => 'Description',
                                'name' => 'description',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'parent_repeater' => 'field_63a25288175503we3',
                            ),
                            array(
                                'key' => 'field_63d58f243f064',
                                'label' => 'Teams',
                                'name' => 'teams',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_63a252883ff2f',
                                        'label' => 'Category',
                                        'name' => 'category',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d58f243f064',
                                    ),
                                    array(
                                        'key' => 'field_63a25288439c1',
                                        'label' => 'Date',
                                        'name' => 'date',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d58f243f064',
                                    ),
                                    array(
                                        'key' => 'field_63a2528847545',
                                        'label' => 'Status',
                                        'name' => 'status',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d58f243f064',
                                    ),
                                    array(
                                        'key' => 'field_63a341b83f742',
                                        'label' => 'Home Team',
                                        'name' => 'home_team',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d58f243f064',
                                    ),
                                    array(
                                        'key' => 'field_63a342073f743',
                                        'label' => 'Visitor Team',
                                        'name' => 'visitor_team',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d58f243f064',
                                    ),
                                    array(
                                        'key' => 'field_63a342e43f744',
                                        'label' => 'Release Date',
                                        'name' => 'release_date',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d58f243f064',
                                    ),
                                ),
                                'parent_repeater' => 'field_63a25288175503we3',
                            ),
                            array(
                                'key' => 'field_63a2528855ff5',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63a25288175503we3',
                            ),
                            array(
                                'key' => 'field_63d599d53967b',
                                'label' => 'Status',
                                'name' => 'status',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63a25288175503we3',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_63a2528825ebb',
                        'label' => 'Buttons',
                        'name' => 'links',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63a2528891ffc',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63a2528825ebb',
                            ),
                            array(
                                'key' => 'field_63a25288959b2',
                                'label' => 'Default Styles',
                                'name' => 'default_styles',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'link-success' => 'Success',
                                    'link-warning' => 'Warning',
                                    'link-danger' => 'Danger',
                                    'link-default' => 'Default',
                                    'custom' => 'Custom',
                                ),
                                'default_value' => 'link-success',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63a2528825ebb',
                            ),
                            array(
                                'key' => 'field_63a252889959d',
                                'label' => 'Background color',
                                'name' => 'background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63a25288959b2',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63a2528825ebb',
                            ),
                            array(
                                'key' => 'field_63a252889d0cb',
                                'label' => 'Background Hover Color',
                                'name' => 'background_hover_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63a25288959b2',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63a2528825ebb',
                            ),
                            array(
                                'key' => 'field_63a25288a0be6',
                                'label' => 'Text color',
                                'name' => 'text_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63a25288959b2',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_63a2528825ebb',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-admin-cappers',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_style($type, $fields) {
        $style = [];

        if ('buttons' == $type) {
            $style[] = 'background-color: '.$fields['background_color'];
            $style[] = 'color: '.$fields['text_color'];
    
            return implode('; ', $style);
        }
    
        return '';
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-admin-cappers-capper-bg', 'slug' => 'color-admin-cappers-capper-bg', 'color' => '#FFFFFF'],
            ['name' => 'color-admin-cappers-capper-header-border', 'slug' => 'color-admin-cappers-capper-header-border', 'color' => '#F1F1F1'],
            ['name' => 'color-admin-cappers-capper-team-vs', 'slug' => 'color-admin-cappers-capper-team-vs', 'color' => '#111111'],
            ['name' => 'color-admin-cappers-capper-title', 'slug' => 'color-admin-cappers-capper-title', 'color' => '#111111'],
            ['name' => 'color-admin-cappers-capper-sub-title', 'slug' => 'color-admin-cappers-capper-sub-title', 'color' => '#3a96e0'],
            ['name' => 'color-admin-cappers-capper-total', 'slug' => 'color-admin-cappers-capper-total', 'color' => '#111111'],
            ['name' => 'color-admin-cappers-capper-picks', 'slug' => 'color-admin-cappers-capper-picks', 'color' => '#00bc00'],
            ['name' => 'color-admin-cappers-capper-teams', 'slug' => 'color-admin-cappers-capper-teams', 'color' => '#0160ac'],
            ['name' => 'color-admin-cappers-capper-footer', 'slug' => 'color-admin-cappers-capper-footer', 'color' => '#FFFFFF'],
            ['name' => 'color-admin-cappers-capper-footer-bg', 'slug' => 'color-admin-cappers-capper-footer-bg', 'color' => '#0160ac'],
            ['name' => 'color-admin-cappers-capper-footer-footer-link', 'slug' => 'color-admin-cappers-capper-footer-footer-link', 'color' => '#FFFFFF'],
            ['name' => 'color-admin-cappers-capper-footer-footer-link-hover', 'slug' => 'color-admin-cappers-capper-footer-footer-link-hover', 'color' => '#3a96e0'],
            ['name' => 'color-admin-cappers-buttons-link', 'slug' => 'color-admin-cappers-buttons-link', 'color' => '#FFFFFF'],
            ['name' => 'color-admin-cappers-block-preview-pick-title', 'slug' => 'color-admin-cappers-block-preview-pick-title', 'color' => '#3a96e0'],
            ['name' => 'color-admin-cappers-block-preview-pick-bg', 'slug' => 'color-admin-cappers-block-preview-pick-bg', 'color' => '#0160ac'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-content .content-description',
                'fontSize' => '0.9rem',
                'fontWeight' => '600',
                'lineHeight' => '1.2rem'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-content .content-description a',
                'textDecoration' => 'none',                
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-header .header-content .title',
                'fontWeight' => '700',
                'lineHeight' => '1.1rem'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-header .sub-title',
                'fontSize' => '0.8rem',
                'fontWeight' => '700',
                'lineHeight' => '1.1rem'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-header .total',
                'fontSize' => '0.7rem',
                'fontWeight' => '700',
                'lineHeight' => '1.1rem'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-header .total .picks',
                'fontSize' => '0.7rem',
                'fontWeight' => '700',
                'lineHeight' => '1.1rem'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-content .teams .team .content-category .category span',
                'fontWeight' => '700',
                'fontSize' => '0.9rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-content .teams .team .content-category .date span',
                'fontWeight' => '500',
                'fontSize' => '0.9rem'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-content .teams .team .content-category .status span',
                'fontWeight' => '700',
                'fontSize' => '0.9rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-content .teams .team .content-teams',
                'fontWeight' => '700',
                'fontSize' => '0.9rem',
                'textTransform' => 'uppercase'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .content .capper-content .teams .team .content-release .release-date',
                'fontWeight' => '500',
                'fontSize' => '0.9rem'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .capper-footer',
                'fontWeight' => '600',
                'fontSize' => '1rem'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .capper-footer .footer-link a',
                'textDecoration' => 'none'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .cappers .capper .capper-footer .footer-status',
                'textTransform' => 'uppercase'
            ],
            [
                'customSelector' => '.rdg-admin-cappers .buttons',
                'fontSize' => '1rem',
                'fontWeight' => '500'
            ]
        ];
    }
}

$rdg_admin_cappers_class = new Rdg_Blocks_Admin_Cappers();
$rdg_admin_cappers_class->init();

return $rdg_admin_cappers_class;
