<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $name_block = BLOCK_RDG_FAQ;
    $block_classes = ['rdg-faq'];
    $block_title = $rdgb->settings->getBlock($name_block);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $id_faq = (!empty(get_field('faq_page_id'))) ? get_field('faq_page_id') : random_int(1, 999999);
    $faqs = get_field('faqs');
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <div class="faq-container">
            <?php
                    $i = 1;
                    $max = (!empty($faqs)) ? count($faqs) : 0;
                ?>
                <?php if ($max > 0): ?>
                    <?php foreach($faqs as $faq): ?>
                <div class="faq-item" data="<?php echo $max;?>" id="<?php echo $id_faq.$i;?>">
                    <div class="question">
                        <p><?php echo $faq['title']; ?></p>
                        <span class="toggle"><i class="fal fa-plus"></i></span>
                    </div>
                    <div class="answer">
                        <p><?php echo $faq['content']; ?></p>
                    </div>
                </div>
                <?php $i++; ?>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php
    if ($max > 0 && !empty(get_field('faq_page_id'))) {
        echo $block_title->set_json_faqs($faqs, get_field('faq_page_id'));
    }
?>