<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Handicapper_Pick_Results extends Rdg_Blocks_Base implements Rdg_Blocks_Api_Request
{
    protected $block_name = BLOCK_RDG_HANDICAPPER_PICK_RESULTS;
    private $block_folder_name = 'rdg-handicapper-pick-results';
    protected $block_title = 'RDG Handicapper Pick Results';
    private $block_description = 'This block displays scores and odds for various sports events. The block can display the latest scores, scores for a specific date, or scores within a date range.';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'handicapper', 'pick', 'result', 'api'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = true;
    protected $is_config = true;
    protected $is_styles_load = true;
    protected $config_page_title = 'RDG Handicapper Pick Results';
    protected $config_menu_title = 'Handicapper Pick Results';

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_config_menu'], 20);
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_handicapper_pick_results.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-handicapper-pick-results-preview.png",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'render_callback' => function($block) use ($rdg_helpers) {
                    global $wp_query;
                    $loop = $wp_query->in_the_loop;
                    $template_path = RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php";

                    if ($loop) {
                        include $template_path;
                        return;
                    }

                    $trace_config = $rdg_helpers->getBacktraceConfig();
                    $traces = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, $trace_config['max_trace']);
                    $trace_valid_admin = $rdg_helpers->checkExistsTraceFunction($traces, $trace_config['max_trace'], $trace_config['functions']);

                    if (is_admin() && !$trace_valid_admin) {
                        include $template_path;
                        return;
                    }
                },
            ]);
        }
    }

    public function register_fields() {
        $sports = (function_exists('shMappingSportsLeaguesOption')) ? shMappingSportsLeaguesOption() : [];
        $handicapper = (function_exists('shMappingHandicappers')) ? shMappingHandicappers() : [];

        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group( array(
                'key' => 'group_67c09bbd38797',
                'title' => 'Handicapper Pick Results',
                'fields' => array(
                    array(
                        'key' => 'field_67c09bbe687f7',
                        'label' => 'Source',
                        'name' => 'source',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'api' => 'API',
                            'manual' => 'Manual',
                        ),
                        'default_value' => '',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'allow_in_bindings' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_67c09cbf687f8',
                        'label' => 'Handicapper',
                        'name' => 'handicapper',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67c09bbe687f7',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => $handicapper,
                        'default_value' => '',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'max' => '',
                        'allow_custom' => 0,
                        'search_placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'allow_null' => 0,
                        'allow_in_bindings' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                        'min' => '',
                    ),
                    array(
                        'key' => 'field_67c09d30687f9',
                        'label' => 'Sports',
                        'name' => 'sports',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67c09bbe687f7',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => [0 => 'Choose an option'] + $sports,
                        'default_value' => false,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'max' => '',
                        'prepend' => '',
                        'append' => '',
                        'allow_null' => 0,
                        'allow_in_bindings' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                        'allow_custom' => 0,
                        'search_placeholder' => '',
                        'min' => '',
                    ),
                    array(
                        'key' => 'field_67c09d54687fa',
                        'label' => 'Date',
                        'name' => 'date',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67c09bbe687f7',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'nodate' => 'Lifetime',
                            'specific' => 'Specific Date',
                            'range' => 'Range',
                        ),
                        'default_value' => 'nodate',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'max' => '',
                        'prepend' => '',
                        'append' => '',
                        'allow_null' => 0,
                        'allow_in_bindings' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                        'allow_custom' => 0,
                        'search_placeholder' => '',
                        'min' => '',
                    ),
                    array(
                        'key' => 'field_67c09f88687fb',
                        'label' => 'Primary Date',
                        'name' => 'primary_date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67c09d54687fa',
                                    'operator' => '==',
                                    'value' => 'specific',
                                ),
                            ),
                            array(
                                array(
                                    'field' => 'field_67c09d54687fa',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                        'placeholder' => '',
                        'min_date' => '',
                        'max_date' => '',
                        'no_weekends' => 0,
                        'allow_in_bindings' => 0,
                    ),
                    array(
                        'key' => 'field_67c0a013687fe',
                        'label' => 'Secondary Date',
                        'name' => 'secondary_date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_67c09d54687fa',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                        'placeholder' => '',
                        'min_date' => '',
                        'max_date' => '',
                        'no_weekends' => 0,
                        'allow_in_bindings' => 0,
                    ),
                    array(
                        'key' => 'field_67c0a52c34121',
                        'label' => 'Manual Options',
                        'name' => 'repeater',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_67c09bbe687f7',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'acfe_repeater_stylised_button' => 0,
                        'layout' => 'row',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_67c0a0d9d5a2e',
                                'label' => 'Game Date',
                                'name' => 'game_date',
                                'aria-label' => '',
                                'type' => 'date_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_67c09bbe687f7',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'display_format' => 'Y-m-d',
                                'return_format' => 'Y-m-d',
                                'first_day' => 1,
                                'placeholder' => '',
                                'min_date' => '',
                                'max_date' => '',
                                'no_weekends' => 0,
                                'allow_in_bindings' => 0,
                                'parent_repeater' => 'field_67c0a52c34121',
                            ),
                            array(
                                'key' => 'field_67c0a121d5a2f',
                                'label' => 'Sport',
                                'name' => 'sport',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_67c09bbe687f7',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67c0a52c34121',
                            ),
                            array(
                                'key' => 'field_67c0a12ed5a30',
                                'label' => 'Home Team',
                                'name' => 'home_team',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_67c09bbe687f7',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67c0a52c34121',
                            ),
                            array(
                                'key' => 'field_67c0a13cd5a31',
                                'label' => 'Visitor Team',
                                'name' => 'visitor_team',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_67c09bbe687f7',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67c0a52c34121',
                            ),
                            array(
                                'key' => 'field_67c0a153d5a32',
                                'label' => 'Score',
                                'name' => 'score',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_67c09bbe687f7',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67c0a52c34121',
                            ),
                            array(
                                'key' => 'field_67c0a160d5a33',
                                'label' => 'Bet Type',
                                'name' => 'bet_type',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_67c09bbe687f7',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'allow_in_bindings' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_67c0a52c34121',
                            ),
                            array(
                                'key' => 'field_67c0a176d5a35',
                                'label' => 'Description',
                                'name' => 'description',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_67c09bbe687f7',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'acfe_wysiwyg_auto_init' => 0,
                                'acfe_wysiwyg_height' => 300,
                                'acfe_wysiwyg_max_height' => '',
                                'acfe_wysiwyg_valid_elements' => '',
                                'acfe_wysiwyg_custom_style' => '',
                                'acfe_wysiwyg_disable_wp_style' => 0,
                                'acfe_wysiwyg_autoresize' => 0,
                                'acfe_wysiwyg_disable_resize' => 0,
                                'acfe_wysiwyg_remove_path' => 0,
                                'acfe_wysiwyg_menubar' => 0,
                                'acfe_wysiwyg_transparent' => 0,
                                'acfe_wysiwyg_merge_toolbar' => 0,
                                'acfe_wysiwyg_custom_toolbar' => 0,
                                'allow_in_bindings' => 0,
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 1,
                                'delay' => 0,
                                'acfe_wysiwyg_min_height' => 300,
                                'acfe_wysiwyg_toolbar_buttons' => array(
                                ),
                                'parent_repeater' => 'field_67c0a52c34121',
                            ),
                            array(
                                'key' => 'field_67c0a189d5a36',
                                'label' => 'Result',
                                'name' => 'result',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'win' => 'Win',
                                    'lose' => 'Lose',
                                    'draw' => 'Draw',
                                ),
                                'default_value' => false,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'max' => '',
                                'prepend' => '',
                                'append' => '',
                                'allow_null' => 0,
                                'allow_in_bindings' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'allow_custom' => 0,
                                'search_placeholder' => '',
                                'min' => '',
                                'parent_repeater' => 'field_67c0a52c34121',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-handicapper-pick-results',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'left',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
                'acfe_autosync' => array(
                    0 => 'php',
                ),
                'acfe_form' => 0,
                'acfe_display_title' => '',
                'acfe_meta' => '',
                'acfe_note' => '',
            ) );
        endif;
    }

    public function register_config_menu() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'api_configuration_handicapper_pick_results_block_sdfw34fs2332',
                'title' => 'API configuration',
                'fields' => array(
                    array(
                        'key' => 'key_handicapper_pick_results_api_url',
                        'label' => 'URL',
                        'name' => 'handicapper_pick_results_api_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'key_handicapper_pick_results_api_token',
                        'label' => 'Token',
                        'name' => 'handicapper_pick_results_api_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'key_handicapper_pick_results_interval',
                        'label' => 'Cache Refresh Frequency (Hours)',
                        'name' => 'handicapper_pick_results_interval',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-handicapper-pick-results',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getApiAttributes($items = null, $attributes = []) {
        $api_url = get_field('handicapper_pick_results_api_url', 'option');
        $api_token = get_field('handicapper_pick_results_api_token', 'option');
        $cache_refresh = get_field('handicapper_pick_results_interval', 'option');
        $items = (!empty($items)) ? intval($items) : 10;

        $api_url = (substr($api_url, -1) == '/') ? substr($api_url, 0, strlen($api_url) -1) : $api_url;

        if (isset($attributes['handicapper']) && !empty($attributes['handicapper'])) {
            $api_url .= '?id_handicapper=' . $attributes['handicapper'];
        }

        $sports = null;
        $league = null;

        if (isset($attributes['sports']) && strpos($attributes['sports'], '-')) {
            list($sports, $league) = explode('-', $attributes['sports']);
                $league = shMappingSportsConverter([$sports => [$league]], 'members');
        } else {
            if (isset($attributes['sports']) && !empty($attributes['sports'])) {
                $sports = $attributes['sports'];
                $sports = shMappingSportsConverter([$sports => ""], 'members'); 
            }
        }
        
        if (!empty($league)) {
            $api_url .= '&id_league='.$league;
        } else if (!empty($sports)) {
            $api_url .= '&id_sport='.$sports;
        }
        
        if (!empty($attributes['primary_date'])) {
            $api_url .= '&principalDate=' .$attributes['primary_date'];
        } 

        if (!empty($attributes['secondary_date'])) {
            $api_url .= '&secondaryDate=' . $attributes['secondary_date'];
        }

        $api_request = $api_url.'&api_token='.$api_token; 

        return [
            'items' => $items,
            'method' => 'GET',
            'cache_refresh' => $cache_refresh,
            'headers' => ['Accept: application/json'],
            'request' => $api_request,
        ];
    }

    public function getApiParams() {
        return [
            'handicapper' => 'handicapper',
            'sports' => 'sports',
            'date_type' => 'date_type',
            '_to_transform_' => [
                [
                    'key' => 'primary_date',
                    'function' => 'formatDate',
                    'params' => ['primary_date'],
                    'fields_date' => ['primary_date'],
                ],[
                    'key' => 'secondary_date',
                    'function' => 'formatDate',
                    'params' => ['secondary_date'],
                    'fields_date' => ['secondary_date'],
                ],
            ]
        ];
    }

    public function formatDate($date) {
        $rdgb_helpers = New Rdg_Blocks_Helpers;
    
        return $rdgb_helpers->getValidDate($date);
    }

    public function getResources($request, $cache_file) {
        $data = new StdClass();
        $data->json = '';
        $data->message = '';

        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $handicapper_pick_results = $rdgb_helpers->getApiData($this->block_name, $cache_file, $request);

        if (!empty($handicapper_pick_results->message)) {
            $data->message = $handicapper_pick_results->message;
        
            return $data;
        }

        $data->json = $handicapper_pick_results->json;

        return $data;
    }

    public function getFieldsValidate() {
        return [
            'result' => ['required', 'notnull'],
            'pick_details' => ['required', 'notnull'],
            'bet_type' => ['required', 'notnull'],
            'id_sport' => ['required', 'notnull'],
        ];
    }

    public function get_style($type, $fields) {
        $style = [];

        if ('buttons' == $type) {
            $style[] = 'background-color: '.$fields['background_color'];
            $style[] = 'color: '.$fields['text_color'];
    
            return implode('; ', $style);
        }
    
        return '';
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-hpr-border','slug' => 'color-rdg-hpr-border','color' => '#ccc'],
            ['name' => 'color-rdg-hpr-p','slug' => 'color-rdg-hpr-p','color' => '#8392ab'],
            ['name' => 'color-rdg-hpr-tr-bg','slug' => 'color-rdg-hpr-tr-bg','color' => '#fff'],
            ['name' => 'color-rdg-hpr-tr-border','slug' => 'color-rdg-hpr-tr-border','color' => '#ddd'],
            ['name' => 'color-rdg-hpr-th-bg','slug' => 'color-rdg-hpr-th-bg','color' => '#EEF4FC'],
            ['name' => 'color-rdg-hpr-win','slug' => 'color-rdg-hpr-win','color' => '#54B936'],
            ['name' => 'color-rdg-hpr-lose','slug' => 'color-rdg-hpr-lose','color' => '#E10000'],
            ['name' => 'color-rdg-hpr-draw','slug' => 'color-rdg-hpr-draw','color' => '#7c7c7c'],
            ['name' => 'color-rdg-hpr-p-black','slug' => 'color-rdg-hpr-p-black','color' => '#222'],
            ['name' => 'color-rdg-hpr-btn-bg','slug' => 'color-rdg-hpr-btn-bg','color' => '#1C4579'],
            ['name' => 'color-rdg-hpr-td-before','slug' => 'color-rdg-hpr-td-before','color' => '#1C4579'],
            ['name' => 'color-rdg-hpr-team','slug' => 'color-rdg-hpr-team','color' => '#0160ac'],
            ['name' => 'color-rdg-hpr-btn-bg-hover','slug' => 'color-rdg-hpr-btn-bg-hover','color' => '#0160ac'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-handicapper-pick-results .hpr-containertable th',
                'letterSpacing' =>'-0.01em',
            ],
        ];
    }
}

$rdg_handicapper_pick_results_class = new Rdg_Blocks_Handicapper_Pick_Results();
$rdg_handicapper_pick_results_class->init();

return $rdg_handicapper_pick_results_class;