<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_MAIN_PROMOTIONS;
    $block_classes = [$block_name];
    $block_main_promotions = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $promotions = get_field('promotions');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>
            
            <div class="body">
                <div class="promotions">
                    <?php if(is_array($promotions) && count($promotions) > 0): ?>
                        <?php foreach($promotions as $promotion): ?>
                            <div class="promotion" style="background-image: url(<?php echo (isset($promotion['backgound_image']['url']) && !empty($promotion['backgound_image']['url'])) ? $promotion['backgound_image']['url'] : ''; ?>);">
                                <div class="body" style="width: <?php echo $promotion['width']; ?>%">
                                    <?php if (!empty($promotion['titles']) && count($promotion['titles']) > 0): ?>
                                        <?php foreach($promotion['titles'] as $title): ?>
                                            <span class="heading" style="<?php echo $block_main_promotions->get_style('heading', $title); ?>"><?php echo $title['title']; ?></span>
                                        <?php endforeach;?>
                                    <?php endif;?>
                                </div>
                            </div>
                        <?php endforeach;?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
