<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $block_styles = [];
    $name_block = BLOCK_RDG_MEMBERSHIPS;
    $block_classes = [$name_block];
    $block_title = $rdgb->settings->getBlock($name_block);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());

    $title= get_field('title');
    $imageList = (!empty(get_field('list_style_image'))) ? get_field('list_style_image') : null;

    $firstPack = get_field('first_pack');
    $thirdPack = get_field('third_pack');
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <!-- Block Title -->
            <div class="title">
                <p><?php echo $title; ?></p>
            </div>

            <!-- Container -->
            <div class="column">

                <!-- First Pack -->
                <div class="first_pack">
                    <?php  
                    
                    if( $firstPack) {
                    
                        $title = $firstPack['title'];
                        $description = $firstPack['description'];
                        $price = $firstPack['price'];

                        $link = (!empty($firstPack['link'])) ? $firstPack['link'] : null;

                    ?>
                        <div class="header">
                            <p><?php echo  $title;?></p>
                        </div>
                        <div class="body">
                            <div class="description">
                                <?php echo $description; ?>
                            </div>
                            <div class="footer">
                                <div class="price">
                                    <p>$<?php echo $price; ?></p>
                                </div>
                                <?php if (is_array($link) && isset($link['url'])): ?>
                                    <div class="btn">
                                        <a href="<?php echo $link['url']; ?>"><?php echo $link['title']; ?></a>
                                    </div>
                            <?php endif; ?>
                            </div>
                        </div>
                    <?php } ?>
                <!-- End First Pack -->
                </div>

                <!-- Second Pack -->
                <div class="second_pack">
                    <?php  
                        if( have_rows('second_pack') ): while ( have_rows('second_pack') ) : the_row(); 
                            
                            $secondTitle = get_sub_field('title');
                            $secondPrice= get_sub_field('price');
                            $secondDescription = get_sub_field('description');
                            $secondLink = (!empty(get_sub_field('link'))) ? get_sub_field('link') : null;

                        ?>

                        <div class="header">
                            <p><?php echo $secondTitle ; ?></p>
                        </div>
                        <div class="body">
                            <div class="deal">
                                <div class="price">
                                <p>$<?php echo $secondPrice; ?></p>
                                </div>
                                <div class="list">
                                <?php if (is_array($imageList) && isset($imageList['url'])): ?>
                                    <ul style="list-style-image: url('<?php echo $imageList['url']; ?>');"><?php endif; ?>
                                        <?php if( have_rows('list') ): while ( have_rows('list') ) : the_row();  ?>
                                            <li><?php echo get_sub_field('list_info') ?></li>
                                        <?php endwhile; endif; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="description">
                                <?php echo $secondDescription; ?>
                            </div>
                            <?php if (is_array($secondLink) && isset($secondLink['url'])): ?>
                                <div class="btn">
                                    <a href="<?php echo $secondLink['url']; ?>"><?php echo $secondLink['title']; ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endwhile; endif; ?>
                <!-- End Second Pack -->
                </div>

                <!-- Third Pack -->
                <div class="third_pack">
                    <?php  
                    
                        if( $thirdPack ) {
                            
                            $thirdTitle = $thirdPack ['title'];
                            $thirdDescription = $thirdPack['description'];
                            $thirdPrice = $thirdPack ['price'];
                            $thirdGreat_Value = $thirdPack ['great_value'];
                            
                            $thirdGreat_ValueImg = (!empty($thirdPack['great_value_image'])) ? $thirdPack['great_value_image'] : null;
                            $thirdLink = (!empty($thirdPack['link'])) ? $thirdPack['link'] : null;

                        ?>

                        <div class="header">
                            <p><?php echo  $thirdTitle; ?></p>
                        </div>
                        <div class="body">
                            <div class="left">
                                <div class="description">
                                <p><?php echo  $thirdDescription; ?></p> 
                                </div>
                                <div class="great_value">
                                    <?php if ($thirdGreat_Value && is_array($thirdGreat_ValueImg) && isset($thirdGreat_ValueImg['url'])) { ?>
                                        <img src="<?php echo $thirdGreat_ValueImg['url']; ?>" alt="<?php echo $thirdGreat_ValueImg['alt'];?>">
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="right">
                                <div class="price">
                                    <div class="dollar">$</div>
                                    <div class="amount"><?php echo  $thirdPrice; ?></div>
                                </div>
                                <?php if (is_array($thirdLink) && isset($thirdLink['url'])): ?>
                                <div class="btn">
                                    <a href="<?php echo $thirdLink['url']; ?>"><?php echo $thirdLink['title']; ?></a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php } ?>
                <!-- End Third Pack -->
                </div>

                <!-- Fourth Pack -->
                <div class="fourth_pack">
                    <?php  
                    
                        if ( have_rows('fourth_pack') ): while ( have_rows('fourth_pack') ) : the_row(); 
                            
                        $fourthTitle = get_sub_field('title');
                        $fourthDiscount= get_sub_field('discount');
                        $fourthBestDeal= get_sub_field('best_deal');

                        $fourthLink = (!empty(get_sub_field('link'))) ? get_sub_field('link') : null;
                    
                    ?>

                        <div class="header">
                            <p><?php echo $fourthTitle; ?></p>
                        </div>
                        <div class="body">
                            <div class="deal">
                                <span class="off"><?php echo $fourthDiscount; ?></span> 
                                    <span class="dot">•</span> 
                                <span class="best_deal"><?php echo $fourthBestDeal; ?></span>
                            </div>
                            <div class="list">
                            <?php if (is_array($imageList) && isset($imageList['url'])): ?>
                                <ul style="list-style-image: url('<?php echo $imageList['url']; ?>');"><?php endif; ?>
                                    <?php if( have_rows('list') ): while ( have_rows('list') ) : the_row(); ?>
                                        <li><?php echo get_sub_field('list_info') ?></li>
                                   <?php endwhile; endif; ?>
                                </ul>
                            </div>
                            <?php if (is_array($fourthLink) && isset($fourthLink['url'])): ?>
                                    <div class="btn">
                                        <a href="<?php echo $fourthLink['url']; ?>"><?php echo $fourthLink['title']; ?></a>
                                    </div>
                            <?php endif; ?>
                        </div>

                    <?php endwhile; endif; ?>
                <!-- End Fourth Pack -->
                </div>

                <!-- End Container -->
            </div>

            <!-- End Grid Container -->
        </div>
    </div>
</div>