<?php 
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_SIMPLE_POST_LIST;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->getBlock($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $image = get_field('image');
    $title = get_field('title');
    $content = get_field('content');
    $link = get_field('link');

    $position_block = $rdgb->helpers->getBlocksSpaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <div class="column">
                <div class="post-img">
                    <?php if (isset($image['url']) && !empty($image['url']) && isset($image['url'])): ?>
                        <img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                    <?php endif; ?>
                </div>
                <div class="title">
                <?php echo $title; ?>
                </div>
                <div class="description">
                    <?php echo $content; ?>
                </div>
                <div class="read-more">
                    <?php if (isset($link['url']) && !empty($link['url'])): ?>
                        <a class="link" href="<?php echo $link['url']; ?>" target="<?php echo (isset($link['target']) && !empty($link['target']) ? $link['target'] : '_self'); ?>"><?php echo (isset($link['title']) && !empty($link['title'])) ? $link['title'] : 'Post Link'; ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
