<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Best_Pph extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_BEST_PPH;
    private $block_folder_name = BLOCK_RDG_BEST_PPH;
    protected $block_title = 'RDG Best PPH';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'best', 'pph'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_best_pph.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_best_pph_block_sdaasdsdasdad',
                'title' => 'Block_rdg_best_pph',
                'fields' => array(
                    array(
                        'key' => 'field_643838fc8eb4e',
                        'label' => 'Elements',
                        'name' => 'elements',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Element',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6438395c8eb50',
                                'label' => 'Background Color',
                                'name' => 'background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#FFFFFF',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                                'parent_repeater' => 'field_643838fc8eb4e',
                            ),
                            array(
                                'key' => 'field_643839478eb4f',
                                'label' => 'Header',
                                'name' => 'header',
                                'aria-label' => '',
                                'type' => 'group',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_643839828eb51',
                                        'label' => 'Logo',
                                        'name' => 'logo',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                    ),
                                    array(
                                        'key' => 'field_64383a8ca40ef',
                                        'label' => 'Background Color',
                                        'name' => 'background_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#000000',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                    ),
                                ),
                                'parent_repeater' => 'field_643838fc8eb4e',
                            ),
                            array(
                                'key' => 'field_64383b3198e8d',
                                'label' => 'Features',
                                'name' => 'features',
                                'aria-label' => '',
                                'type' => 'group',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_64383b4598e8e',
                                        'label' => 'List Style',
                                        'name' => 'list_style',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            'check' => 'Check',
                                            'chevron' => 'Chevron Right',
                                            'dot' => 'Dot',
                                            'circle' => 'Dot Circle',
                                        ),
                                        'default_value' => 'check',
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                    ),
                                    array(
                                        'key' => 'field_64383ba798e8f',
                                        'label' => 'List Color',
                                        'name' => 'list_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#04960b',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                    ),
                                    array(
                                        'key' => 'field_64383bcf98e90',
                                        'label' => 'Lists',
                                        'name' => 'lists',
                                        'aria-label' => '',
                                        'type' => 'repeater',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'layout' => 'table',
                                        'pagination' => 0,
                                        'min' => 0,
                                        'max' => 0,
                                        'collapsed' => '',
                                        'button_label' => 'Add Feature',
                                        'rows_per_page' => 20,
                                        'sub_fields' => array(
                                            array(
                                                'key' => 'field_64383be298e91',
                                                'label' => 'List',
                                                'name' => 'list',
                                                'aria-label' => '',
                                                'type' => 'text',
                                                'instructions' => '',
                                                'required' => 0,
                                                'conditional_logic' => 0,
                                                'wrapper' => array(
                                                    'width' => '',
                                                    'class' => '',
                                                    'id' => '',
                                                ),
                                                'default_value' => '',
                                                'maxlength' => '',
                                                'placeholder' => '',
                                                'prepend' => '',
                                                'append' => '',
                                                'parent_repeater' => 'field_64383bcf98e90',
                                            ),
                                        ),
                                    ),
                                ),
                                'parent_repeater' => 'field_643838fc8eb4e',
                            ),
                            array(
                                'key' => 'field_64383d32da12f',
                                'label' => 'Site',
                                'name' => 'site',
                                'aria-label' => '',
                                'type' => 'group',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_64384ea6c9e42',
                                        'label' => 'Background Color',
                                        'name' => 'background_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#ffffff',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                    ),
                                    array(
                                        'key' => 'field_64383d6ada134',
                                        'label' => 'URL',
                                        'name' => 'url',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                    ),
                                    array(
                                        'key' => 'field_64383d82da135',
                                        'label' => 'More',
                                        'name' => 'more',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                    ),
                                ),
                                'parent_repeater' => 'field_643838fc8eb4e',
                            ),
                            array(
                                'key' => 'field_64383dd11dc91',
                                'label' => 'Description',
                                'name' => 'description',
                                'aria-label' => '',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'text',
                                'media_upload' => 0,
                                'toolbar' => 'full',
                                'delay' => 0,
                                'parent_repeater' => 'field_643838fc8eb4e',
                            ),
                            array(
                                'key' => 'field_64383ee0f3b8b',
                                'label' => 'Buttons',
                                'name' => 'buttons',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Button',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_64383f01f3b8c',
                                        'label' => 'Type',
                                        'name' => 'type',
                                        'aria-label' => '',
                                        'type' => 'radio',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            'image' => 'Image',
                                            'basic' => 'Basic',
                                        ),
                                        'default_value' => 'image',
                                        'return_format' => 'value',
                                        'allow_null' => 0,
                                        'other_choice' => 0,
                                        'layout' => 'horizontal',
                                        'save_other_choice' => 0,
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_64383f6bf3b8d',
                                        'label' => 'Image',
                                        'name' => 'image',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64383f01f3b8c',
                                                    'operator' => '==',
                                                    'value' => 'image',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_64383f9df3b8e',
                                        'label' => 'Background Color',
                                        'name' => 'background_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64383f01f3b8c',
                                                    'operator' => '==',
                                                    'value' => 'image',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_64383fe0f3b8f',
                                        'label' => 'Padding Button',
                                        'name' => 'padding',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 2,
                                        'min' => '',
                                        'max' => '',
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_64384002f3b90',
                                        'label' => 'Texts',
                                        'name' => 'texts',
                                        'aria-label' => '',
                                        'type' => 'repeater',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64383f01f3b8c',
                                                    'operator' => '==',
                                                    'value' => 'image',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'layout' => 'block',
                                        'min' => 0,
                                        'max' => 0,
                                        'collapsed' => '',
                                        'button_label' => 'Add Button Title',
                                        'rows_per_page' => 20,
                                        'sub_fields' => array(
                                            array(
                                                'key' => 'field_6438400bf3b91',
                                                'label' => 'Text',
                                                'name' => 'text',
                                                'aria-label' => '',
                                                'type' => 'text',
                                                'instructions' => '',
                                                'required' => 0,
                                                'conditional_logic' => 0,
                                                'wrapper' => array(
                                                    'width' => '',
                                                    'class' => '',
                                                    'id' => '',
                                                ),
                                                'default_value' => '',
                                                'maxlength' => '',
                                                'placeholder' => '',
                                                'prepend' => '',
                                                'append' => '',
                                                'parent_repeater' => 'field_64384002f3b90',
                                            ),
                                            array(
                                                'key' => 'field_64384039f3b92',
                                                'label' => 'Padding',
                                                'name' => 'text_padding',
                                                'aria-label' => '',
                                                'type' => 'number',
                                                'instructions' => '',
                                                'required' => 0,
                                                'conditional_logic' => 0,
                                                'wrapper' => array(
                                                    'width' => '',
                                                    'class' => '',
                                                    'id' => '',
                                                ),
                                                'default_value' => 0,
                                                'min' => '',
                                                'max' => '',
                                                'placeholder' => '',
                                                'step' => '',
                                                'prepend' => '',
                                                'append' => '',
                                                'parent_repeater' => 'field_64384002f3b90',
                                            ),
                                            array(
                                                'key' => 'field_64384053f3b93',
                                                'label' => 'Size',
                                                'name' => 'size',
                                                'aria-label' => '',
                                                'type' => 'number',
                                                'instructions' => '',
                                                'required' => 0,
                                                'conditional_logic' => 0,
                                                'wrapper' => array(
                                                    'width' => '',
                                                    'class' => '',
                                                    'id' => '',
                                                ),
                                                'default_value' => 2,
                                                'min' => '',
                                                'max' => '',
                                                'placeholder' => '',
                                                'step' => '',
                                                'prepend' => '',
                                                'append' => '',
                                                'parent_repeater' => 'field_64384002f3b90',
                                            ),
                                            array(
                                                'key' => 'field_64384065f3b94',
                                                'label' => 'Weight',
                                                'name' => 'weight',
                                                'aria-label' => '',
                                                'type' => 'select',
                                                'instructions' => '',
                                                'required' => 0,
                                                'conditional_logic' => 0,
                                                'wrapper' => array(
                                                    'width' => '',
                                                    'class' => '',
                                                    'id' => '',
                                                ),
                                                'choices' => array(
                                                    100 => '100',
                                                    200 => '200',
                                                    300 => '300',
                                                    400 => '400',
                                                    500 => '500',
                                                    600 => '600',
                                                    700 => '700',
                                                    800 => '800',
                                                    900 => '900',
                                                ),
                                                'default_value' => 400,
                                                'return_format' => 'value',
                                                'multiple' => 0,
                                                'allow_null' => 0,
                                                'ui' => 0,
                                                'ajax' => 0,
                                                'placeholder' => '',
                                                'parent_repeater' => 'field_64384002f3b90',
                                            ),
                                            array(
                                                'key' => 'field_64384082f3b95',
                                                'label' => 'Color',
                                                'name' => 'color',
                                                'aria-label' => '',
                                                'type' => 'color_picker',
                                                'instructions' => '',
                                                'required' => 0,
                                                'conditional_logic' => 0,
                                                'wrapper' => array(
                                                    'width' => '',
                                                    'class' => '',
                                                    'id' => '',
                                                ),
                                                'default_value' => '#000000',
                                                'enable_opacity' => 0,
                                                'return_format' => 'string',
                                                'parent_repeater' => 'field_64384002f3b90',
                                            ),
                                        ),
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_643840a7f3b96',
                                        'label' => 'Text',
                                        'name' => 'text_basic',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64383f01f3b8c',
                                                    'operator' => '==',
                                                    'value' => 'basic',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_643840c6f3b97',
                                        'label' => 'Text Size',
                                        'name' => 'size_basic',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64383f01f3b8c',
                                                    'operator' => '==',
                                                    'value' => 'basic',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 2,
                                        'min' => '',
                                        'max' => '',
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_643840edf3b98',
                                        'label' => 'Text Weight',
                                        'name' => 'weight_basic',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64383f01f3b8c',
                                                    'operator' => '==',
                                                    'value' => 'basic',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            100 => '100',
                                            200 => '200',
                                            300 => '300',
                                            400 => '400',
                                            500 => '500',
                                            600 => '600',
                                            700 => '700',
                                            800 => '800',
                                            900 => '900',
                                        ),
                                        'default_value' => 400,
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_64384128f3b99',
                                        'label' => 'Text Color',
                                        'name' => 'color_basic',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64383f01f3b8c',
                                                    'operator' => '==',
                                                    'value' => 'basic',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#ffffff',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_6438415bf3b9a',
                                        'label' => 'Style',
                                        'name' => 'style',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_64383f01f3b8c',
                                                    'operator' => '==',
                                                    'value' => 'basic',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            'info' => 'Info',
                                            'success' => 'Success',
                                            'warning' => 'Warning',
                                            'danger' => 'Danger',
                                            'custom' => 'Custom',
                                        ),
                                        'default_value' => 'info',
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_64384190f3b9b',
                                        'label' => 'Border Color',
                                        'name' => 'border_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_6438415bf3b9a',
                                                    'operator' => '==',
                                                    'value' => 'custom',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#3a96e0',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_643841bff3b9c',
                                        'label' => 'Background Color',
                                        'name' => 'background_color_button',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_6438415bf3b9a',
                                                    'operator' => '==',
                                                    'value' => 'custom',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#0160ac',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_643841e8f3b9d',
                                        'label' => 'Hover Color',
                                        'name' => 'hover_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => array(
                                            array(
                                                array(
                                                    'field' => 'field_6438415bf3b9a',
                                                    'operator' => '==',
                                                    'value' => 'custom',
                                                ),
                                            ),
                                        ),
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#03467d',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                    array(
                                        'key' => 'field_6438420df3b9e',
                                        'label' => 'Link',
                                        'name' => 'link',
                                        'aria-label' => '',
                                        'type' => 'link',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'parent_repeater' => 'field_64383ee0f3b8b',
                                    ),
                                ),
                                'parent_repeater' => 'field_643838fc8eb4e',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-best-pph',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-best-pph-features-value','slug' => 'color-best-pph-features-value','color' => '#111111'],
            ['name' => 'color-best-pph-site-h4','slug' => 'color-best-pph-site-h4','color' => '#0160ac'],
            ['name' => 'color-best-pph-site-span','slug' => 'color-best-pph-site-span','color' => '#111'],
            ['name' => 'color-best-pph-description','slug' => 'color-best-pph-description','color' => '#111'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-best-pph .items .item .features ul .center li .value',
                'fontWeight' => '500',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-best-pph .items .item .site h4',
                'fontWeight' => '700',
                'fontSize' => '1.8rem',
            ],
            [
                'customSelector' => '.rdg-best-pph .items .item .site span',
                'fontWeight' => '600',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-best-pph .items .item .description',
                'fontSize' => '1rem',
            ],
        ];
    }
}

$rdg_best_pph_class = new Rdg_Blocks_Best_Pph();
$rdg_best_pph_class->init();

return $rdg_best_pph_class;
