<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Register extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_REGISTER;
    private $block_folder_name = 'rdg-register';
    protected $block_title = 'RDG Register';
    private $block_description = 'The block takes the info for structuring a register form but not allow to edit that';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'register'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_register.css'),
                'example' => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'isExample' => true,
                            'preview_image' => RDGBLOCKS_PLUGIN_URL."dist/images/rdg-register-template-preview.jpg",
                        ),
                    ),
                ),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-rdg-register-box-title-bg','slug' => 'color-rdg-register-box-title-bg','color' => '#00bb08'],
            ['name' => 'color-rdg-register-box-title','slug' => 'color-rdg-register-box-title','color' => '#FFFFFF'],
            ['name' => 'color-rdg-register-box-body-bg','slug' => 'color-rdg-register-box-body-bg','color' => '#FFFFFF'],
            ['name' => 'color-rdg-register-input-text','slug' => 'color-rdg-register-input-text','color' => '#F0F0F0'],
            ['name' => 'color-rdg-register-label','slug' => 'color-rdg-register-label','color' => '#000000'],
            ['name' => 'color-rdg-register-remember','slug' => 'color-rdg-register-remember','color' => '#000000'],
            ['name' => 'color-rdg-register-link-bg','slug' => 'color-rdg-register-link-bg','color' => '#00bb08'],
            ['name' => 'color-rdg-register-link','slug' => 'color-rdg-register-link','color' => '#FFFFFF'],
            ['name' => 'color-rdg-register-box-footer-border','slug' => 'color-rdg-register-box-footer-border','color' => '#C9C9C9'],
            ['name' => 'color-rdg-register-box-footer-link','slug' => 'color-rdg-register-box-footer-link','color' => '#808080'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.rdg-register .body .box .box-title',
                'fontWeight' => '600',
                'fontSize' => '1.5rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-register .body .box .box-body label',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
            [
                'customSelector' => '.rdg-register .body .box .box-body .remember',
                'fontWeight' => '600',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.rdg-register .body .box .box-body .link a',
                'fontWeight' => '600',
                'fontSize' => '1.2rem',
                'fontSizeTablet' => '1rem',
                'fontSizeMobile' => '0.9rem',
                'textTransform' => 'uppercase',
            ],
            [
                'customSelector' => '.rdg-register .body .box .box-body .box-footer a',
                'fontWeight' => '600',
                'textDecoration' => 'underline',
            ],
            [
                'customSelector' => '.acf-block-preview .rdg-register .body .box .box-body .link a',
                'textDecoration' => 'none',
            ],
        ];
    }
}

$rdg_register_class = new Rdg_Blocks_Register();
$rdg_register_class->init();

return $rdg_register_class;
