<?php  
    if (isset($block['data']['isExample']) && $block['data']['isExample']) {
        echo '<img src="' . esc_url( $block['data']['preview_image'] ) . '"style="max-width:100%; min-width:100%" alt="Preview" />';
        return;
    }

    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_name = BLOCK_RDG_SPORT_INFORMATION;
    $block_classes = [$block_name];

    // Variables
    $blockTitle = get_field('header_title');
    $postBlock = get_field('post_block');
    $handicappersBlock = get_field('handicappers_block');
    $blockFooter = get_field('footer_title');
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>">
        <div class="si_container">
            <div class="si_header">
                <?php echo $blockTitle; ?>
            </div>
            <div class="si_content">
                <!-- Post Block -->
                <?php if ($postBlock && $postBlock['show_block'] == 'yes'): ?>

                    <div class="post_block">
                        <div class="image_wrapper">
                            <?php if (isset($postBlock['featured_image']['url']) && !empty($postBlock['featured_image']['url'])): ?>
                                <img src="<?php echo esc_url($postBlock['featured_image']['url']); ?>" alt="<?php echo esc_attr(isset($postBlock['featured_image']['alt']) ? $postBlock['featured_image']['alt'] : ''); ?>" class="featured_image">
                            <?php endif ?>
                        </div>
                        <p class="title"><?php echo esc_html($postBlock['post_title']); ?></p>
                        <p class="excerpt"><?php echo esc_html($postBlock['post_excerpt']); ?></p>
                        <?php if (isset($postBlock['post_link']) && !empty($postBlock['post_link'])): ?>
                            <a href="<?php echo esc_url($postBlock['post_link']['url']); ?>">
                            <?php echo esc_html($postBlock['post_link']['title']); ?>
                            </a>
                        <?php endif; ?>
                    </div>

                <?php endif; ?>

                <!-- Previews Block -->
                <?php if( have_rows('previews_block') ): 
                    while( have_rows('previews_block') ): the_row();
                    $showBlockPreviews = get_sub_field('show_block');
                    $previewsTitle = get_sub_field('block_title');
                    $previewsLink = get_sub_field('previews_link');
                    $recapsLink = get_sub_field('recaps_link');

                    ?>
                    <?php if( $showBlockPreviews == 'yes'): ?>
                        <div class="previews_block">
                            <p class="title"><?php echo $previewsTitle; ?></p>
                            <div class="previews_list">
                            <?php 
                                if( have_rows('vs_list') ):
                                while( have_rows('vs_list') ) : the_row();

                                    $teamA = get_sub_field('team_a');
                                    $teamB = get_sub_field('team_b');
                            ?>
                                <div class="list">
                                    <div class="first-team-name"><?php echo $teamA; ?></div>
                                    <div class="versus">vs.</div>
                                    <div class="second-team-name"><?php echo $teamB; ?></div>
                                </div>

                                <?php endwhile;
                            endif; ?>
                            </div>
                            <div class="previews_links">
                            <?php if (isset( $previewsLink) && !empty( $previewsLink)): ?>
                                <a href="<?php echo $previewsLink['url']; ?>" target="<?php echo $previewsLink['target']; ?>" class="btn"><?php echo $previewsLink['title'] ?></a>
                            </a>
                        <?php endif; ?>
                        <?php if (isset($recapsLink) && !empty($recapsLink)): ?>
                            <a href="<?php echo $recapsLink['url']; ?>" target="<?php echo $recapsLink['target']; ?>" class="btn"><?php echo $recapsLink['title'] ?></a>
                        <?php endif; ?>
                               
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php endwhile; ?>
                <?php endif; ?>

                <!-- Handicappers Block -->
                <?php if( $handicappersBlock ): ?>
                    <?php if( $handicappersBlock['show_block'] == 'yes'): ?>
                        <div class="handicappers_block">
                            <p class="title"><?php echo $handicappersBlock['block_title']; ?></p>
                            <div class="handicappers_container">
                                <div class="handicappers_wrapper">
                                    <div class="handicappers_avatar">
                                        <?php if (isset($handicappersBlock['handicapper_logo']['url']) && !empty($handicappersBlock['handicapper_logo']['url'])): ?>
                                            <img src="<?php echo $handicappersBlock['handicapper_logo']['url']; ?>" alt="<?php echo isset($handicappersBlock['handicapper_logo']['alt']) ? $handicappersBlock['handicapper_logo']['alt'] : ''; ?>">
                                        <?php endif; ?>
                                    </div>
                                    <div class="handicappers_info">
                                        <p class="title"><?php echo $handicappersBlock['title']; ?></p>
                                        <p class="sub_title"><?php echo $handicappersBlock['subtitle']; ?></p>
                                        <p class="total">
                                            <?php echo $handicappersBlock['total']; ?>
                                            <span class="picks">
                                                <?php echo $handicappersBlock['picks']; ?>
                                            </span>
                                        </p>
                                    </div>
                                </div>
                                <div class="picks_availables">
                                    <span><?php echo $handicappersBlock['picks_availables']; ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <!-- Picks Block -->
                <?php if( have_rows('picks_block') ): 
                    while( have_rows('picks_block') ): the_row();
                    $showBlockPicks = get_sub_field('show_block');
                    $source = get_sub_field('source');
                    $picksTitle = get_sub_field('block_title');
                    $picksCategory = get_sub_field('category');
                    $picksTime = get_sub_field('time');
                    $picksStatus = get_sub_field('status');
                    $picksAvailables = get_sub_field('picks_availables');
                
                    ?>

                        <?php if( $showBlockPicks == 'yes'): ?>
                            <div class="picks_block">
                                <p class="title"><?php echo $picksTitle; ?></p>
                                <div class="pick">
                                    <div class="picks_header">
                                        <div class="sport">
                                            <p><?php echo $picksCategory; ?></p>
                                        </div>
                                        <div class="date_time">
                                            <p><?php echo $picksTime; ?></p>
                                        </div>
                                        <div class="status">
                                            <p><?php echo $picksStatus; ?></p>
                                        </div>
                                    </div>
                                    <div class="picks_body">
                                        <div class="teams">
                                            <?php 
                                            $teams = 0;
                                                if( have_rows('teams') ):
                                                while( have_rows('teams') ) : the_row();
                                                    $class = ($teams == 0) ? 'team_a' : 'team_b';
                                                    $teamLogo = get_sub_field('team_logo');
                                                    $teamName = get_sub_field('team_name');
                                            ?>
                                                <div class="<?php echo $class; ?>">
                                                    <?php if (isset($teamLogo['url']) && !empty($teamLogo['url'])): ?>
                                                        <img src="<?php echo $teamLogo['url']; ?>" alt="<?php echo $teamLogo['alt']; ?>">
                                                    <?php endif; ?>
                                                    <p><?php echo $teamName; ?></p>
                                                </div>

                                                <?php if ($teams == 0): ?>
                                                    <div class="vs_logo">
                                                        <span>vs</span>
                                                    </div>
                                                <?php endif;?>

                                            <?php   
                                                $teams++;
                                                endwhile;
                                            endif; ?>     
                                        </div>
                                    </div>
                                    <div class="picks_availables">
                                        <span><?php echo $picksAvailables; ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>  
                    <?php endwhile; ?>
                <?php endif; ?>
            </div>
            <div class="si_footer">
                <?php echo $blockFooter; ?>
            </div>
        </div>
    </div>
</div>
