<?php

namespace Rdgcorp\MasterFeed;

use Rdgcorp\MasterFeed\Application\GetDirectLeagues;
use Rdgcorp\MasterFeed\Application\GetDirectSchedules;
use Rdgcorp\MasterFeed\Application\GetDirectSeasons;
use Rdgcorp\MasterFeed\Application\GetDirectSports;
use Rdgcorp\MasterFeed\Application\GetDirectTeams;
use Rdgcorp\MasterFeed\Infrastructure\MasterFeedClient;

class MasterFeed
{
    private MasterFeedClient $masterFeedClient;

    public function __construct(string $token)
    {
        $this->masterFeedClient = new MasterFeedClient($token);
    }

    public function getDirectSports(): array
    {
        $getDirectSports = new GetDirectSports($this->masterFeedClient);

        return $getDirectSports();
    }

    public function getDirectLeagues(?string $sportId = null): array
    {
        $getDirectLeagues = new GetDirectLeagues($this->masterFeedClient);

        return $getDirectLeagues($sportId);
    }

    public function getDirectTeams(?string $leagueId = null): array
    {
        $getDirectTeams = new GetDirectTeams($this->masterFeedClient);

        return $getDirectTeams($leagueId);
    }

    public function getDirectSeasons(?string $leagueId = null): array
    {
        $getDirectSeasons = new GetDirectSeasons($this->masterFeedClient);

        return $getDirectSeasons($leagueId);
    }

    public function getDirectSchedules(?string $teamId = null, ?string $seasonId = null): array
    {
        $getDirectSchedules = new GetDirectSchedules($this->masterFeedClient);

        return $getDirectSchedules($teamId, $seasonId);
    }
}
