<?php if (!empty($picks) && is_array($picks) && count($picks) > 0): ?>
    <?php $fields = $block_scores_and_odds->getFieldsValidate(); ?>
    <?php $valid_picks_count = 0; ?>
    <?php foreach ($picks as $pick): ?>
        <?php
        if (!$rdgb->helpers->validateFields($fields, $pick)) continue;
        $valid_picks_count++;

        $game_datetime = DateTime::createFromFormat('Y-m-d H:i:s', $pick['game_date']);
        $formatted_game_date = sprintf('%s EST', $game_datetime->format('M d, Y H:i'));

        $odds = $pick['opener_game_odds'][0] ?? [];

        $format_odds = function ($value) {
            return isset($value) && $value !== null ? (strpos($value, "-") === 0 ? "" : "+") . $value : "-";
        };

        $valid_extensions = ['png', 'jpg', 'jpeg', 'webp', 'gif', 'svg'];
        $is_valid_image = function ($url) use ($valid_extensions) {
            $path_info = pathinfo($url);
            return isset($path_info['extension']) && in_array(strtolower($path_info['extension']), $valid_extensions);
        };

        $pick_text = ($pick['game_picks_count'] == 1) ? "1 Pick" : "{$pick['game_picks_count']} Picks";
        $pick_text .= ($pick['game_stat'] === "Final") ? " Made" : " Available";
        ?>

        <div class="sao-wrapper">
            <div class="header">
                <p><?php echo $pick['home_team']; ?></p>
                <p>vs</p>
                <p><?php echo $pick['visitor_team']; ?></p>
            </div>
            <div class="body">
                <div class="versus">
                    <div class="team-a">
                        <?php if (!empty($pick['home_image']) && $is_valid_image($pick['home_image'])): ?>
                            <?php $home_image = $block_scores_and_odds->get_image($pick['home_image'], [
                                'image_type' => 'scores_and_odds',
                                'image_alt' => $pick['home_team'] . ' Game Odds',
                                'logo_label' => false,
                            ]); ?>
                            <img src="<?php echo $home_image['url']; ?>" alt="<?php echo $home_image['alt']; ?>">
                        <?php endif; ?>
                    </div>
                    <div class="vs">
                        <p class="state"> <?php echo $pick['game_stat']; ?> </p>
                        <p class="vs-p">vs</p>
                        <p class="date"> <?php echo $formatted_game_date; ?> </p>
                    </div>
                    <div class="team-b">
                        <?php if (!empty($pick['visitor_image']) && $is_valid_image($pick['visitor_image'])): ?>
                            <?php $visitor_image = $block_scores_and_odds->get_image($pick['visitor_image'], [
                                'image_type' => 'scores_and_odds',
                                'image_alt' => $pick['visitor_team'] . ' Game Odds',
                                'logo_label' => false,
                            ]); ?>
                            <img src="<?php echo $visitor_image['url']; ?>" alt="<?php echo $visitor_image['alt']; ?>">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="stats">
                    <div class="stat">
                        <p class="team-a"> <?php echo $pick['home_score'] ?? '-'; ?> </p>
                        <p class="name">Score</p>
                        <p class="team-b"> <?php echo $pick['visitor_score'] ?? '-'; ?> </p>
                    </div>
                    <div class="stat">
                        <p class="team-a">
                            <?php
                            $spread_home_points = $odds['spread_home_points'] ?? null;
                            $spread_home_odds = $odds['spread_home_odds'] ?? null;

                            if ($spread_home_points !== null || $spread_home_odds !== null) {
                                echo trim(($spread_home_points !== null ? $format_odds($spread_home_points) : '-') . ' ' .
                                        ($spread_home_odds !== null ? $format_odds($spread_home_odds) : '-'));
                            } else {
                                echo '-';
                            }
                            ?>
                        </p>
                        <p class="name">Spread</p>
                        <p class="team-b">
                            <?php
                            $spread_visitor_points = $odds['spread_visitor_points'] ?? null;
                            $spread_visitor_odds = $odds['spread_visitor_odds'] ?? null;

                            if ($spread_visitor_points !== null || $spread_visitor_odds !== null) {
                                echo trim(($spread_visitor_points !== null ? $format_odds($spread_visitor_points) : '-') . ' ' .
                                        ($spread_visitor_odds !== null ? $format_odds($spread_visitor_odds) : '-'));
                            } else {
                                echo '-';
                            }
                            ?>
                        </p>
                    </div>
                    <div class="stat">
                        <p class="team-a"> <?php echo !empty($odds['total_over_points']) ? 'o' . $format_odds($odds['total_over_points']) . $format_odds($odds['total_over_odds']) : '-'; ?> </p>
                        <p class="name">Total</p>
                        <p class="team-b"> <?php echo !empty($odds['total_under_points']) ? 'u' . $format_odds($odds['total_under_points']) . $format_odds($odds['total_under_odds']) : '-'; ?> </p>
                    </div>
                    <div class="stat">
                        <p class="team-a">
                            <?php echo isset($odds['money_line_home_odds']) && $odds['money_line_home_odds'] !== null 
                                ? (is_numeric($odds['money_line_home_odds']) 
                                    ? (strpos($odds['money_line_home_odds'], "-") === 0 ? "" : "+") . $odds['money_line_home_odds']
                                    : "-")
                                : "-"; ?>
                        </p>
                        <p class="name">Moneyline</p>
                        <p class="team-b">
                            <?php echo isset($odds['money_line_visitor_odds']) && $odds['money_line_visitor_odds'] !== null 
                                ? (is_numeric($odds['money_line_visitor_odds']) 
                                    ? (strpos($odds['money_line_visitor_odds'], "-") === 0 ? "" : "+") . $odds['money_line_visitor_odds']
                                    : "-")
                                : "-"; ?>
                        </p>
                    </div>
                </div>
                <div class="ctas">
                    <?php
                        $preview_url = '';
                        if (isset($pick['local_game_id']) && !empty($pick['local_game_id'])) {
                            $preview_url = get_permalink($pick['local_game_id']);
                        } elseif (is_user_logged_in() && is_array($games_previews) && isset($pick['id_preview']) 
                            && !empty($pick['id_preview']) && isset($games_previews[$pick['id_preview']]) 
                            && !empty($games_previews[$pick['id_preview']])) {
                                $preview_url = get_permalink($games_previews[$pick['id_preview']]);
                        }
                    ?>
                    <?php if (!empty($pick['game_url'])): ?>
                        <a href="<?php echo $pick['game_url']; ?>" target="_blank" class="pick">
                            <?php echo $pick_text; ?>
                        </a>
                    <?php endif; ?>
                    <?php if (!empty($preview_url)): ?>
                        <a href="<?php echo $preview_url; ?>" class="preview">
                            <?php echo __('Preview & Prediction', BLOCK_RDG_SCORES_AND_ODDS); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
    <?php if ($valid_picks_count == 0): ?>
        <div class="sao-no-data">
            <p><?php echo __('No valid data available.', BLOCK_RDG_SCORES_AND_ODDS); ?></p>
        </div>
    <?php endif; ?>
<?php else: ?>
    <div class="sao-no-data">
        <p><?php echo __('No data available at this time.', BLOCK_RDG_SCORES_AND_ODDS); ?></p>
    </div>
<?php endif; ?>