<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_BOX_LIST;
    $block_classes = [$block_name];
    $block_paragraph_custom = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $content = (!empty(get_field('content'))) ? get_field('content') : '';
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <div class="body">
            <div class="box-register">
                <div class="box-title">
                    <span>free to join</span>
                </div>
                <div class="box-body">
                    <span class="heading">
                        We give you all the tools and picks to help you win more
                    </span>

                    <div class="box-content">
                        <ul>
                            <li><i class="fal fa-check-circle"></i>Lorem ipsum dolor sit amet</li>
                            <li><i class="fal fa-check-circle"></i>Lorem ipsum dolor sit amet</li>
                            <li><i class="fal fa-check-circle"></i>Lorem ipsum dolor sit amet</li>
                            <li><i class="fal fa-check-circle"></i>Lorem ipsum dolor sit amet</li>
                        </ul>
                    </div>

                    <div class="box-footer">
                        <a href="#">win more</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
