<?php    
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    global $post;
    $block_styles = [];
    $block_classes = [];
    $review_valid = explode(',', RDG_BLOCKS_REVIEWS);
    $block_bookie_summary_sidebar = $rdgb->settings->get_block(BLOCK_RDG_BOOKIE_SUMMARY_SIDEBAR);

    if (in_array($post->post_type, $review_valid)) {
        if (!empty($block['backgroundColor'])) {
            $block_classes[] = 'has-background';
            $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
        }
    
        if (!empty($block['style']['color']['background'])) {
            $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
        }
    
        $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    
        $fields = get_fields($post->ID);
        
        $separator = (!empty($fields['separator_group'])) ? $fields['separator_group'] : null;
        $separator_style = $block_bookie_summary_sidebar->get_style($separator, 'separator');
        
        $logo_show = (!empty($fields['logo']['logo_show'])) ? $fields['logo']['logo_show'] : 'hide';
        $bookie_logo = (!empty($fields['logo']['bookie_logo'])) ? $fields['logo']['bookie_logo'] : null;
        
        $review_show = (!empty($fields['review_group']['review_show'])) ? $fields['review_group']['review_show'] : 'hide';
        $review_ranking = (!empty($fields['review_group']['ranking'])) ? $fields['review_group']['ranking'] : 0;
        $review_site = (!empty($fields['review_group']['site'])) ? $fields['review_group']['site'] : null;
        $review_since = (!empty($fields['review_group']['since'])) ? $fields['review_group']['since'] : null;
        $review_description = (!empty($fields['review_group']['description'])) ? $fields['review_group']['description'] : null;
    
        $offers_show = (!empty($fields['offers_group']['offers_show'])) ? $fields['offers_group']['offers_show'] : 'hide';
        $offers = (!empty($fields['offers_group']['offer'])) ? $fields['offers_group']['offer'] : null;
        
        $payment_show = (!empty($fields['payment_methods_group']['payment_methods_show'])) ? $fields['payment_methods_group']['payment_methods_show'] : 'hide';
        $payment_title = (!empty($fields['payment_methods_group']['title'])) ? $fields['payment_methods_group']['title'] : null;
        $payment_methods = (!empty($fields['payment_methods_group']['images'])) ? $fields['payment_methods_group']['images'] : null;
        
        $buttons_show = (!empty($fields['buttons_group']['buttons_show'])) ? $fields['buttons_group']['buttons_show'] : 'hide';
        $buttons = (!empty($fields['buttons_group']['buttons'])) ? $fields['buttons_group']['buttons'] : null;
        $items = null;
    }
?>

<?php if (in_array($post->post_type, $review_valid)): ?>
    <div class="rdg-blocks">
        <div class="<?php echo BLOCK_RDG_BOOKIE_SUMMARY_SIDEBAR; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <?php if ($logo_show == 'show' || $review_show == 'show' || $offers_show == 'show' || $payment_show == 'show' || $buttons_show == 'show'): ?>
            <div class="content <?php echo esc_attr(join(' ', $block_classes)); ?>">
                <?php if ($logo_show == 'show' && !empty($bookie_logo)): ?>
                    <div class="header">
                        <div class="logo">
                            <img src="<?php echo $bookie_logo['url']; ?>" alt="Image">
                        </div>
                        <hr style="<?php echo $separator_style; ?>">
                    </div>
                <?php endif; ?>

                <?php if ($review_show == 'show'): ?>
                    <div class="bookie">
                        <?php if (!empty($review_ranking)): ?>
                            <div class="stars <?php echo (empty($sub_title)) ? 'ml-0' : ''; ?>">
                                <?php $block_bookie_summary_sidebar->get_stars($review_ranking); ?>
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($review_site) || !empty($review_since) || !empty($review_description)): ?>
                            <div class="site">
                                <?php if (!empty($review_site)): ?>
                                    <span class="url"><?php echo $review_site; ?></span>
                                <?php endif; ?>

                                <?php if (!empty($review_since)): ?>
                                    <span class="since"><?php echo $review_since; ?></span>
                                <?php endif; ?>

                                <?php if (!empty($review_description)): ?>
                                    <span class="description"><?php echo $review_description; ?></span>
                                <?php endif; ?>

                                <?php if ($offers_show == 'show' && is_array($offers) && count($offers) > 0): ?>
                                    <?php $items = $offers; ?>
                                    <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/buttons-sidebar.php'; ?>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <?php if ($payment_show == 'show' && is_array($payment_methods) && count($payment_methods) > 0): ?>
                    <div class="methods">
                        <hr style="<?php echo $separator_style; ?>">
                        <?php if (!empty($payment_title)): ?>
                            <span class="title"><?php echo $payment_title; ?></span>
                        <?php endif; ?>
                        <div class="logos">
                            <?php foreach ($payment_methods as $method): ?>
                                <?php if (!empty($method['image']['url'])): ?>
                                    <img src="<?php echo $method['image']['url']; ?>" alt="Image">
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if ($buttons_show == 'show' && is_array($buttons) && count($buttons) > 0): ?>
                    <hr style="<?php echo $separator_style; ?>">
                    <?php $items = $buttons; ?>
                    <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/buttons-sidebar.php'; ?>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
<?php else: ?>
    <div class="rdg-blocks">
        <div class="<?php echo BLOCK_RDG_BOOKIE_SUMMARY_SIDEBAR; ?>">
            <?php if ($post->post_type != 'gp_elements'): ?>
                <div class="message danger">
                    <?php echo __('Requires to be used with a custom post type review.'); ?>
                </div>
            <?php else: ?>
                <div class="message info">
                    <?php echo __('Will be generated on page load.'); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>
