<?php
    global $rdgb;
    $logo = get_field('promote_site_logo', 'option');
    $site_name = get_field('promote_site_name', 'option');
    $offer_amount = get_field('promote_site_offer_amount', 'option');
    $offer_description = get_field('promote_site_offer_description', 'option');
    $button_text = get_field('promote_site_action_button_text', 'option');
    $age_terms = get_field('promote_site_age_terms', 'option');
    $offer_features = get_field('promote_site_offer_features', 'option');
?>
<div class="rdg-blocks">
    <div class="rdg-blocks-promote">
        <div class="header">
            <div class="promote-left">
            <?php if ($logo): ?>
                    <img class="promote-logo" src="<?php echo esc_url($logo['url']); ?>" alt="<?php echo esc_attr($logo['alt']); ?>" />
                <?php endif; ?>
                <?php if ($site_name): ?>
                    <div class="promote-name"><?php echo esc_html($site_name); ?></div>
                <?php endif; ?>
            </div>
            <div class="promote-right">
                <?php if ($offer_amount): ?>            
                    <span class="promote-offer-amount">$<?php echo esc_html($offer_amount); ?></span>
                <?php endif; ?>
            </div>
        </div>
        <div class="body">
            <div class="promote-content">
                <?php if ($offer_description): ?>
                    <p class="promote-offer-description"><?php echo nl2br(esc_html($offer_description)); ?></p>
                <?php endif; ?>

                <?php if ($button_text): ?>
                    <div class="promote-action-button">
                        <button><?php echo esc_html($button_text); ?></button>
                    </div>
                <?php endif; ?> 
            </div>
        </div>
        <?php if (!empty($offer_features) && is_array($offer_features)): ?>
            <ul class="promote-features">
                <?php foreach ($offer_features as $feature): ?>
                    <li><?php echo esc_html($feature['promote_site_feature']); ?></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
        <?php if ($age_terms): ?>
            <div class="footer">
                <span class="age_terms"><?php echo esc_html($age_terms); ?> </span><span class="terms">Terms & Conditions Apply</span>
            </div>
        <?php endif; ?>
</div>
