<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Previews_And_Predictions extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_PREVIEWS_AND_PREDICTIONS;
    private $block_folder_name = 'rdg-previews-and-predictions';
    private $block_title = 'RDG Previews and Predictions';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'previews and predictions'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_previews_and_predictions.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
		if( function_exists('acf_add_local_field_group') ):

			acf_add_local_field_group(array(
				'key' => 'group_642ec9fc03efa',
				'title' => 'Previews and Predictions',
				'fields' => array(
					array(
						'key' => 'field_642ec9ff4f582',
						'label' => 'Title',
						'name' => 'title',
						'aria-label' => '',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'maxlength' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
					),
					array(
						'key' => 'field_642ecb624f583',
						'label' => 'Vs List',
						'name' => 'vs_list',
						'aria-label' => '',
						'type' => 'repeater',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'layout' => 'table',
						'pagination' => 0,
						'min' => 0,
						'max' => 0,
						'collapsed' => '',
						'button_label' => 'Add Row',
						'rows_per_page' => 20,
						'sub_fields' => array(
							array(
								'key' => 'field_642ecb8d4f584',
								'label' => 'Team A',
								'name' => 'team_a',
								'aria-label' => '',
								'type' => 'text',
								'instructions' => '',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'maxlength' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'parent_repeater' => 'field_642ecb624f583',
							),
							array(
								'key' => 'field_642ecba34f585',
								'label' => 'Team B',
								'name' => 'team_b',
								'aria-label' => '',
								'type' => 'text',
								'instructions' => '',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'maxlength' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'parent_repeater' => 'field_642ecb624f583',
							),
						),
					),
					array(
						'key' => 'field_642ecbbb4f586',
						'label' => 'Previews Btn',
						'name' => 'previews_btn',
						'aria-label' => '',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'maxlength' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
					),
					array(
						'key' => 'field_642ecbdb4f588',
						'label' => 'Previews Link',
						'name' => 'previews_link',
						'aria-label' => '',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'maxlength' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
					),
					array(
						'key' => 'field_642ecbcd4f587',
						'label' => 'Recaps Btn',
						'name' => 'recaps_btn',
						'aria-label' => '',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'maxlength' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
					),
					array(
						'key' => 'field_642ecbe64f589',
						'label' => 'Recaps Link',
						'name' => 'recaps_link',
						'aria-label' => '',
						'type' => 'text',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'maxlength' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
					),
				),
				'location' => array(
					array(
						array(
							'param' => 'block',
							'operator' => '==',
							'value' => 'acf/rdg-previews-and-predictions',
						),
					),
				),
				'menu_order' => 0,
				'position' => 'normal',
				'style' => 'default',
				'label_placement' => 'top',
				'instruction_placement' => 'label',
				'hide_on_screen' => '',
				'active' => true,
				'description' => '',
				'show_in_rest' => 0,
			));
			
			endif;		
    }

    // public function get_style($type, $fields) {
    //     $style = [];
    
    //     if ('block' == $type) {
    //         $color = (!empty($fields['color'])) ? $fields['color'] : '#172d54';
    //         $style[] = 'background-color: '.$color;
    
    //         if (!empty($fields['image']['url'])) {
    //             $style[] = 'background-image: url('.$fields['image']['url'].')';
    //         }
    
    //         return implode('; ', $style);
    //     }
    
    //     if ('position' == $type) {
    //         if (!empty($fields['padding_top'])) {
    //             $style[] = 'padding-top: '.$fields['padding_top'].'rem';
    //         }
    
    //         if (!empty($fields['padding_left'])) {
    //             $style[] = 'padding-left: '.$fields['padding_left'].'rem';
    //         }
    
    //         if (!empty($fields['padding_right'])) {
    //             $style[] = 'padding-right: '.$fields['padding_right'].'rem';
    //         }
    
    //         return implode('; ', $style);
    //     }
    // }

    // public function get_texts($spaces, $titles, $member) {
    //     $texts = [];
    //     $min_size = (100 - $spaces['width']) / 2;
    //     $align = $spaces['position'];
    
    //     if (empty($titles)) {
    //         return;
    //     }

    //     $rdg_helpers = new Rdg_Blocks_Helpers();
        
    //     foreach($titles['texts'] as $title) {
    //         $style = $rdg_helpers->get_title_sizes($title);
    //         $style[] = (!empty($title['color'])) ? 'color: '.$title['color'] : 'color: #ffffff';
    //         $style[] = (!empty($title['weight'])) ? 'font-weight: '.$title['weight'] : 'font-weight: 400';
    //         $style[] = (!empty($title['padding'])) ? 'padding-bottom: '.$title['padding'].'rem' : 'padding-bottom: 0rem';
    
    //         if (!empty($title['shadow_color'])) {
    //             $style[] = 'text-shadow: 0px 1px 1px '.$title['shadow_color'];
    //         }
    
    //         $texts[] = '<'.$title['heading'].' style="'.implode('; ', $style).'">'.$title['title'].'</'.$title['heading'].'>';
    //         $style = [];
    //     }
        
    //     $button = $this->get_link($member);
        
    //     if ('left' == $align) {
    //         echo '<div class="position size-left" style="width: '.$spaces['width'].'%;"><div class="texts"><div class="content">'.implode('', $texts).'</div></div><div class="button">'.$button.'</div></div>';
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    
    //         return;
    //     }
    
    //     if ('center' == $align) {
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    //         echo '<div class="position size-center" style="width: '.$spaces['width'].'%;"><div class="texts"><div class="content">'.implode('', $texts).'</div></div><div class="button">'.$button.'</div></div>';
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    
    //         return;
    //     }
    
    //     if ('right' == $align) {
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    //         echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    //         echo '<div class="position size-right" style="width: '.$spaces['width'].'%;"><div class="texts"><div class="content">'.implode('', $texts).'</div></div><div class="button">'.$button.'</div></div>';
    
    //         return;
    //     }
    // }

    // private function get_link($member) {
    //     if (is_array($member['link'])) {
    //         if (!empty($member['background_color'])) {
    //             $styles[] = 'background-color: '.$member['background_color'].';';
    //         } else {
    //             $styles[] = 'background-color: #459519;';
    //         }
    
    //         if (!empty($member['title_color'])) {
    //             $styles[] = 'color: '.$member['title_color'].';';
    //         } else {
    //             $styles[] = 'color: #ffffff;';
    //         }
    
    //         if (!empty($member['shadow_color'])) {
    //             $styles[] = '--btn-box-shadow: '.$member['shadow_color'].';';
    //         } else {
    //             $styles[] = '--btn-box-shadow: #68f96e;';
    //         }
    
    //         $target = (!empty($member['link']['title'])) ? $member['link']['target'] : '_self';
    //         return '<a class="link-member" href="'.$member['link']['url'].'" target="'.$target.'" style="'.implode(' ', $styles).'">'.$member['link']['title'].'</a>';
    //     }
    
    //     return '';
    // }
}

$rdg_previews_and_predictions_class = new Rdg_Blocks_Previews_And_Predictions ();
$rdg_previews_and_predictions_class->init();

return $rdg_previews_and_predictions_class;
