<?php

namespace Rdgcorp\Blocks\TeamSchedules;

require __DIR__ . '/utils/CacheManager.php';
require __DIR__ . '/utils/MasterFeedApiConsumer.php';

use Rdgcorp\Blocks\TeamSchedules\Utils\CacheManager;
use Rdgcorp\Blocks\TeamSchedules\Utils\MasterFeedApiConsumer;

class BlockDataLoader
{
    private CacheManager $cacheManager;

    private MasterFeedApiConsumer $masterFeedApiConsumer;

    public function __construct()
    {
        $cacheFile = (wp_upload_dir()['basedir']) . '/rdg-block/cache/team_schedules.json';

        $this->cacheManager = new CacheManager($cacheFile);
        $this->masterFeedApiConsumer = new MasterFeedApiConsumer('KVbgULzIPQRXsREsbzrCFqdydvweEJUVUobxDZBsTOIzKNsNXW');
    }

    public function getSports(): array
    {
        $cacheKey = 'sports';

        $data = $this->cacheManager->retrieveCache($cacheKey);

        if ($data) {
            return $data;
        }

        $data = $this->masterFeedApiConsumer->getSports();

        $this->cacheManager->storeCache($cacheKey, $data);

        return $data;
    }

    public function getLeagues(string $sportId): array
    {
        $cacheKey = 'leagues-sport-' . $sportId;

        $data = $this->cacheManager->retrieveCache($cacheKey);

        if ($data) {
            return $data;
        }

        $data = $this->masterFeedApiConsumer->getLeagues($sportId);

        $this->cacheManager->storeCache($cacheKey, $data);

        return $data;
    }

    public function getTeams(string $leagueId): array
    {
        $cacheKey = 'teams-league-' . $leagueId;

        $data = $this->cacheManager->retrieveCache($cacheKey);

        if ($data) {
            return $data;
        }

        $data = $this->masterFeedApiConsumer->getTeams($leagueId);

        $this->cacheManager->storeCache($cacheKey, $data);

        return $data;
    }

    public function getSeasons(string $leagueId): array
    {
        $cacheKey = 'seasons-league-' . $leagueId;

        $data = $this->cacheManager->retrieveCache($cacheKey);

        if ($data) {
            return $data;
        }

        $data = $this->masterFeedApiConsumer->getSeasons($leagueId);

        $this->cacheManager->storeCache($cacheKey, $data);

        return $data;
    }

    public function getSchedules(string $teamId, string $seasonId): array
    {
        $cacheKey = 'schedules-team-' . $teamId . '-season-' . $seasonId;

        $data = $this->cacheManager->retrieveCache($cacheKey);

        if ($data) {
            return $data;
        }

        $data = $this->masterFeedApiConsumer->getSchedules($teamId, $seasonId);

        $this->cacheManager->storeCache($cacheKey, $data);

        return $data;
    }
}
