<?php
foreach ($memberships as $membership) {
    $descriptionWithoutNbsp = str_replace('&nbsp;', '', $membership['description']);

    $apiDataArray[] = array(
        'name' => $membership['name'],
        'description' => $descriptionWithoutNbsp,
        'subscribers_plan' => array(
            'name' => $membership['subscribers_plan']['name'],
            'handicapper_amount' => $membership['subscribers_plan']['handicapper_amount'],
            'duration' => $membership['subscribers_plan']['duration'],
        ),
        'num_picks' => $membership['num_picks'],
        'yesterday_winners' => $membership['yesterday_winners'],
    );
}
?>

<!-- Premium PackageAPI Group -->
<?php if( $premiumPackageAPI['show_block'] == true ): ?>
    <div class="mi_container">
        <div class="mi_header">
        <?php if (isset($premiumPackageAPI['icon_img_api']) && is_array($premiumPackageAPI['icon_img_api']) && !empty($premiumPackageAPI['icon_img_api'])): ?>
            <div class="mi_icon">
                <img src="<?php echo esc_url($premiumPackageAPI['icon_img_api']['url']); ?>" alt="<?php echo esc_attr($premiumPackageAPI['icon_img_api']['alt']); ?>">
            </div>
        <?php endif; ?>
            <p class="title"><?php echo $apiDataArray[2]['name']; ?></p>
        </div>
        <div class="mi_body">
        <?php if ($premiumPackageAPI['body_content'] == "description") {
                    echo $apiDataArray[2]['description'];
                } else {
                    if ($apiDataArray[2]['yesterday_winners'] == 1) {
                        echo $apiDataArray[2]['yesterday_winners'] . " Winner yesterday";
                    } else {
                        echo $apiDataArray[2]['yesterday_winners'] . " Winners yesterday";
                    }
                }
            ?>
        </div>
        <div class="mi_footer">
            <div class="mi_picks"> 
                <?php echo $apiDataArray[2]['num_picks'] . ' PICKS AVAILABLES'; ?>
            </div>
        </div>
        <?php if (isset($premiumPackageAPI['group_details']['url']) && !empty($premiumPackageAPI['group_details']['url'])) { ?>
        <div class="group_details">
            <a href="<?php echo $premiumPackageAPI['group_details']['url']; ?>" <?php if ($premiumPackageAPI['group_details']['target']) { ?> target="<?php echo $premiumPackageAPI['group_details']['target'];?>" <?php }?> ><?php echo $premiumPackageAPI['group_details']['title']; ?></a>
        </div>
        <?php  } ?>
    </div>
<?php endif; ?>

<!-- Classic Group -->
<?php if( $classicPackageAPI['show_block'] == true ): ?>
    <div class="mi_container">
        <div class="mi_header">
            <?php if (isset($classicPackageAPI['icon_img_api']) && is_array($classicPackageAPI['icon_img_api']) && !empty($classicPackageAPI['icon_img_api'])): ?>
            <div class="mi_icon">
                <img src="<?php echo esc_url($classicPackageAPI['icon_img_api']['url']); ?>" alt="<?php echo esc_attr($classicPackageAPI['icon_img_api']['alt']); ?>">
            </div>
            <?php endif; ?>
            <p class="title"><?php echo $apiDataArray[1]['name']; ?></p>
        </div>
        <div class="mi_body">
            <?php if ($classicPackageAPI['body_content'] == "description") {
                    echo $apiDataArray[1]['description'];
                    echo "<style> 
                        .mi_body {
                            min-height: 199px;
                        }
                    </style>";
                } else {
                    if ($apiDataArray[1]['yesterday_winners'] == 1) {
                        echo $apiDataArray[1]['yesterday_winners'] . " Winner yesterday";
                    } else {
                        echo $apiDataArray[1]['yesterday_winners'] . " Winners yesterday";
                    }
                }
            ?>
        </div>
        <div class="mi_footer">
            <div class="mi_picks"> 
                <?php echo $apiDataArray[1]['num_picks'] . ' PICKS AVAILABLES'; ?>
            </div>
        </div>
        <?php if (isset($classicPackageAPI['group_details']['url']) && !empty($classicPackageAPI['group_details']['url'])) { ?>
        <div class="group_details">
            <a href="<?php echo $classicPackageAPI['group_details']['url']; ?>" <?php if ($classicPackageAPI['group_details']['target']) { ?> target="<?php echo $classicPackageAPI['group_details']['target'];?>" <?php }?> ><?php echo $classicPackageAPI['group_details']['title']; ?></a>
        </div>
        <?php  } ?>
    </div>
<?php endif; ?>

<!-- Starter Plus Group -->
<?php if( $starterPlusPackageAPI['show_block'] == true ): ?>
    <div class="mi_container">
        <div class="mi_header">
        <?php if (isset($starterPlusPackageAPI['icon_img_api']) && is_array($starterPlusPackageAPI['icon_img_api']) && !empty($starterPlusPackageAPI['icon_img_api'])): ?>
            <div class="mi_icon">
                <img src="<?php echo esc_url($starterPlusPackageAPI['icon_img_api']['url']); ?>" alt="<?php echo esc_attr($starterPlusPackageAPI['icon_img_api']['alt']); ?>">
            </div>
            <?php endif; ?>
            <p class="title"><?php echo $apiDataArray[4]['name']; ?></p>
        </div>
        <div class="mi_body">
            <?php if ($starterPlusPackageAPI['body_content'] == "description") {
                    echo $apiDataArray[4]['description'];
                } else {
                    if ($apiDataArray[4]['yesterday_winners'] == 1) {
                        echo $apiDataArray[4]['yesterday_winners'] . " Winner yesterday";
                    } else {
                        echo $apiDataArray[4]['yesterday_winners'] . " Winners yesterday";
                    }
                }
            ?>
        </div>
        <div class="mi_footer">
            <div class="mi_picks"> 
                <?php echo $apiDataArray[4]['num_picks'] . ' PICKS AVAILABLES'; ?>
            </div>
        </div>
        <?php if (isset($starterPlusPackageAPI['group_details']['url']) && !empty($starterPlusPackageAPI['group_details']['url'])) { ?>
        <div class="group_details">
            <a href="<?php echo $starterPlusPackageAPI['group_details']['url']; ?>" <?php if ($starterPlusPackageAPI['group_details']['target']) { ?> target="<?php echo $starterPlusPackageAPI['group_details']['target'];?>" <?php }?>><?php echo $starterPlusPackageAPI['group_details']['title']; ?></a>
        </div>
        <?php  } ?>
    </div>
<?php endif; ?>

<!-- Starter PackageAPI Group -->
<?php if( $starterPackageAPI['show_block'] == true ): ?>
    <div class="mi_container">
        <div class="mi_header">
        <?php if (isset($starterPackageAPI['icon_img_api']) && is_array($starterPackageAPI['icon_img_api']) && !empty($starterPackageAPI['icon_img_api'])): ?>
            <div class="mi_icon">
                <img src="<?php echo esc_url($starterPackageAPI['icon_img_api']['url']); ?>" alt="<?php echo esc_attr($starterPackageAPI['icon_img_api']['alt']); ?>">
            </div>
            <?php endif; ?>
            <p class="title"><?php echo $apiDataArray[0]['name']; ?></p>
        </div>
        <div class="mi_body">
        <?php if ($starterPackageAPI['body_content'] == "description") {
                    echo $apiDataArray[0]['description'];
                } else {
                    if ($apiDataArray[0]['yesterday_winners'] == 1) {
                        echo $apiDataArray[0]['yesterday_winners'] . " Winner yesterday";
                    } else {
                        echo $apiDataArray[0]['yesterday_winners'] . " Winners yesterday";
                    }
                }
            ?>
        </div>
        <div class="mi_footer">
            <div class="mi_picks"> 
                <?php echo $apiDataArray[0]['num_picks'] . ' PICKS AVAILABLES'; ?>
            </div>
        </div>
        <?php if (isset($starterPackageAPI['group_details']['url']) && !empty($starterPackageAPI['group_details']['url'])) { ?>
        <div class="group_details">
            <a href="<?php echo $starterPackageAPI['group_details']['url']; ?>" <?php if ($starterPackageAPI['group_details']['target']) { ?> target="<?php echo $starterPackageAPI['group_details']['target'];?>" <?php }?>><?php echo $starterPackageAPI['group_details']['title']; ?></a>
        </div>
        <?php  } ?>
    </div>
<?php endif; ?>