<?php foreach($picks as $pick):?>
    <div class="pick">
        <div class="pick-header">
            <div class="content">
                <div class="sport"><span><?php echo $pick['category']; ?></span></div>
                <div class="date-time"><span><?php echo $pick['time']; ?></span></div>
                <div class="status"><span><?php echo $pick['status']; ?></span></div>
            </div>
        </div>
        <div class="pick-body">
            <?php if (is_array($pick['teams']) && count($pick['teams']) > 0 && count($pick['teams']) == 2): ?>
                <div class="teams">
                    <?php $teams = 0; ?>
                    <?php foreach($pick['teams'] as $team): ?>
                        <?php $class_team = ($teams == 0) ? 'team-a' : 'team-b'; ?>

                        <div class="team <?php echo $class_team; ?>">
                            <div class="team-logo">
                                <?php if (isset($team['logo']['url']) && $team['logo']['url'] != ''): ?>
                                    <img src="<?php echo $team['logo']['url']; ?>" alt="">
                                <?php endif; ?>
                            </div>
                            <div class="team-name"><span><?php echo $team['name']; ?></span></div>
                        </div>

                        <?php if ($teams == 0): ?>
                            <div class="team team-vs">
                                <div class="vs-logo"><span>vs</span></div>

                                <?php if ($custom_link_show == 'show'): ?>
                                    <?php
                                        $url = '';
                                        $target = '_self';

                                        if (is_array($custom_link)) {
                                            if (isset($custom_link['url'])) {
                                                $url = $custom_link['url'];
                                            }

                                            if (isset($custom_link['target']) && !empty($custom_link['target'])) {
                                                $target = $custom_link['target'];
                                            }
                                        }
                                    ?>
                                    <a href="<?php echo $url; ?>" target="<?php echo $target; ?>">
                                <?php endif; ?>
                                    <div class="vs-name">
                                        <span><?php echo $pick['vs']; ?></span>
                                    </div>
                                <?php if ($custom_link_show == 'show'): ?>
                                    </a>
                                <?php endif; ?>


                                    </div>
                                <?php endif;?>

                        <?php $teams++; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; ?>