<?php

if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Top_Sites extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_TOP_SITES;
    private $block_folder_name = 'rdg-top-sites';
    private $block_title = 'RDG Top Sites';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'top', 'sites'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init()
    {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . '/blocks/' . $this->block_folder_name . '/template.php',
                'enqueue_style' => $rdg_helpers->webpack('rdg_top_sites.css'),
            ]);
        }
    }

    public function register_fields()
    {
        if (function_exists('acf_add_local_field_group')) {
            $json = file_get_contents(__DIR__ . '/fields/block_fields.json');

            acf_add_local_field_group(json_decode($json, true));
        }
    }

    public function get_data()
    {
        return get_field('block');
    }
}

$rdg_top_sites_class = new Rdg_Blocks_Top_Sites();
$rdg_top_sites_class->init();

return $rdg_top_sites_class;
