<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

class Sb_Sportsfeed_Helpers {
    public CONST CRON_VAR_URL = 'URL';
    public CONST CRON_VAR_ERROR = 'ERROR';
    public CONST CRON_VAR_MESSAGE = 'MESSAGE';
    public CONST CRON_VAR_NULL = 'NULL';
    public CONST CRON_VAR_RESOURCES = 'RESOURCES';
    public CONST CRON_VAR_HTTP_CODE = 'HTTP_CODE';

	public function is_install_shortpixel() {
        if (in_array('shortpixel-image-optimiser/wp-shortpixel.php', apply_filters('active_plugins', get_option('active_plugins')))) {
            return true;
        }
        
        return false;
    }

	public function get_key_shortpixel() {
        return get_option('wp-short-pixel-apiKey');
    }

    public function get_request_shortpixel() {
        return 'https://api.shortpixel.com/v2/reducer.php';
    }
    
    public function is_active_shortpixel() {
        $short_pixel = (get_field('short_pixel_active', 'option') !== null)
            ? get_field('short_pixel_active', 'option')
            : 'none';
        
        return ($short_pixel == 'active') ? true : false;
    }

    public function is_install_cron_manager() {
        if (in_array('advanced-cron-manager/advanced-cron-manager.php', apply_filters('active_plugins', get_option('active_plugins')))) {
            return true;
        }
        
        return false;
    }

    public function get_cron_log($type, $data) {
        if ($type == self::CRON_VAR_URL) {
            return sprintf('[URL:: %s]', $data);
        }

        if ($type == self::CRON_VAR_ERROR) {
            return sprintf('[ERROR:: %s]', $data);
        }

        if ($type == self::CRON_VAR_MESSAGE) {
            return sprintf('[MESSAGE:: %s]', $data);
        }

        if ($type == self::CRON_VAR_NULL) {
            return sprintf('[NULL:: %s]', $data);
        }

        if ($type == self::CRON_VAR_HTTP_CODE) {
            return sprintf('[HTTP_CODE:: %s]', $data);
        }

        if ($type == self::CRON_VAR_RESOURCES) {
            return sprintf('[RESOURCES:: %s succesfully inserted posts]', $data);
        }

        return '';
    }

    public function get_cron_vars($string) {
        preg_match_all('/\[(URL|ERROR|MESSAGE|RESOURCES|HTTP_CODE|NULL)+::+.+\]/', $string, $vars);

        if (is_array($vars) && isset($vars[0]) && count($vars[0]) > 0) {
            return implode(' ', $vars[0]);
        }

        return null;
    }
}
