<?php 
    $original_cron = get_option( 'sb_feeds_cron_time');
    // Get the input data from the form submission
    $txt_posts_username        = isset($_POST['txt_posts_username'])? $_POST['txt_posts_username'] : null;
    $txt_allowed_entry_types   = isset($_POST['txt_allowed_entry_types'])? $_POST['txt_allowed_entry_types'] : null;
    $txt_allowed_entry_sports  = isset($_POST['txt_allowed_entry_sports'])? $_POST['txt_allowed_entry_sports'] : null;
    $txt_allowed_entry_leagues = isset($_POST['txt_allowed_entry_leagues'])? $_POST['txt_allowed_entry_leagues'] : null;
    $btn_reset_last_run        = isset($_POST['btn_reset_last_run'])? $_POST['btn_reset_last_run'] : null;
    $select_sbf_cron_time      = isset($_POST['sbf_cron_time'])? $_POST['sbf_cron_time'] : null;

    if((!empty($select_sbf_cron_time)) && ($original_cron != $select_sbf_cron_time)){

        wp_clear_scheduled_hook('sbf_feeds_cron_event');
        wp_schedule_event(time(), $select_sbf_cron_time, 'sbf_feeds_cron_event');

    }

    // Validate the input data
    if ( $txt_allowed_entry_types !== null || $txt_allowed_entry_sports !== null || $txt_allowed_entry_leagues !== null || $txt_posts_username !== null || $select_sbf_cron_time !== null) {
        // Save the settings to the database
        update_option( 'sb_feeds_allowed_entry_types', $txt_allowed_entry_types );
        update_option( 'sb_feeds_allowed_entry_sports', $txt_allowed_entry_sports );
        update_option( 'sb_feeds_allowed_entry_leagues', $txt_allowed_entry_leagues );
        update_option( 'sb_feeds_author', $txt_posts_username );
        update_option( 'sb_feeds_cron_time', $select_sbf_cron_time );
    }    

    //delete the last run counter for debug purposed
    if( $btn_reset_last_run != null ){
        if( $btn_reset_last_run == 'reset'){
            delete_option( 'sb_feeds_last_run' );
        }
    }
?>
<h1>SB SportsFeed Settings</h1>
<hr/>

<form action="<?php echo get_admin_url() .  'admin.php?page=sb-sportsfeed-settings' ; ?>" method="post">
    <table class="sb-sportsfeed-table">
        <tbody>
            <tr>
                <td><b>Last Feed Pull Datetime:</b></td>
                <td><?php echo get_option( 'sb_feeds_last_run', 'never' ); ?></td>
            </tr>
            <tr>
                <td>Cronjob run time:<br>
                    <b>Default: Hourly</b>
                </td>
                <td>
                    <select name="sbf_cron_time">
                <?php
                $schedules = wp_get_schedules();
                foreach ( $schedules as $schedule => $data ) {
                    if($schedule == get_option( 'sb_feeds_cron_time')){
                        echo '<option value="' . $schedule . '" selected="selected">' . $data['display'] . '</option>';
                    }else{
                        echo '<option value="' . $schedule . '">' . $data['display'] . '</option>';
                    }
                }
                ?>
                </select>
                </td>
            </tr>
            <tr>
                <td>Assign the posts to the following username:<br>
                    <b>Default: User with the ID 1</b>
                </td>
                <td><input type="text" name="txt_posts_username" id="txt_posts_username"  placeholder="ex: Admin" value="<?php echo get_option( 'sb_feeds_author' ); ?>" /></td>
            </tr>
            <tr>
                <td>Name of entry type names to process (sepparated by comma):<br>
                    <b>(Default: news)</b>
                </td>
                <td><input type="text" name="txt_allowed_entry_types" id="txt_allowed_entry_types"  placeholder="ex: news,preview, etc" value="<?php echo get_option( 'sb_feeds_allowed_entry_types' ); ?>" /></td>
            </tr>
            <tr>
                <td>IDs of sports to process (sepparated by comma):<br>
                    <b>(Default: 244)</b>
                </td>
                <td><input type="text" name="txt_allowed_entry_sports" id="txt_allowed_entry_types" placeholder="ex: 201,404,etc" value="<?php echo get_option( 'sb_feeds_allowed_entry_sports' ); ?>"/></td>
            </tr>
            <tr>
                <td>IDs of leagues to process (sepparated by comma):<br>
                    <b>(Default: 6064)</b>
                </td>
                <td><input type="text" name="txt_allowed_entry_leagues" id="txt_allowed_entry_types" placeholder="ex: 6046,6052" value="<?php echo get_option( 'sb_feeds_allowed_entry_leagues' ); ?>" /></td>
            </tr>
            <tr>
                <td colspan="2">
                    <button class="button button-primary" type="submit">Save Settings</button>
                </td>
        </tbody>
    </table>
</form>

<form action="<?php echo get_admin_url() .  'admin.php?page=sb-sportsfeed-settings' ; ?>" method="post">
    <button name="btn_reset_last_run" value="reset" class="button button-secondary" type="submit">Reset Last Run Date</button>
</form>

<style>
    .sb-sportsfeed-table td {
        padding: 15px 5px;
    }

    .sb-sportsfeed-table td input[type=text]{
        min-width:500px;
    }
</style>