<?php
/**
 * SB SportsFeed
 *
 * @package       SBSPORTSFE
 * @author        IT
 * @version       1.0.6
 *
 * @wordpress-plugin
 * Plugin Name:   SB SportsFeed
 * Plugin URI:    https://www.sportshub.com
 * Description:   Feed integration for wordpress
 * Version:       1.0.6
 * Author:        IT
 * Author URI:    https://www.sportshub.com
 * Text Domain:   sb-sportsfeed
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * HELPER COMMENT START
 * 
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 * 
 * The comment above contains all information about the plugin 
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 * 
 * The function SBSPORTSFE() is the main function that you will be able to 
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 * 
 * HELPER COMMENT END
 */

// Plugin name
define( 'SBSPORTSFE_NAME',			'SB SportsFeed' );

// Plugin version
define( 'SBSPORTSFE_VERSION',		'1.0.6' );

// Plugin Root File
define( 'SBSPORTSFE_PLUGIN_FILE',	__FILE__ );

// Plugin base
define( 'SBSPORTSFE_PLUGIN_BASE',	plugin_basename( SBSPORTSFE_PLUGIN_FILE ) );

// Plugin Folder Path
define( 'SBSPORTSFE_PLUGIN_DIR',	plugin_dir_path( SBSPORTSFE_PLUGIN_FILE ) );

// Plugin Folder URL
define( 'SBSPORTSFE_PLUGIN_URL',	plugin_dir_url( SBSPORTSFE_PLUGIN_FILE ) );

//Plugin default log folder
$plugin_upload_dir = wp_upload_dir()['basedir'] . '/' . str_replace(' ', '_', SBSPORTSFE_NAME);
define( 'SBSPORTSFE_PLUGIN_LOG_DIR', $plugin_upload_dir );

//Plugin default feed endpoint
define( 'SBSPORTSFE_PLUGIN_DEAULT_ENDPOINT_URL', 'http://masterfeed.shnadmin.com/feed/export/news?key=KVbgULzIPQRXsREsbzrCFqdydvweEJUVUobxDZBsTOIzKNsNXW' );

/**
 * Load the main class for the core functionality
 */
require_once SBSPORTSFE_PLUGIN_DIR . 'core/class-sb-sportsfeed.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  IT
 * @since   1.0.0
 * @return  object|Sb_Sportsfeed
 */
function SBSPORTSFE() {
	return Sb_Sportsfeed::instance();
}

SBSPORTSFE();
