<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * HELPER COMMENT START
 * 
 * This is the main class that is responsible for registering
 * the core functions, including the files and setting up all features. 
 * 
 * To add a new class, here's what you need to do: 
 * 1. Add your new class within the following folder: core/includes/classes
 * 2. Create a new variable you want to assign the class to (as e.g. public $helpers)
 * 3. Assign the class within the instance() function ( as e.g. self::$instance->helpers = new Sb_Sportsfeed_Helpers();)
 * 4. Register the class you added to core/includes/classes within the includes() function
 * 
 * HELPER COMMENT END
 */

if ( ! class_exists( 'Sb_Sportsfeed' ) ) :

	/**
	 * Main Sb_Sportsfeed Class.
	 *
	 * @package		SBSPORTSFE
	 * @subpackage	Classes/Sb_Sportsfeed
	 * @since		1.0.0
	 * @author		IT
	 */
	final class Sb_Sportsfeed {

		/**
		 * The real instance
		 *
		 * @access	private
		 * @since	1.0.0
		 * @var		object|Sb_Sportsfeed
		 */
		private static $instance;

		/**
		 * SBSPORTSFE helpers object.
		 *
		 * @access	public
		 * @since	1.0.0
		 * @var		object|Sb_Sportsfeed_Helpers
		 */
		public $helpers;

		/**
		 * SBSPORTSFE settings object.
		 *
		 * @access	public
		 * @since	1.0.0
		 * @var		object|Sb_Sportsfeed_Settings
		 */
		public $settings;

		/**
		 * Throw error on object clone.
		 *
		 * Cloning instances of the class is forbidden.
		 *
		 * @access	public
		 * @since	1.0.0
		 * @return	void
		 */
		public function __clone() {
			_doing_it_wrong( __FUNCTION__, __( 'You are not allowed to clone this class.', 'sb-sportsfeed' ), '1.0.0' );
		}

		/**
		 * Disable unserializing of the class.
		 *
		 * @access	public
		 * @since	1.0.0
		 * @return	void
		 */
		public function __wakeup() {
			_doing_it_wrong( __FUNCTION__, __( 'You are not allowed to unserialize this class.', 'sb-sportsfeed' ), '1.0.0' );
		}

		/**
		 * Main Sb_Sportsfeed Instance.
		 *
		 * Insures that only one instance of Sb_Sportsfeed exists in memory at any one
		 * time. Also prevents needing to define globals all over the place.
		 *
		 * @access		public
		 * @since		1.0.0
		 * @static
		 * @return		object|Sb_Sportsfeed	The one true Sb_Sportsfeed
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Sb_Sportsfeed ) ) {
				self::$instance					= new Sb_Sportsfeed;
				self::$instance->base_hooks();
				self::$instance->includes();
				self::$instance->helpers		= new Sb_Sportsfeed_Helpers();
				self::$instance->settings		= new Sb_Sportsfeed_Settings();

				//Fire the plugin logic
				new Sb_Sportsfeed_Run();

				/**
				 * Fire a custom action to allow dependencies
				 * after the successful plugin setup
				 */
				do_action( 'SBSPORTSFE/plugin_loaded' );
			}

			return self::$instance;
		}

		/**
		 * Include required files.
		 *
		 * @access  private
		 * @since   1.0.0
		 * @return  void
		 */
		private function includes() {
			require_once SBSPORTSFE_PLUGIN_DIR . 'core/includes/classes/class-sb-sportsfeed-helpers.php';
			require_once SBSPORTSFE_PLUGIN_DIR . 'core/includes/classes/class-sb-sportsfeed-settings.php';
            require_once SBSPORTSFE_PLUGIN_DIR . 'core/includes/classes/class-sb-openai-post-optimizer.php';
			if ( defined( 'WP_CLI' ) && WP_CLI ){
				require_once SBSPORTSFE_PLUGIN_DIR . 'core/includes/classes/class-sb-sportsfeed-cli.php';
			}

			require_once SBSPORTSFE_PLUGIN_DIR . 'core/includes/classes/class-sb-sportsfeed-run.php';
		}

		/**
		 * Add base hooks for the core functionality
		 *
		 * @access  private
		 * @since   1.0.0
		 * @return  void
		 */
		private function base_hooks() {
			add_action( 'plugins_loaded', array( self::$instance, 'load_textdomain' ) );
		}

		/**
		 * Loads the plugin language files.
		 *
		 * @access  public
		 * @since   1.0.0
		 * @return  void
		 */
		public function load_textdomain() {
			load_plugin_textdomain( 'sb-sportsfeed', FALSE, dirname( plugin_basename( SBSPORTSFE_PLUGIN_FILE ) ) . '/languages/' );
		}

	}

endif; // End if class_exists check.