<?php

namespace Rdgcorp\OpenAI\Application;

use Rdgcorp\OpenAI\Domain\Constants\OpenAIModels;
use Rdgcorp\OpenAI\Domain\OpenAICompletions;
use Rdgcorp\OpenAI\Infrastructure\OpenAIClient;

class GeneratePostTitle
{
    private OpenAIClient $openAiClient;

    public function __construct(OpenAIClient $openAiClient)
    {
        $this->openAiClient = $openAiClient;
    }

    public function __invoke($content): string
    {
        $openAICompletions = (new OpenAICompletions(OpenAIModels::GPT4))
            ->addSystemMessage('You are helpful copywriter')
            ->addUserMessage('Generate an SEO friendly title of no more than 50 characters for the following content')
            ->addUserMessage($content);

        $responseData = $this->openAiClient->chatCompletion($openAICompletions);

        return $responseData['choices'][0]['message']['content'];
    }
}
