<?php

namespace Rdgcorp\OpenAI\Domain;

use Rdgcorp\OpenAI\Domain\Constants\OpenAIModels;

class OpenAICompletions implements OpenAICompletionsInterface
{
    private string $model;
    private array $messages = [];

    public function __construct(string $model)
    {
        if (!OpenAIModels::isDefined($model)) {
            throw new \Exception('The OpenAI model is incorrect or not supported.');
        }

        $this->model = $model;
    }

    public function getRequestBody(): string
    {
        $messagesArray = $this->messages;

        foreach ($messagesArray as $key => $message) {
            if ($messagesArray[$key]['content'] instanceof OpenAIMessageContent) {
                $messagesArray[$key]['content'] = $messagesArray[$key]['content']->getContent();
            }
        }

        return json_encode([
            'model' => $this->model,
            'messages' => $messagesArray,
        ]);
    }

    public function getModel(): string
    {
        return $this->model;
    }

    public function getMessages(): array
    {
        return $this->messages;
    }

    public function addSystemMessage(string|OpenAIMessageContent $content): self
    {
        $this->messages[] = [
            'role' => 'system',
            'content' => $content,
        ];

        return $this;
    }

    public function addUserMessage(string|OpenAIMessageContent $content): self
    {
        $this->messages[] = [
            'role' => 'user',
            'content' => $content,
        ];

        return $this;
    }

    public function addAssistantMessage(string|OpenAIMessageContent $content): self
    {
        $this->messages[] = [
            'role' => 'assistant',
            'content' => $content,
        ];

        return $this;
    }

    public function clearMessage(int $index): self
    {
        if (isset($this->messages[$index])) {
            unset($this->messages[$index]);
        }

        return $this;
    }

    public function clearAllMessages(): self
    {
        $this->messages = [];

        return $this;
    }
}
