<?php 
    global $shgr;
    $shgr = (!empty($shgr)) ? $shgr : Sportshub_Games_Recaps::instance();

    $block_styles = [];
    $block_classes = [BLOCK_SHGR_GAME_LINKS];
    $block_game = $shgr->settings->get_block(BLOCK_SHGR_GAME_LINKS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $shgr->helpers->get_blocks_spaces(get_fields());
?>
<?php if (empty(get_option('shgr_source')) || get_option('shgr_source') == 'members'): ?>
    <div class="game-link-sticky hide"></div>
    <div class="shgr-blocks">
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="container content grid-container">
                <div id="game-link-sticky-origin" class="links-body">
                    <div class="primary">
                        <span>ON THIS PAGE</span>
                    </div>
                    <div class="default">
                        <div class="link">
                            <a href="#block-game-links-preview">
                                <img src="<?php echo SHGAMESR_PLUGIN_URL.'blocks/shgr-game-links/assets/img/ico-5.png'; ?>" alt="">
                                Preview
                            </a>
                        </div>
                        <div class="link">
                            <a href="#block-game-links-top-handicapper">
                                <img src="<?php echo SHGAMESR_PLUGIN_URL.'blocks/shgr-game-links/assets/img/ico-4.png'; ?>" alt="">
                                Top Handicapper
                            </a>
                        </div>
                        <div class="link">
                            <a href="#block-game-links-picks">
                                <img src="<?php echo SHGAMESR_PLUGIN_URL.'blocks/shgr-game-links/assets/img/ico-3.png'; ?>" alt="">
                                Picks
                            </a>
                        </div>
                        <div class="link">
                            <a href="#block-game-links-odds">
                                <img src="<?php echo SHGAMESR_PLUGIN_URL.'blocks/shgr-game-links/assets/img/ico-2.png'; ?>" alt="">
                                Odds
                            </a>
                        </div>
                        <div class="link">
                            <a href="#block-game-links-last-recap">
                                <img src="<?php echo SHGAMESR_PLUGIN_URL.'blocks/shgr-game-links/assets/img/ico-1.png'; ?>" alt="">
                                Last Recap
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>