<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shgr_Blocks_Game extends Shgr_Blocks_Base
{
    protected $block_name = BLOCK_SHGR_GAME;
    private $block_folder_name = BLOCK_SHGR_GAME;
    private $block_title = 'SHGR Game';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shgr', 'custom', 'game'];
    private $block_mode = 'preview';
    private $block_category = SHGAMESR_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shgr_helpers = new Sportshub_Games_Recaps_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHGAMESR_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shgr_helpers->webpack('shgr_game.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function get_team_city($team) {
        $city_team = explode(' ', $team);

        if (!is_array($city_team)) {
            return ['City Name', 'Team Name'];
        }

        if (is_array($city_team) && count($city_team) == 1) {
            return ['City Name', $city_team];
        }

        if (is_array($city_team) && count($city_team) == 2) {
            return [$city_team[0], $city_team[1]];
        }

        $city = $city_team[0];
        unset($city_team[0]);
        $team = implode(' ',$city_team);

        return [$city, $team];
    }

    public function get_block_fields($post, $shgr) {
        $example_fields = [
            'shgr_sport_id' => '1',
            'shgr_category' => '1',
            'shgr_game_date' => '2023-09-15 10:25:00',
            'shgr_home_team' => 'Kansas City Chiefs',
            'shgr_home_score' => '21',
            'shgr_home_local_url' => SHGAMESR_PLUGIN_URL.'blocks/shgr-game/assets/img/chiefs.png',
            'shgr_current_money_line_home_odds' => '-288',
            'shgr_visitor_team' => 'Detroit Lions',
            'shgr_visitor_score' => '3',
            'shgr_visitor_local_url' => SHGAMESR_PLUGIN_URL.'blocks/shgr-game/assets/img/lions.png',
            'shgr_current_money_line_visitor_odds' => '+236',
        ];

        $fields_validate = [
            'shgr_category' => 'nullable'
        ];

        #TODO: En espera de la inclusión en el API del campo city
        $tem_home = $this->get_team_city($example_fields['shgr_home_team']);
        $example_fields['shgr_home_city'] = $tem_home[0];
        $example_fields['shgr_home_team'] = $tem_home[1];

        $tem_visitor = $this->get_team_city($example_fields['shgr_visitor_team']);
        $example_fields['shgr_visitor_city'] = $tem_visitor[0];
        $example_fields['shgr_visitor_team'] = $tem_visitor[1];

        $sports_categories = $shgr->helpers->get_sporst_categories_titles(true);
        
        if ($post->post_type == 'gp_elements') {
            if (is_array($sports_categories) && count($sports_categories) > 0) {
                $title = $sports_categories[$example_fields['shgr_sport_id']];
            } else {
                $title = null;
            }

            return array_merge($example_fields, [
                'type' => 'example',
                'title' => $title
            ]);
        }

        $validate = true;
        $custom_fields = [];

        foreach ($example_fields as $key => $value) {
            $custom_fields[$key] = get_field($key, $post->ID);
        }

        #TODO: En espera de la inclusión en el API del campo city
        $tem_home = $this->get_team_city($custom_fields['shgr_home_team']);
        $custom_fields['shgr_home_city'] = $tem_home[0];
        $custom_fields['shgr_home_team'] = $tem_home[1];

        $tem_visitor = $this->get_team_city($custom_fields['shgr_visitor_team']);
        $custom_fields['shgr_visitor_city'] = $tem_visitor[0];
        $custom_fields['shgr_visitor_team'] = $tem_visitor[1];

        $invalid_fields = [];

        foreach ($example_fields as $key => $value) {
            if (!isset($custom_fields[$key]) || empty($custom_fields[$key])) {
                if (!isset($fields_validate[$key]) || (isset($fields_validate[$key]) && $fields_validate[$key] != 'nullable')) {
                    $validate = false;
                    $invalid_fields[$key] = $custom_fields[$key];
                }
            }
        }

        if (!$validate) {
            return array_merge($example_fields, [
                'type' => 'Invalid field validation',
                'example' => $example_fields,
                'invalid_fields' => $invalid_fields,
            ]);
        }

        $sport_category_index = $custom_fields['shgr_sport_id'];
        if (isset($custom_fields['shgr_category']) && !empty($custom_fields['shgr_category'])) {
            $sport_category_index = $custom_fields['shgr_sport_id'].'-'.$custom_fields['shgr_category'];
        }

        if (is_array($sports_categories) && count($sports_categories) > 0) {
            $custom_fields['title'] = (!empty($sports_categories[$sport_category_index]))
                ? $sports_categories[$sport_category_index]
                : $sports_categories[$custom_fields['shgr_sport_id']];
        } else {
            $custom_fields['title'] = null;
        }

        return array_merge($custom_fields, ['type' => '']);
    }
}

$shgr_game_class = new Shgr_Blocks_Game();
$shgr_game_class->init();

return $shgr_game_class;
