<?php

// Exit if accessed directly.
if ( ! defined('ABSPATH') ) exit;

/**
 * Class Sportshub_Games_Recaps_Run
 * Thats where we bring the plugin to life
 * @package     SHGAMESR
 * @subpackage  Classes/Sportshub_Games_Recaps_Run
 * @author      IT
 * @since       1.0.0
 */

class Sportshub_Games_Recaps_Run {
    /**
     * Our Sportshub_Games_Recaps_Run constructor 
     * to run the plugin logic.
     * @since 1.0.0
     */

    function __construct() {
        $this->add_hooks();
    }

    /**
     * ######################
     * ###
     * #### WORDPRESS HOOKS
     * ###
     * ######################
     */

    /**
     * Registers all WordPress and plugin related hooks
     * @access  private
     * @since   1.0.0
     * @return  void
     */

    private function add_hooks() {
        add_action('wp_enqueue_scripts', [$this, 'enqueue_backend_scripts_and_styles'], 20);
        add_action('admin_menu', [$this, 'register_sportshub_games_recaps_menu'], 20);
        add_action('acf/init', [$this, 'generate_form_sportshub_games_recaps'], 20);
        add_action('acf/init', [$this, 'generate_form_sportshub_games_recaps_contents'], 20);
        add_action('acf/init', [$this, 'generate_form_sportshub_sports_leagues']);
        add_action('acf/save_post', [$this, 'save_options_sports_leagues']);
        add_action('acf/save_post', [$this, 'save_options_sportshub_games_recaps']);
        add_action('acf/save_post', [$this, 'save_options_contents_types']);
        add_filter('cron_schedules', [$this,'sportshub_add_cron_interval']);
        add_action('sportshub_recaps_cron_event', [$this, 'sportshub_recaps_cron_function']);
        register_activation_hook(SHGAMESR_PLUGIN_FILE, [$this, 'activation_hook_callback']);
        register_deactivation_hook(SHGAMESR_PLUGIN_FILE, [$this, 'deactivation_hook_callback']);

        if (empty(get_option('shgr_source')) || get_option('shgr_source') == 'members') {
            add_action('acf/init', [$this, 'generate_form_cpt_game']);
        } else {
            add_action('acf/init', [$this, 'generate_form_cpt_game_simple']);
        }

        add_filter('acf/load_value/name=shgr_reset_last_run', [$this, 'load_field_shgr_reset_last_run'], 10, 3);

        if (get_option('shgr_status') == 1) {
            add_action('init', [$this, 'add_custom_post_type'], 20);
        }
        
        //add_action('plugin_action_links_' . SHGAMESR_PLUGIN_BASE, [$this, 'add_plugin_action_link'], 20);
    }

    public function enqueue_backend_scripts_and_styles() {
        wp_register_script('shgames_recaps_backend_scripts', SHGAMESR_PLUGIN_URL.'core/includes/assets/js/backend-recaps-scripts.js', [], SHGAMESR_VERSION, true);
        wp_enqueue_script('shgames_recaps_backend_scripts');
    }

    public function load_field_shgr_reset_last_run($value) {
        if ($value == 'reset') {
            update_field('shgr_reset_last_run', 'default');
        }

        return 'default';
    }

    public function sportshub_add_cron_interval($schedules) {
        if(!array_key_exists("hourly", $schedules)) {
            $schedules['hourly'] = array(
                'interval' => 60 * 60,
                'display'  => __('Every Hour'),
            );
        }

        if(!array_key_exists("twicedaily", $schedules)) {
            $schedules['twicedaily'] = array(
                'interval' => 60 * 60 * 12,
                'display'  => __('Every 12 hours'),
            );
        }

        if(!array_key_exists("daily", $schedules)) {
            $schedules['daily'] = array(
                'interval' => 60 * 60 * 24,
                'display'  => __('Every Day'),
            );
        }

        if(!array_key_exists("weekly", $schedules)) {
            $schedules['weekly'] = array(
                'interval' => 60 * 60 * 24 * 7,
                'display'  => __('Once Weekly'),
            );
        }

        return $schedules;
    }

    public function sportshub_recaps_cron_function() {
        // Call the WP-CLI command
        $command = 'wp sportshub_games_recaps pull';
        $output = shell_exec($command);
    }

    public function add_plugin_action_link($links) {
        $links['our_shop'] = sprintf('<a href="%s" title="Custom Link" style="font-weight:700;">%s</a>', 'https://test.test', __('Custom Link', 'sportshub-games-recaps') );

        return $links;
    }

    public function register_sportshub_games_recaps_menu() {
        acf_add_options_page([
            'page_title'    => __('Sports Hub Games Recaps Settings'),
            'menu_title'    => __('Sports Hub Games Recaps'),
            'menu_slug'     => SHGAMESR_NAME_SLUG,
            'capability'    => 'edit_posts',
            'icon_url'      => 'dashicons-games',
            'redirect'      => true,
        ]);

        acf_add_options_page([
            'page_title'  => __('Sports and Leagues'),
            'menu_title'  => __('Sports and Leagues'),
            'menu_slug'     => 'acf-options-sports-and-leagues-recaps',
            'parent_slug' => SHGAMESR_NAME_SLUG,
        ]);

        acf_add_options_page([
            'page_title'  => __('Sports Hub Games Recaps Contents'),
            'menu_title'  => __('Sports Contents'),
            'menu_slug'     => 'acf-options-sports-contents-recaps',
            'parent_slug' => SHGAMESR_NAME_SLUG,
        ]);

        acf_add_options_page([
            'page_title'  => __('Sports Hub Games Recaps Settings'),
            'menu_title'  => __('Sports Settings'),
            'menu_slug'     => 'acf-options-sports-settings-recaps',
            'parent_slug' => SHGAMESR_NAME_SLUG,
        ]);
    }

    public function add_custom_post_type() {
        $labels = [
            'name'               => __('Recaps', 'sportshub-games-recaps'),
            'singular_name'      => __('Game', 'sportshub-games-recaps'),
            'menu_name'          => __('Games Recaps', 'sportshub-games-recaps'),
            'all_items'          => __('All Games', 'sportshub-games-recaps'),
            'search_items'       => __('Search Games', 'sportshub-games-recaps'),
            'not_found_in_trash' => __('No games found in Trash.', 'sportshub-games-recaps'),
            'not_found'          => __('No games found.', 'sportshub-games-recaps'),
        ];

        $supports = [
            'title',
            'editor',
            'author',
            'thumbnail',
            'excerpt',
            'custom-fields',
            'revisions',
            'page-attributes'
        ];
         
        $args = [
            'labels'            => $labels,
            'supports'          => $supports,
            'public'            => true,
            'has_archive'       => true,
            'show_in_rest'      => true,
            'hierarchical'      => true,
            'capability_type'   => 'post',
        ];

        register_post_type(get_option('shgr_slug'), $args);
    }

    public function activation_hook_callback() {
        if (!wp_next_scheduled('sportshub_recaps_cron_event')) {
            wp_schedule_event(time(), 'twicedaily', 'sportshub_recaps_cron_event');
            update_option('sportshub_recaps_cron_time', 'twicedaily');
        }
    }

    public function deactivation_hook_callback() {
        wp_clear_scheduled_hook('sportshub_recaps_cron_event');
    }

    public function generate_form_sportshub_games_recaps() {
        $helpers = New Sportshub_Games_Recaps_Helpers;
        $helpers->setRedisGroup(REDIS_GROUP_SHGAMESR);
        $sports = $helpers->getSporstLeaguesOptionsRecap(true);
        $sports_masterfeeds = $helpers->getSporstLeaguesMasterfeedsOptions(true);

        if (is_array($sports)) {
            $sports = ['0' => 'All Sports'] + $sports;
        }

        if (is_array($sports_masterfeeds)) {
            $sports_masterfeeds = ['0' => 'All Sports'] + $sports_masterfeeds;
        }

        if(function_exists('acf_add_local_field_group')):
            acf_add_local_field_group(array(
                'key' => 'group_6g7sffsdfsfsf',
                'title' => 'Sports Hub Games Settings',
                'fields' => array(
                    array(
                        'key' => 'field_64d565794aYTY',
                        'label' => 'Status',
                        'name' => 'shgr_status',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '15',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'inactive' => 'Inactive',
                            'active' => 'Active',
                        ),
                        'default_value' => 'inactive',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_64d5657911222',
                        'label' => 'Data Source',
                        'name' => 'shgr_data_source',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '20',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'members' => 'Members',
                            'masterfeed' => 'Masterfeed',
                        ),
                        'default_value' => 'members',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_sdww56565f43eq23ccc',
                        'label' => 'Debug Blocks Games Active?',
                        'name' => 'shgr_debug_block_games',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '20',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'none' => 'None',
                            'active' => 'Active',
                        ),
                        'default_value' => 'none',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_64d565fe4aere',
                        'label' => 'CPT Slug',
                        'name' => 'shgr_cpt_slug',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '15',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'shgr_field_646e9a1f84fe1',
                        'label' => 'Cronjob run time',
                        'name' => 'shgr_cron_time',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '15',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'hourly' => 'Once Hourly',
                            'twicedaily' => 'Twice Daily',
                            'daily' => 'Once Daily',
                            'weekly' => 'Once Weekly',
                        ),
                        'default_value' => 'twicedaily',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64c95bea5sdsdsd',
                        'label' => 'Last Sports Pull Datetime',
                        'name' => 'shgr_last_run_message',
                        'aria-label' => '',
                        'type' => 'message',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '15',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => get_option('sportshub_recaps_last_run', 'never'),
                        'new_lines' => 'wpautop',
                        'esc_html' => 0,
                    ),
                    array(
                        'key' => 'field_6e4tg34t4th34tf34t43',
                        'label' => 'URL Teams',
                        'name' => 'shgr_teams_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6e45t34tt4334tf3t4r',
                        'label' => 'URL Games',
                        'name' => 'shgr_games_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'shgr_field_64c3e7608071c',
                        'label' => 'URL Members',
                        'name' => 'sportshub_recap_api_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d5657911222',
                                    'operator' => '==',
                                    'value' => 'members',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'shgr_field_64c3e7748071d',
                        'label' => 'Token Members',
                        'name' => 'sportshub_recap_api_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d5657911222',
                                    'operator' => '==',
                                    'value' => 'members',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'shgr_field_64c3ed32424324324',
                        'label' => 'URL Masterfeed',
                        'name' => 'sportshub_recap_api_masterfeed_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d5657911222',
                                    'operator' => '==',
                                    'value' => 'masterfeed',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'shgr_field_64c2dryrsdrrsdr',
                        'label' => 'Token Masterfeed',
                        'name' => 'sportshub_recap_api_masterfeed_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d5657911222',
                                    'operator' => '==',
                                    'value' => 'masterfeed',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'shgr_field_646cfeef60fcf',
                        'label' => 'Sports/Leagues Members',
                        'name' => 'shgr_sports_leagues',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d5657911222',
                                    'operator' => '==',
                                    'value' => 'members',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'shgr_field_646cff2460fd1',
                                'label' => 'League',
                                'name' => 'shgr_sport_league',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '100',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => $helpers->getSporstLeaguesOptionsRecap(true),
                                'default_value' => 1,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'shgr_field_646cfeef60fcf',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'shgr_field_646cfew5f3r34dd3r34r',
                        'label' => 'Sports/Leagues Masterfeed',
                        'name' => 'shgr_sports_leagues_masterfeed',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d5657911222',
                                    'operator' => '==',
                                    'value' => 'masterfeed',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'shgr_field_646wf3rr3f2rrffd1',
                                'label' => 'League',
                                'name' => 'shgr_sport_league_masterfeed',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '100',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => $helpers->getSporstLeaguesMasterfeedsOptions(true),
                                'default_value' => 1,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'shgr_field_646cfew5f3r34dd3r34r',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'shgr_field_64c158c571784',
                        'label' => 'Sports / Authors',
                        'name' => 'shgr_authors',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d5657911222',
                                    'operator' => '==',
                                    'value' => 'members',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'shgr_field_64c95a091857e',
                                'label' => 'Sport',
                                'name' => 'shgr_sport',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => $sports,
                                'default_value' => false,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'shgr_field_64c158c571784',
                            ),
                            array(
                                'key' => 'shgr_field_64c15afbee6ca',
                                'label' => 'Author',
                                'name' => 'shgr_sport_user',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => $this->get_authors(),
                                'default_value' => false,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'shgr_field_64c158c571784',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'shgr_field_6445cdffggfsdfdfhdfhdg',
                        'label' => 'Sports / Authors',
                        'name' => 'shgr_authors_masterfeed',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d5657911222',
                                    'operator' => '==',
                                    'value' => 'masterfeed',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'shgr_field_fhjfhgweghbdbdf',
                                'label' => 'Sport',
                                'name' => 'shgr_sport_masterfeed',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => $sports_masterfeeds,
                                'default_value' => false,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'shgr_field_6445cdffggfsdfdfhdfhdg',
                            ),
                            array(
                                'key' => 'shgr_field_64fhjfghrgrggdg',
                                'label' => 'Author',
                                'name' => 'shgr_sport_user_masterfeed',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => $this->get_authors(),
                                'default_value' => false,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'shgr_field_6445cdffggfsdfdfhdfhdg',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_64c95c1fafc97555',
                        'label' => 'Sports / Main Games',
                        'name' => 'shgr_sports_main_games',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d5657911222',
                                    'operator' => '==',
                                    'value' => 'members',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_64c95c1fafttt',
                                'label' => 'Sport',
                                'name' => 'shgr_sport',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => $sports,
                                'default_value' => false,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_64c95c1fafc97555',
                            ),
                            array(
                                'key' => 'field_64c95c1faffff',
                                'label' => 'Game',
                                'name' => 'shgr_game',
                                'aria-label' => '',
                                'type' => 'post_object',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'post_type' => array(
                                    0 => get_option('shgr_slug'),
                                ),
                                'post_status' => '',
                                'taxonomy' => '',
                                'return_format' => 'id',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 1,
                                'parent_repeater' => 'field_64c95c1fafc97555',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_64c95e46g75h54dryyy',
                        'label' => 'Sports / Main Games',
                        'name' => 'shgr_sports_main_games_masterfeed',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d5657911222',
                                    'operator' => '==',
                                    'value' => 'masterfeed',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_er5bd3ddsdds',
                                'label' => 'Sport',
                                'name' => 'shgr_sport_masterfeed',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => $sports_masterfeeds,
                                'default_value' => false,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_64c95e46g75h54dryyy',
                            ),
                            array(
                                'key' => 'field_64xxxdfcs',
                                'label' => 'Game',
                                'name' => 'shgr_game_masterfeed',
                                'aria-label' => '',
                                'type' => 'post_object',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'post_type' => array(
                                    0 => get_option('shgr_slug'),
                                ),
                                'post_status' => '',
                                'taxonomy' => '',
                                'return_format' => 'id',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 1,
                                'parent_repeater' => 'field_64c95e46g75h54dryyy',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'shgr_field_646ec0e1bb72a',
                        'label' => 'Reset Last Run',
                        'name' => 'shgr_reset_last_run',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'default' => 'Default',
                            'reset' => 'Reset',
                        ),
                        'default_value' => '',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-sports-settings-recaps',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

            endif;    
    }

    public function generate_form_sportshub_sports_leagues() {
        if(function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_63245d37g7yyy',
                'title' => 'Sports and Leagues Members',
                'fields' => array(
                    array(
                        'key' => 'field_64b0165634r3r34r2222',
                        'label' => '',
                        'name' => 'shgame_recaps_sports_and_leagues',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_64b0169de0de2yyy',
                                'label' => 'Sport ID',
                                'name' => 'shgr_sport_id',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '30',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64b0165634r3r34r2222',
                            ),
                            array(
                                'key' => 'field_64b01799e0de3kyyy',
                                'label' => 'Sport Title',
                                'name' => 'shgr_sport_title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64b0165634r3r34r2222',
                            ),
                            array(
                                'key' => 'field_64b01799e0de3yyy',
                                'label' => 'Game Part',
                                'name' => 'shgr_game_parts',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '20',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64b0165634r3r34r2222',
                            ),
                            array(
                                'key' => 'field_64b017c4e0de4222yyy',
                                'label' => 'Leagues',
                                'name' => 'shgr_leagues',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_64b017d3e0de52yyy',
                                        'label' => 'League ID',
                                        'name' => 'shgr_league_id',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '30',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64b017c4e0de4222yyy',
                                    ),
                                    array(
                                        'key' => 'field_64b017e1e0de652yyy',
                                        'label' => 'League Title',
                                        'name' => 'shgr_league_title',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '80',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64b017c4e0de4222yyy',
                                    ),
                                ),
                                'parent_repeater' => 'field_64b0165634r3r34r2222',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-sports-and-leagues-recaps',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

            acf_add_local_field_group(array(
                'key' => 'group_6334f45g643h523f44d2yyy',
                'title' => 'Sports and Leagues Masterfeeds',
                'fields' => array(
                    array(
                        'key' => 'field_64b05433f5435d334533yyy',
                        'label' => '',
                        'name' => 'shgame_recaps_sports_and_leagues_masterfeed',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_64b016sfsfwfrfwefw3yyy',
                                'label' => 'Sport ID',
                                'name' => 'shgr_sport_id_masterfeed',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '30',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64b05433f5435d334533yyy',
                            ),
                            array(
                                'key' => 'field_64wrf23rr2f3yyy',
                                'label' => 'Sport Title',
                                'name' => 'shgr_sport_title_masterfeed',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64b05433f5435d334533yyy',
                            ),
                            array(
                                'key' => 'field_6t34t43t3t3tft343yyy',
                                'label' => 'Game Part',
                                'name' => 'shgr_game_parts_masterfeed',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '20',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64b05433f5435d334533yyy',
                            ),
                            array(
                                'key' => 'field_64tt3v4tt3t3t33yyy',
                                'label' => 'Leagues',
                                'name' => 'shgr_leagues_masterfeed',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_64by3b43t43c3tyyy',
                                        'label' => 'League ID',
                                        'name' => 'shgr_league_id_masterfeed',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '30',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64tt3v4tt3t3t33yyy',
                                    ),
                                    array(
                                        'key' => 'field_6g34t4b4t4b546u4yyy',
                                        'label' => 'League Title',
                                        'name' => 'shgr_league_title_masterfeed',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '80',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_64tt3v4tt3t3t33yyy',
                                    ),
                                ),
                                'parent_repeater' => 'field_64b05433f5435d334533yyy',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-sports-and-leagues-recaps',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

            endif;    
    }

    public function save_options_sports_leagues() {
        try {
            $option = (isset($_GET['page'])) ? $_GET['page'] : null;

            if (!empty($option) && $option == 'acf-options-sports-and-leagues-recaps' && isset($_POST['acf']) && is_array($_POST['acf']) && count($_POST['acf']) > 0) {
                $helpers = New Sportshub_Games_Recaps_Helpers;
                $helpers->setRedisGroup(REDIS_GROUP_SHGAMESR);
                
                if ($helpers->initRedis()) {
                    try {
                        $key_sports = $helpers->getRedisKeySports();
                        $key_sports_masterfeeds = $helpers->getRedisKeySportsMasterfeeds();
                        $key_sports_leagues = $helpers->getRedisKeySportsLeagues();
                        $key_sports_leagues_masterfeeds = $helpers->getRedisKeySportsLeaguesMasterfeeds();

                        $helpers->setRedis($key_sports, serialize([]), SHGAMESR_REDIS_TIMEOUT);
                        $helpers->setRedis($key_sports_masterfeeds, serialize([]), SHGAMESR_REDIS_TIMEOUT);
                        $helpers->setRedis($key_sports_leagues, serialize([]), SHGAMESR_REDIS_TIMEOUT);
                        $helpers->setRedis($key_sports_leagues_masterfeeds, serialize([]), SHGAMESR_REDIS_TIMEOUT);
                    } catch (\Exception $exception) {
                        error_log(print_r([
                            'message' => $exception->getMessage(),
                            'keys' => [$key_sports, $key_sports_masterfeeds, $key_sports_leagues],
                        ], true));
                    }
                } else {
                    error_log(print_r([
                        'message' =>  'Redis activation is necessary to store the sports and leagues cache.',
                    ], true));
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => $exception->getMessage(),
                'option' => $option,
            ], true));
        }
    }

    public function get_authors() {
        try {
            $users_list = [];
            $roles = ['contributor', 'author', 'editor', 'administrator'];
            $users = get_users(['role__in' => $roles]);

            if (is_array($users) && count($users) > 0) {
                foreach ($users as $user) {
                    if (isset($user->data->user_login) && !empty($user->data->user_login)) {
                        $users_list[$user->data->ID] = $user->data->user_login;
                    }
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => $exception->getMessage(),
                'roles' => $roles,
            ], true));
        }

        return $users_list;
    }

    public function save_options_sportshub_games_recaps() {
        try {
            $option = (isset($_GET['page'])) ? $_GET['page'] : null;

            if (!empty($option) && $option == 'acf-options-sports-settings-recaps' && isset($_POST['acf']) && is_array($_POST['acf']) && count($_POST['acf']) > 0) {
                $cpt_status = current($_POST['acf']);
                $cpt_source = next($_POST['acf']);
                $debug_game = next($_POST['acf']);
                $cpt_slug = next($_POST['acf']);
                $cron = next($_POST['acf']);
                $url_teams = next($_POST['acf']);
                $url_games = next($_POST['acf']);
                $url = next($_POST['acf']);
                $token = next($_POST['acf']);
                $sports_leagues = next($_POST['acf']);
                $sports_authors = next($_POST['acf']);
                $sports_main_games = next($_POST['acf']);
                $reset = next($_POST['acf']);

                $set_option_status = (!empty($cpt_status) && $cpt_status == 'active') ? true : false;
                $set_option_source = (!empty($cpt_source)) ? $cpt_source : 'members';
                $set_option_slug = (!empty($cpt_slug)) ? $cpt_slug : 'game';

                update_option('shgr_status', $set_option_status, true);
                update_option('shgr_source', $set_option_source, 'members');
                update_option('shgr_slug', $set_option_slug, true);

                $original_cron = get_option('sportshub_recaps_cron_time');

                if ((!empty($cron)) && ($original_cron != $cron)) {
                    wp_clear_scheduled_hook('sportshub_recaps_cron_event');
                    wp_schedule_event(time(), $cron, 'sportshub_recaps_cron_event');
                }

                update_option('sportshub_recaps_cron_time', $cron);

                if (!empty($reset) && $reset == 'reset') {
                    delete_option('sportshub_recaps_last_run');
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => $exception->getMessage(),
                'option' => $option,
            ], true));
        }
    }

    public function generate_form_cpt_game() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_6406f02fb6ca55555',
                'title' => 'SBG Automatic Games Recaps',
                'fields' => array(
                    array(
                        'key' => 'field_64ca95f995555',
                        'label' => 'Game External ID',
                        'name' => 'shgr_external_id',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f995555',
                        'label' => 'Game Date',
                        'name' => 'shgr_game_date',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9a5555',
                        'label' => 'Sport ID',
                        'name' => 'shgr_sport_id',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '20',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9a5555',
                        'label' => 'Category',
                        'name' => 'shgr_category',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9a5555',
                        'label' => 'League',
                        'name' => 'shgr_league',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9a5555',
                        'label' => 'Game Stat',
                        'name' => 'shgr_game_stat',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9b5555',
                        'label' => 'Picks Count',
                        'name' => 'shgr_game_picks_count',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64caab7wrwrw5555',
                        'label' => 'ID Home Team',
                        'name' => 'shgr_id_home_team',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '10',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64caab7635555',
                        'label' => 'Home Team',
                        'name' => 'shgr_home_team',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64caab9035555',
                        'label' => 'Home Score',
                        'name' => 'shgr_home_score',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '10',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64caabaa35555',
                        'label' => 'Home API Image',
                        'name' => 'shgr_home_image',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64cd0bdfc5555',
                        'label' => 'Home Local Image',
                        'name' => 'shgr_home_local_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64caaaffsfsfs5555',
                        'label' => 'ID Visitor Team',
                        'name' => 'shgr_id_visitor_team',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '10',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64caaa2015555',
                        'label' => 'Visitor Team',
                        'name' => 'shgr_visitor_team',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64caaa6b15555',
                        'label' => 'Visitor Score',
                        'name' => 'shgr_visitor_score',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '10',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64caaa8715555',
                        'label' => 'Visitor API Image',
                        'name' => 'shgr_visitor_image',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64cd0c16c5555',
                        'label' => 'Visitor Local Image',
                        'name' => 'shgr_visitor_local_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9b5555',
                        'label' => 'Game URL',
                        'name' => 'shgr_game_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9b5555',
                        'label' => 'Current Game Odds',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'accordion',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'open' => 1,
                        'multi_expand' => 1,
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_64ca95f9b5555',
                        'label' => 'Money Line Home Odds',
                        'name' => 'shgr_current_money_line_home_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9c5555',
                        'label' => 'Money Line Visitor Odds',
                        'name' => 'shgr_current_money_line_visitor_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9c5555',
                        'label' => 'Total Over Points',
                        'name' => 'shgr_current_total_over_points',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9c5555',
                        'label' => 'Total Over Odds',
                        'name' => 'shgr_current_total_over_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9c5555',
                        'label' => 'Total Under Points',
                        'name' => 'shgr_current_total_under_points',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9c5555',
                        'label' => 'Total Under Odds',
                        'name' => 'shgr_current_total_under_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9d5555',
                        'label' => 'Spread Home Points',
                        'name' => 'shgr_current_spread_home_points',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9d5555',
                        'label' => 'Spread Home Odds',
                        'name' => 'shgr_current_spread_home_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9d5555',
                        'label' => 'Spread Visitor Points',
                        'name' => 'shgr_current_spread_visitor_points',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9d5555',
                        'label' => 'Spread Visitor Odds',
                        'name' => 'shgr_current_spread_visitor_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9b5555',
                        'label' => 'Opener Game Odds',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'accordion',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'open' => 1,
                        'multi_expand' => 1,
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_64ca95f9bd205555',
                        'label' => 'Money Line Home Odds',
                        'name' => 'shgr_opener_money_line_home_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9c0cf5555',
                        'label' => 'Money Line Visitor Odds',
                        'name' => 'shgr_opener_money_line_visitor_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9c4765555',
                        'label' => 'Total Over Points',
                        'name' => 'shgr_opener_total_over_points',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9c8215555',
                        'label' => 'Total Over Odds',
                        'name' => 'shgr_opener_total_over_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9cbdc5555',
                        'label' => 'Total Under Points',
                        'name' => 'shgr_opener_total_under_points',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9cf7e5555',
                        'label' => 'Total Under Odds',
                        'name' => 'shgr_opener_total_under_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9d3435555',
                        'label' => 'Spread Home Points',
                        'name' => 'shgr_opener_spread_home_points',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9d7135555',
                        'label' => 'Spread Home Odds',
                        'name' => 'shgr_opener_spread_home_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9daac5555',
                        'label' => 'Spread Visitor Points',
                        'name' => 'shgr_opener_spread_visitor_points',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64ca95f9de695555',
                        'label' => 'Spread Visitor Odds',
                        'name' => 'shgr_opener_spread_visitor_odds',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => get_option('shgr_slug'),
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
            endif;        
    }

    public function generate_form_cpt_game_simple() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_6406f02fbe5g643f56666',
                'title' => 'SBG Automatic Games Recaps',
                'fields' => array(
                    array(
                        'key' => 'field_64ca353f45f6666',
                        'label' => 'Game External ID',
                        'name' => 'shgr_external_id',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6tr43t3d3436666',
                        'label' => 'Sport ID',
                        'name' => 'shgr_sport_id',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_e5tg34t43tg43t436666',
                        'label' => 'Category',
                        'name' => 'shgr_category',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6erwrwwrwefr6666',
                        'label' => 'Game Date',
                        'name' => 'shgr_game_date',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_ryryy4y4t4t34t6666',
                        'label' => 'ID Home Team',
                        'name' => 'shgr_id_home_team',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '20',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_435345435r3345r6666',
                        'label' => 'Home Team',
                        'name' => 'shgr_home_team',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_643f3f453535g346666',
                        'label' => 'Home City',
                        'name' => 'shgr_home_city',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_sedffuhjyu67we6666',
                        'label' => 'ID Visitor Team',
                        'name' => 'shgr_id_visitor_team',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '20',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_ghjkui873weter6666',
                        'label' => 'Visitor Team',
                        'name' => 'shgr_visitor_team',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_ertrb67u8876456666',
                        'label' => 'Visitor City',
                        'name' => 'shgr_visitor_city',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '40',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_fthyr64fctf6666',
                        'label' => 'Game URL',
                        'name' => 'shgr_game_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_awq2ceeruty6u45t36666',
                        'label' => 'Game API Image',
                        'name' => 'shgr_game_api_image',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_ftuyy7945certgte6666',
                        'label' => 'Game Local Image',
                        'name' => 'shgr_game_local_image',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '25',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => get_option('shgr_slug'),
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));
            endif;        
    }

    public function generate_form_sportshub_games_recaps_contents() {
        if(function_exists('acf_add_local_field_group')):
            acf_add_local_field_group(array(
                'key' => 'group_6234f434444',
                'title' => 'Sports Hub Games Recaps Contents',
                'fields' => array(
                    array(
                        'key' => 'field_642344324324444',
                        'label' => 'Status',
                        'name' => 'shgr_content_status',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'inactive' => 'Inactive',
                            'active' => 'Active',
                        ),
                        'default_value' => 'inactive',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'shgr_field_6445f3d47674444',
                        'label' => 'URL',
                        'name' => 'shgr_content_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_642344324324444',
                                    'operator' => '==',
                                    'value' => 'active',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'shgr_field_6ghf23q4bgfh9hgfq24444',
                        'label' => 'Token',
                        'name' => 'shgr_content_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_642344324324444',
                                    'operator' => '==',
                                    'value' => 'active',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'shgr_field_646cseffw45fr4444',
                        'label' => 'Content Types',
                        'name' => 'shgr_content_types',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_642344324324444',
                                    'operator' => '==',
                                    'value' => 'active',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'shgr_field_6ghfw4f534524444',
                                'label' => 'Type Slug',
                                'name' => 'shgr_content_type_slug',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'shgr_field_646cseffw45fr4444',
                            ),
                            array(
                                'key' => 'shgr_field_6ge34b45y54yjrddfg4444',
                                'label' => 'Type Title',
                                'name' => 'shgr_content_type_title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'shgr_field_646cseffw45fr4444',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-sports-contents-recaps',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

            endif;    
    }

    public function save_options_contents_types() {
        try {
            $option = (isset($_GET['page'])) ? $_GET['page'] : null;

            if (!empty($option) && $option == 'acf-options-sports-contents-recaps' && isset($_POST['acf']) && is_array($_POST['acf']) && count($_POST['acf']) > 0) {
                $helpers = New Sportshub_Games_Recaps_Helpers;
                $helpers->setRedisGroup(REDIS_GROUP_SHGAMESR);

                if ($helpers->initRedis()) {
                    try {
                        $key_sports_contents = $helpers->getRedisKeySportsContents();
                        $helpers->setRedis($key_sports_contents, serialize([]), SHGAMESR_REDIS_TIMEOUT);
                    } catch (\Exception $exception) {
                        error_log(print_r([
                            'message' => $exception->getMessage(),
                            'keys' => [$key_sports_contents],
                        ], true));
                    }
                } else {
                    error_log(print_r([
                        'message' =>  'Redis activation is necessary to store the sports contents cache.',
                    ], true));
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => $exception->getMessage(),
                'option' => $option,
            ], true));
        }
    }
}
