<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shgr_Blocks_Game_Links extends Shgr_Blocks_Base
{
    protected $block_name = BLOCK_SHGR_GAME_LINKS;
    private $block_folder_name = BLOCK_SHGR_GAME_LINKS;
    private $block_title = 'SHGR Game Links';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shgr', 'custom', 'game', 'link'];
    private $block_mode = 'preview';
    private $block_category = SHGAMESR_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shgr_helpers = new Sportshub_Games_Recaps_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHGAMESR_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shgr_helpers->webpack('shgr_game_links.css'),
                'enqueue_assets' => function(){
                    wp_register_script('shgr_game_links', SHGAMESR_PLUGIN_URL.'blocks/shgr-game-links/assets/js/shgr-game-links.js', [], '1', true);
                    wp_enqueue_script('shgr_game_links');
                    wp_localize_script('shgr_game_links','shgr_game_links',['ajaxurl' => admin_url('admin-ajax.php')]);
                },
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }
}

$shgr_game_links_class = new Shgr_Blocks_Game_Links();
$shgr_game_links_class->init();

return $shgr_game_links_class;
