<?php
/**
 * SportsHub Games Recaps
 *
 * @package SHGAMESR
 * @author  IT
 * @version 1.0.4
 *
 * @wordpress-plugin
 * Plugin Name: SportsHub Games Recaps
 * Plugin URI:  https://www.sportshub.com
 * Description: SportsHub Network Games Recaps Importer
 * Version:     1.0.4
 * Author:      IT
 * Author URI:  https://www.sportshub.com
 * Text Domain: sportshub-games-recaps
 * Domain Path: /languages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * HELPER COMMENT START
 * 
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 * 
 * The comment above contains all information about the plugin 
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 * 
 * The function SHGAMESR() is the main function that you will be able to 
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 * 
 * HELPER COMMENT END
 */

// Plugin name
define('SHGAMESR_NAME','SportsHub Games Recaps');
define('SHGAMESR_NAME_SLUG', 'sportshub-games-recaps');

// Plugin version
define('SHGAMESR_VERSION', '1.0.4');

// REDIS
define('REDIS_GROUP_SHGAMESR', 'sh_games_recaps');

if (!defined('SHGAMESR_REDIS_TIMEOUT')) {
    define('SHGAMESR_REDIS_TIMEOUT', 3600);
}

// UPLOAD DIR
$plugin_upload_dir = wp_upload_dir()['basedir'] . '/' . str_replace(' ', '_', SHGAMESR_NAME);
define('SHGAMESR_PLUGIN_LOG_DIR', $plugin_upload_dir);

// Plugin Root File
define('SHGAMESR_PLUGIN_FILE', __FILE__);

// Plugin base
define('SHGAMESR_PLUGIN_BASE', plugin_basename( SHGAMESR_PLUGIN_FILE));

// Plugin Folder Path
define('SHGAMESR_PLUGIN_DIR', plugin_dir_path( SHGAMESR_PLUGIN_FILE));

// Plugin Folder URL
define('SHGAMESR_PLUGIN_URL', plugin_dir_url( SHGAMESR_PLUGIN_FILE));

define('BLOCK_SHGR_GAME', 'shgr-game');
define('BLOCK_SHGR_GAME_TOP_HANDICAPPER', 'shgr-game-top-handicapper');
define('BLOCK_SHGR_GAME_LINKS', 'shgr-game-links');

/**
 * Load the main class for the core functionality
 */
require_once SHGAMESR_PLUGIN_DIR . 'core/class-sportshub-games-recaps.php';
require_once SHGAMESR_PLUGIN_DIR . 'blocks/shgr-blocks-base.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  IT
 * @since   1.0.0
 * @return  object|Sportshub_Games_Recaps
 */
function SHGAMESR() {
    $shgr = Sportshub_Games_Recaps::instance();
    $shgr_base_style = $shgr->helpers->webpack('shgr_base_style.css');

    return $shgr;
}

$shgr = SHGAMESR();
