<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shr_Blocks_Recap_Picks extends Sh_Blocks_Base
{
    protected $block_name = BLOCK_SH_RECAP_PICKS_RECAPS;
    private $block_folder_name = BLOCK_SH_RECAP_PICKS_RECAPS;
    private $block_title = 'SH Recap Picks';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shr', 'custom', 'game', 'pick'];
    private $block_mode = 'preview';
    private $block_category = SHRECAPS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shr_helpers = new Sportshub_Recaps_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHRECAPS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shr_helpers->webpack('sh_recap_picks_recaps.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_block_fields($post, $shr) {
        $example_fields = [
            'shr_game_top_handicapper_id' => '71',
            'shr_game_top_handicapper_name' => 'Totals Guru',
            'shr_game_top_handicapper_local_image' => SHRECAPS_PLUGIN_URL.'blocks/sh-recap-top-handicapper/assets/img/capper.png',
            'shr_game_top_handicapper_description' => "<p>Picks can be found on BestBettor, part of SportsCapping Group.</p><p>The Totals Guru believes there is an unmatched value in over/under wagers.&nbsp; That is why he doesn't play any sides, just totals!</p>",
            'shr_game_results_rank' => '1',
            'shr_sport_name' => 'Basketball',
            'shr_game_results_yesterday' => '100',
            'shr_game_results_lastthreedays' => '90',
            'shr_game_results_lastsevendays' => '-140',
            'shr_game_results_lastthirtydays' => '390',
        ];

        $fields_validate = [];
        
        if ($post->post_type == 'gp_elements') {
            return array_merge($example_fields, [
                'type' => 'example',
            ]);
        }

        $validate = true;
        $custom_fields = [];

        foreach ($example_fields as $key => $value) {
            $custom_fields[$key] = get_field($key, $post->ID);
        }

        $invalid_fields = [];

        foreach ($example_fields as $key => $value) {
            if (!isset($custom_fields[$key]) || empty($custom_fields[$key])) {
                if (!isset($fields_validate[$key]) || (isset($fields_validate[$key]) && $fields_validate[$key] != 'nullable')) {
                    $validate = false;
                    $invalid_fields[$key] = $custom_fields[$key];
                }
            }
        }

        if (!$validate) {
            return array_merge($example_fields, [
                'type' => 'Invalid field validation',
                'example' => $example_fields,
                'invalid_fields' => $invalid_fields,
            ]);
        }

        return array_merge($custom_fields, ['type' => '']);
    }

    public function getTitle($type, $types, $fields, $post_id = null)
    {
        if ($type == 'picks') {
            if (isset($types[$type]['shr_content_type_title_members']) && !empty($types[$type]['shr_content_type_title_members'])) {
                return $this->setPlaceholders($types[$type]['shr_content_type_title_members'], $fields);
            }

            return 'Top Picks';
        }

        if ($type == 'top-handicapper') {
            if (isset($types[$type]['shr_content_type_title_members']) && !empty($types[$type]['shr_content_type_title_members'])) {
                return $this->setPlaceholders($types[$type]['shr_content_type_title_members'], $fields);
            }

            return 'Top Handicapper';
        }

        if ($type == 'odds') {
            if (isset($types[$type]['shr_content_type_title_members']) && !empty($types[$type]['shr_content_type_title_members'])) {
                return $this->setPlaceholders($types[$type]['shr_content_type_title_members'], $fields);
            }

            return 'Odds';
        }

        if ($type == 'game-picks') {
            if (isset($types[$type]['shr_content_type_title_members']) && !empty($types[$type]['shr_content_type_title_members'])) {
                $shr_helpers = new Sportshub_Recaps_Helpers();
                return $shr_helpers->getTitle($types[$type]['shr_content_type_title_members'], $post_id);
            }

            return 'Game Picks';
        }

        return '';
    }

    public function setPlaceholders($text, $fields)
    {
        $text = str_replace('[author]', $fields['shr_game_top_handicapper_name'], $text);
        $text = str_replace('[sport]', $fields['shr_sport_name'], $text);

        return $text;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-shr-recaps-picks-inner-bg', 'slug' => 'color-shr-recaps-picks-inner-bg', 'color' => '#ffffff'],
            ['name' => 'color-shr-recaps-picks-border', 'slug' => 'color-shr-recaps-picks-border', 'color' => '#cccccc'],
            ['name' => 'color-shr-recaps-picks-title-color', 'slug' => 'color-shr-recaps-picks-title-color', 'color' => '#111111'],
            ['name' => 'color-shr-recaps-picks-link-bg', 'slug' => 'color-shr-recaps-picks-link-bg', 'color' => '#0160ac'],
            ['name' => 'color-shr-recaps-picks-handicapper-name', 'slug' => 'color-shr-recaps-picks-handicapper-name', 'color' => '#0160ac'],
            ['name' => 'color-shr-recaps-picks-handicapper-package', 'slug' => 'color-shr-recaps-picks-handicapper-package', 'color' => '#0160ac'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.sh-recap-picks-recaps .pick .pick-header .handicapper .name',
                'fontSize' => '1rem',
                'fontWeight' => '700',
                'lineHeight' => '.8rem',
            ],[
                'customSelector' => '.sh-recap-picks-recaps .pick .pick-header .handicapper .package',
                'fontSize' => '1rem',
            ],[
                'customSelector' => '.sh-recap-picks-recaps .pick .pick-header .stats',
                'fontSize' => '.7rem',
            ],[
                'customSelector' => '.sh-recap-picks-recaps .pick .pick-header .stats .win, .sh-recap-picks-recaps .pick .pick-header .stats .lose',
                'fontWeight' => '600',
            ],[
                'customSelector' => '.sh-recap-picks-recaps .pick .pick-body .data .status_home, .sh-recap-picks-recaps .pick .pick-body .data .status_visitor',
                'fontSize' => '.9rem',
                'fontWeight' => '700',
            ],[
                'customSelector' => '.sh-recap-picks-recaps .pick .pick-body .data .date',
                'fontSize' => '1rem',
            ],[
                'customSelector' => '.sh-recap-picks-recaps .pick .pick-body .teams .team-vs .vs-logo span',
                'fontSize' => '1.2rem',
                'fontWeight' => '700',
            ],[
                'customSelector' => '.sh-recap-picks-recaps .pick .footer',
                'fontWeight' => '400',
            ],[
                'customSelector' => '.sh-recap-picks-recaps .pick .footer .footer-link .link span',
                'textTransform' => 'uppercase',
            ],[
                'customSelector' => '.sh-recap-picks-recaps .pick .footer-link .link',
                'fontWeight' => '600',
                'fontSize' => '.9rem',
                'lineHeight' => '1rem',
            ],
        ];
    }
}

$sh_recap_picks_class = new Shr_Blocks_Recap_Picks();
$sh_recap_picks_class->init();

return $sh_recap_picks_class;
