<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shr_Blocks_Recap_Top_Handicapper extends Sh_Blocks_Base
{
    protected $block_name = BLOCK_SH_RECAP_TOP_HANDICAPPER;
    private $block_folder_name = BLOCK_SH_RECAP_TOP_HANDICAPPER;
    private $block_title = 'SH Recap Top Handicapper';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shr', 'custom', 'game', 'top', 'handicapper'];
    private $block_mode = 'preview';
    private $block_category = SHRECAPS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shr_helpers = new Sportshub_Recaps_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHRECAPS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shr_helpers->webpack('sh_recap_top_handicapper.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_block_fields($post, $shr) {
        $example_fields = [
            'shr_game_top_handicapper_id' => '71',
            'shr_game_top_handicapper_name' => 'Totals Guru',
            'shr_game_top_handicapper_local_image' => SHRECAPS_PLUGIN_URL.'blocks/sh-recap-top-handicapper/assets/img/capper.png',
            'shr_game_top_handicapper_description' => "<p>Picks can be found on BestBettor, part of SportsCapping Group.</p><p>The Totals Guru believes there is an unmatched value in over/under wagers.&nbsp; That is why he doesn't play any sides, just totals!</p>",
            'shr_game_results_rank' => '1',
            'shr_sport_name' => 'Basketball',
            'shr_game_results_yesterday' => '100',
            'shr_game_results_lastthreedays' => '90',
            'shr_game_results_lastsevendays' => '-140',
            'shr_game_results_lastthirtydays' => '390',
        ];

        $fields_validate = [];
        
        if ($post->post_type == 'gp_elements') {
            return array_merge($example_fields, [
                'type' => 'example',
            ]);
        }

        $validate = true;
        $custom_fields = [];

        foreach ($example_fields as $key => $value) {
            $custom_fields[$key] = get_field($key, $post->ID);
        }

        $invalid_fields = [];

        foreach ($example_fields as $key => $value) {
            if (!isset($custom_fields[$key]) || empty($custom_fields[$key])) {
                if (!isset($fields_validate[$key]) || (isset($fields_validate[$key]) && $fields_validate[$key] != 'nullable')) {
                    $validate = false;
                    $invalid_fields[$key] = $custom_fields[$key];
                }
            }
        }

        if (!$validate) {
            return array_merge($example_fields, [
                'type' => 'Invalid field validation',
                'example' => $example_fields,
                'invalid_fields' => $invalid_fields,
            ]);
        }

        return array_merge($custom_fields, ['type' => '']);
    }

    public function getTitle($type, $types, $fields)
    {
        if ($type == 'picks') {
            if (isset($types[$type]['shr_content_type_title_members']) && !empty($types[$type]['shr_content_type_title_members'])) {
                return $this->setPlaceholders($types[$type]['shr_content_type_title_members'], $fields);
            }

            return 'Top Picks';
        }

        if ($type == 'top-handicapper') {
            if (isset($types[$type]['shr_content_type_title_members']) && !empty($types[$type]['shr_content_type_title_members'])) {
                return $this->setPlaceholders($types[$type]['shr_content_type_title_members'], $fields);
            }

            return 'Top Handicapper';
        }

        if ($type == 'odds') {
            if (isset($types[$type]['shr_content_type_title_members']) && !empty($types[$type]['shr_content_type_title_members'])) {
                return $this->setPlaceholders($types[$type]['shr_content_type_title_members'], $fields);
            }

            return 'Odds';
        }

        return '';
    }

    public function setPlaceholders($text, $fields)
    {
        $text = str_replace('[author]', $fields['shr_game_top_handicapper_name'], $text);
        $text = str_replace('[sport]', $fields['shr_sport_name'], $text);

        return $text;
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-shr-recaps-top-handicapper-inner-bg','slug' => 'color-shr-recaps-top-handicapper-inner-bg','color' => '#ffffff'],
            ['name' => 'color-shr-recaps-top-handicapper-inner-border','slug' => 'color-shr-recaps-top-handicapper-inner-border','color' => '#cccccc'],
            ['name' => 'color-shr-recaps-top-handicapper-title-color','slug' => 'color-shr-recaps-top-handicapper-title-color','color' => '#111111'],
            ['name' => 'color-shr-recaps-top-handicapper-header-name','slug' => 'color-shr-recaps-top-handicapper-header-name','color' => '#3a96e0'],
            ['name' => 'color-shr-recaps-top-handicapper-header-separator','slug' => 'color-shr-recaps-top-handicapper-header-separator','color' => '#cccccc'],
            ['name' => 'color-shr-recaps-top-handicapper-header-cat','slug' => 'color-shr-recaps-top-handicapper-header-cat','color' => '#111111'],
            ['name' => 'color-shr-recaps-top-handicapper-game-color','slug' => 'color-shr-recaps-top-handicapper-game-color','color' => '#ffffff'],
            ['name' => 'color-shr-recaps-top-handicapper-game-border','slug' => 'color-shr-recaps-top-handicapper-game-border','color' => '#3a96e0'],
            ['name' => 'color-shr-recaps-top-handicapper-game-bg','slug' => 'color-shr-recaps-top-handicapper-game-bg','color' => '#0160ac'],
            ['name' => 'color-shr-recaps-top-handicapper-game-body','slug' => 'color-shr-recaps-top-handicapper-game-body','color' => '#f1f1f1'],
            ['name' => 'color-shr-recaps-top-handicapper-list-game-time','slug' => 'color-shr-recaps-top-handicapper-list-game-time','color' => '#111111'],
            ['name' => 'color-shr-recaps-top-handicapper-list-game-amount','slug' => 'color-shr-recaps-top-handicapper-list-game-amount','color' => '#0160ac'],
            ['name' => 'color-shr-recaps-top-handicapper-footer-bg','slug' => 'color-shr-recaps-top-handicapper-footer-bg','color' => '#cccccc'],
            ['name' => 'color-shr-recaps-top-handicapper-footer-color','slug' => 'color-shr-recaps-top-handicapper-footer-color','color' => '#111111'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.sh-recap-top-handicapper .pick-link .link',
                'fontWeight' => '600',
                'fontSize' => '0.9rem',
                'LineHeight' => '1rem',
            ],
            [
                'customSelector' => '.sh-recap-top-handicapper .teams .team-name',
                'fontWeight' => '700',
                'fontSize' => '0.8rem',
            ],
            [
                'customSelector' => '.sh-recap-top-handicapper .top-title',
                'fontWeight' => '700',
                'fontSize' => '2rem',
            ],
            [
                'customSelector' => '.sh-recap-top-handicapper .pick .pick-header .date-time',
                'fontWeight' => '700',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.sh-recap-top-handicapper .top-content .top-body .games .game .game-body .list-game',
                'fontWeight' => '700',
                'fontSize' => '0.9rem',
            ],
            [
                'customSelector' => '.sh-recap-top-handicapper .top-content .top-body .games .game .game-title',
                'fontWeight' => '600',
                'fontSize' => '1.2rem',
            ],
            [
                'customSelector' => '.sh-recap-top-handicapper .top-content .top-body .body-header .body-header-capper .cat',
                'fontWeight' => '700',
                'fontSize' => '1.3rem',
            ],
            [
                'customSelector' => '.sh-recap-top-handicapper .top-content .top-body .body-header .body-header-capper .name',
                'fontWeight' => '700',
                'fontSize' => '1.3rem',
            ],
        ];
    }
}

$sh_recap_top_handicapper_class = new Shr_Blocks_Recap_Top_Handicapper();
$sh_recap_top_handicapper_class->init();

return $sh_recap_top_handicapper_class;
