<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shr_Blocks_Recap extends Sh_Blocks_Base
{
    protected $block_name = BLOCK_SH_RECAP;
    private $block_folder_name = BLOCK_SH_RECAP;
    private $block_title = 'SH Recap';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shr', 'custom', 'game'];
    private $block_mode = 'preview';
    private $block_category = SHRECAPS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shr_helpers = new Sportshub_Recaps_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHRECAPS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shr_helpers->webpack('sh_recap.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_block_fields($post, $shr) {
        $example_fields = [
            'shr_sport_id' => '1',
            'shr_league' => '23',
            'shr_game_date' => '2023-09-15 10:25:00',
            'shr_home_team' => 'Chiefs',
            'shr_home_score' => '21',
            'shr_home_local_url' => SHRECAPS_PLUGIN_URL.'blocks/sh-recap/assets/img/chiefs.png',
            'shr_home_money_odds' => '-288',
            'shr_visitor_team' => 'Lions',
            'shr_visitor_score' => '3',
            'shr_visitor_local_url' => SHRECAPS_PLUGIN_URL.'blocks/sh-recap/assets/img/lions.png',
            'shr_away_money_odds' => '+236',
        ];

        $fields_validate = [
            'shr_league' => 'nullable',
            'shr_home_score' => 'nullable',
            'shr_visitor_score' => 'nullable',
        ];

        $sport_leagues_names = [];
        if (function_exists('shMappingSportsLeaguesNamesConverter')) {
            $sport_leagues_names = shMappingSportsLeaguesNamesConverter();
        }
        
        if ($post->post_type == 'gp_elements') {
            $title = null;

            if (isset($sport_leagues_names['sports']) && is_array($sport_leagues_names['sports']) && count($sport_leagues_names['sports']) > 0) {
                if (isset($sport_leagues_names['sports'][$example_fields['shr_sport_id']])) {
                    $title = $sport_leagues_names['sports'][$example_fields['shr_sport_id']];
                }
            }

            return array_merge($example_fields, [
                'type' => 'example',
                'title' => $title
            ]);
        }

        $validate = true;
        $custom_fields = [];

        foreach ($example_fields as $key => $value) {
            $custom_fields[$key] = get_field($key, $post->ID);
        }

        $invalid_fields = [];

        foreach ($example_fields as $key => $value) {
            if (!isset($custom_fields[$key]) || empty($custom_fields[$key])) {
                if (!isset($fields_validate[$key]) || (isset($fields_validate[$key]) && $fields_validate[$key] != 'nullable')) {
                    $validate = false;
                    $invalid_fields[$key] = $custom_fields[$key];
                }
            }
        }

        if (!$validate) {
            return array_merge($example_fields, [
                'type' => 'Invalid field validation',
                'example' => $example_fields,
                'invalid_fields' => $invalid_fields,
            ]);
        }

        $custom_fields['title'] = null;
        if (is_array($sport_leagues_names) && count($sport_leagues_names) > 0) {
            if (isset($custom_fields['shr_league']) && !empty($custom_fields['shr_league'])) {
                if (isset($sport_leagues_names['leagues'][$custom_fields['shr_league']]) && !empty($sport_leagues_names['leagues'][$custom_fields['shr_league']])) {
                    $custom_fields['title'] = $sport_leagues_names['leagues'][$custom_fields['shr_league']];
                } elseif (isset($sport_leagues_names['sports'][$custom_fields['shr_sport_id']]) && !empty($sport_leagues_names['sports'][$custom_fields['shr_sport_id']])) {
                    $custom_fields['title'] = $sport_leagues_names['sports'][$custom_fields['shr_sport_id']];
                }
            } else {
                if (isset($sport_leagues_names['sports'][$custom_fields['shr_sport_id']]) && !empty($sport_leagues_names['sports'][$custom_fields['shr_sport_id']])) {
                    $custom_fields['title'] = $sport_leagues_names['sports'][$custom_fields['shr_sport_id']];
                }
            }
        }

        return array_merge($custom_fields, ['type' => '']);
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-shr-recaps-header-bg','slug' => 'color-shr-recaps-header-bg','color' => '#0160ac'],
            ['name' => 'color-shr-recaps-header-color','slug' => 'color-shr-recaps-header-color','color' => '#ffffff'],
            ['name' => 'color-shr-recaps-header-border','slug' => 'color-shr-recaps-header-border','color' => '#3a96e0'],
            ['name' => 'color-shr-recaps-game-team-vs','slug' => 'color-shr-recaps-game-team-vs','color' => '#00bc00'],
            ['name' => 'color-shr-recaps-game-body','slug' => 'color-shr-recaps-game-body','color' => '#dedede'],
            ['name' => 'color-shr-recaps-game-score-bg','slug' => 'color-shr-recaps-game-score-bg','color' => '#ffffff'],
            ['name' => 'color-shr-recaps-game-stats-color','slug' => 'color-shr-recaps-game-stats-color','color' => '#ffffff'],
            ['name' => 'color-shr-recaps-game-stats-success','slug' => 'color-shr-recaps-game-stats-success','color' => '#00bc00'],
            ['name' => 'color-shr-recaps-game-stats-info','slug' => 'color-shr-recaps-game-stats-info','color' => '#1eb5d0'],
            ['name' => 'color-shr-recaps-game-stats-info-dark','slug' => 'color-shr-recaps-game-stats-info-dark','color' => '#0056a1'],
            ['name' => 'color-shr-recaps-content-title','slug' => 'color-shr-recaps-content-title','color' => '#3a96e0'],
            ['name' => 'color-shr-recaps-content-title-shadow','slug' => 'color-shr-recaps-content-title-shadow','color' => '#0056a1'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.sh-recap .game-header .teams .team',
                'fontWeight' => '600',
                'fontSize' => '2rem',
                'fontSizeTablet' => '1.8rem',
                'fontSizeMobile' => '1.5rem',
                'LineHeight' => '1.8rem',
                'LineHeightTablet' => '1.3rem',
                'LineHeightMobile' => '1.1rem',
            ],
            [
                'customSelector' => '.sh-recap .game-header .teams .vs',
                'fontSize' => '1.4rem',
                'fontSizeMobile' => '1.2rem',
                'fontWeight' => '600',
            ],
            [
                'customSelector' => '.sh-recap .game-header .date',
                'fontSize' => '1rem',
                'fontSizeMobile' => '0.8rem',
            ],
            [
                'customSelector' => '.sh-recap .game-header .date .sport',
                'fontWeight' => '500',
            ],
            [
                'customSelector' => '.sh-recap .game-body .content-teams .team .city',
                'fontWeight' => '600',
                'fontSize' => '1.25rem',
                'fontSizeTablet' => '1rem',
                'fontSizeMobile' => '1.25rem',
                'LineHeight' => '1.3rem',
            ],
            [
                'customSelector' => '.sh-recap .game-body .content-teams .team .name',
                'fontWeight' => '700',
                'fontSize' => '1.8rem',
                'fontSizeTablet' => '1.5rem',
                'fontSizeMobile' => '1.8rem',
            ],
            [
                'customSelector' => '.sh-recap .game-body .content-teams .team .team-score .score',
                'fontWeight' => '600',
                'fontSize' => '2rem',
                'fontSizeTablet' => '1.5rem',
            ],
            [
                'customSelector' => '.sh-recap .game-body .content-teams .team .team-name .stats .pill',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
        ];
    }
}

$sh_recap_class = new Shr_Blocks_Recap();
$sh_recap_class->init();

return $sh_recap_class;
