<?php 
    global $shr;
    $shr = (!empty($shr)) ? $shr : Sportshub_Recaps::instance();

    $block_styles = [];
    $block_classes = [BLOCK_SH_RECAP_LINKS];
    $block_game = $shr->settings->get_block(BLOCK_SH_RECAP_LINKS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $shr->helpers->get_blocks_spaces(get_fields());
    $types = (!empty(get_field('shr_content_types_members', 'options'))) ? get_field('shr_content_types_members', 'options') :[];

    $post = get_post();
    $links_block = (!empty(get_field('shr_game_links_block', $post))) ? get_field('shr_game_links_block', $post) : 'show';
?>
<?php if ((empty(get_option('shr_source')) || get_option('shr_source') == 'members') && $links_block == 'show'): ?>
    <div class="shr-blocks sticky">
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="container content grid-container">
                <div id="game-link-sticky-origin" class="links-body">
                    <div class="primary">
                        <span>ON THIS PAGE</span>
                    </div>
                    <div class="default">
                        <?php foreach ($types as $type): ?>
                            <?php if (isset($type['shr_content_type_slug_members']) 
                                && !empty($type['shr_content_type_slug_members']) 
                                && $type['shr_content_type_slug_members'] != 'knup_sports'
                                && isset($type['shr_content_type_block_icon_members']['url'])
                                && !empty($type['shr_content_type_block_icon_members']['url'])
                                && isset($type['shr_content_type_block_title_members'])
                                && !empty($type['shr_content_type_block_title_members'])
                            ): ?>
                                <div class="link">
                                    <a href="#block-recap-links-<?php echo $type['shr_content_type_slug_members'];?>">
                                        <img src="<?php echo $type['shr_content_type_block_icon_members']['url']; ?>" alt="">
                                        <?php echo $type['shr_content_type_block_title_members'];?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
